/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public final class PropertiesUtils {
    private PropertiesUtils() {
    }

    public static Map<String, String> readProperties(List<File> resourcePaths) throws IOException {
        Properties connectionProperties = new Properties();
        for (File resourcePath : resourcePaths) {
            Preconditions.checkArgument((boolean)resourcePath.exists(), (String)"File does not exist: %s", (Object)resourcePath);
            try (FileInputStream in = new FileInputStream(resourcePath);){
                connectionProperties.load(in);
            }
        }
        return ImmutableMap.copyOf((Map)Maps.fromProperties((Properties)connectionProperties));
    }
}

