/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.com.microsoft.azure.storage.table;

import io.trino.hadoop.$internal.com.microsoft.azure.storage.OperationContext;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.StorageException;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.core.PathUtility;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.core.UriQueryBuilder;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.core.Utility;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.table.MimeHeader;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.table.MimePart;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.table.QueryTableOperation;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.table.TableBatchOperation;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.table.TableEntitySerializer;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.table.TableOperation;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.table.TableOperationType;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.table.TablePayloadFormat;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.table.TableRequestOptions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;

final class MimeHelper {
    MimeHelper() {
    }

    static ArrayList<MimePart> readBatchResponseStream(InputStream inStream, String expectedBundaryName, OperationContext opContext, TablePayloadFormat format) throws IOException, StorageException {
        ArrayList<MimePart> result = new ArrayList<MimePart>();
        InputStreamReader streamReader = new InputStreamReader(inStream, "UTF-8");
        BufferedReader reader = new BufferedReader(streamReader);
        String mungedExpectedBoundaryName = "--".concat(expectedBundaryName);
        MimeHeader docHeader = MimeHelper.readMimeHeader(reader, opContext);
        if (docHeader.boundary == null || !docHeader.boundary.equals(mungedExpectedBoundaryName)) {
            throw MimeHelper.generateMimeParseException();
        }
        MimeHeader currHeader = null;
        if (docHeader.subBoundary == null) {
            do {
                result.add(MimeHelper.readMimePart(reader, docHeader.boundary, opContext));
            } while ((currHeader = MimeHelper.readMimeHeader(reader, opContext)) != null);
        } else {
            currHeader = MimeHelper.readMimeHeader(reader, opContext);
            if (currHeader == null) {
                throw MimeHelper.generateMimeParseException();
            }
            do {
                result.add(MimeHelper.readMimePart(reader, docHeader.subBoundary, opContext));
            } while ((currHeader = MimeHelper.readMimeHeader(reader, opContext)) != null);
        }
        return result;
    }

    static void writeBatchToStream(OutputStream outStream, TableRequestOptions options, String tableName, URI baseUri, TableBatchOperation batch, String batchID, String changeSet, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        boolean isQuery;
        OutputStreamWriter outWriter = new OutputStreamWriter(outStream, "UTF-8");
        int contentID = 0;
        boolean bl = isQuery = batch.size() == 1 && ((TableOperation)batch.get(0)).getOperationType() == TableOperationType.RETRIEVE;
        if (isQuery) {
            QueryTableOperation qOp = (QueryTableOperation)batch.get(0);
            MimeHelper.writeMIMEBoundary(outWriter, batchID);
            MimePart mimePart = new MimePart();
            mimePart.op = qOp.getOperationType();
            UriQueryBuilder builder = new UriQueryBuilder();
            mimePart.requestIdentity = builder.addToURI(PathUtility.appendPathToSingleUri(baseUri, qOp.generateRequestIdentityWithTable(tableName)));
            mimePart.headers.put("Accept", MimeHelper.generateAcceptHeaderValue(options.getTablePayloadFormat()));
            mimePart.headers.put("MaxDataServiceVersion", "3.0");
            outWriter.write(mimePart.toRequestString());
        } else {
            MimeHelper.writeMIMEBoundary(outWriter, batchID);
            MimeHelper.writeMIMEContentType(outWriter, changeSet);
            outWriter.write("\r\n");
            for (TableOperation op : batch) {
                MimeHelper.writeMIMEBoundary(outWriter, changeSet);
                MimePart mimePart = new MimePart();
                mimePart.op = op.getOperationType();
                UriQueryBuilder builder = new UriQueryBuilder();
                mimePart.requestIdentity = builder.addToURI(PathUtility.appendPathToSingleUri(baseUri, op.generateRequestIdentityWithTable(tableName)));
                mimePart.headers.put("Content-ID", Integer.toString(contentID));
                mimePart.headers.put("Accept", MimeHelper.generateAcceptHeaderValue(options.getTablePayloadFormat()));
                mimePart.headers.put("MaxDataServiceVersion", "3.0");
                if (op.getOperationType() == TableOperationType.INSERT_OR_MERGE || op.getOperationType() == TableOperationType.MERGE) {
                    options.assertNoEncryptionPolicyOrStrictMode();
                    mimePart.headers.put("X-HTTP-Method", TableOperationType.MERGE.toString());
                }
                if ((op.getOperationType() == TableOperationType.DELETE || op.getOperationType() == TableOperationType.REPLACE || op.getOperationType() == TableOperationType.MERGE) && op.getEntity() != null && op.getEntity().getEtag() != null) {
                    mimePart.headers.put("If-Match", op.getEntity().getEtag());
                }
                if (op.getOperationType() == TableOperationType.INSERT) {
                    mimePart.headers.put("Prefer", op.getEchoContent() ? "return-content" : "return-no-content");
                }
                if (op.getOperationType() != TableOperationType.DELETE) {
                    mimePart.headers.put("Content-Type", "application/json");
                    mimePart.payload = MimeHelper.writeStringForOperation(op, options, opContext);
                    mimePart.headers.put("Content-Length", Integer.toString(mimePart.payload.getBytes("UTF-8").length));
                }
                outWriter.write(mimePart.toRequestString());
                ++contentID;
            }
        }
        if (!isQuery) {
            MimeHelper.writeMIMEBoundaryClosure(outWriter, changeSet);
        }
        MimeHelper.writeMIMEBoundaryClosure(outWriter, batchID);
        outWriter.flush();
    }

    private static MimeHeader readMimeHeader(BufferedReader reader, OperationContext opContext) throws IOException, StorageException {
        String tempString;
        MimeHeader retHeader = new MimeHeader();
        reader.mark(0x100000);
        retHeader.boundary = MimeHelper.getNextLineSkippingBlankLines(reader);
        if (retHeader.boundary.endsWith("--")) {
            return null;
        }
        if (!retHeader.boundary.startsWith("--")) {
            reader.reset();
            return null;
        }
        for (int m3 = 0; m3 < 2 && (tempString = reader.readLine()) != null && tempString.length() != 0; ++m3) {
            String[] headerVals;
            if (tempString.startsWith("Content-Type:")) {
                headerVals = tempString.split("Content-Type: ");
                if (headerVals == null || headerVals.length != 2) {
                    throw MimeHelper.generateMimeParseException();
                }
                retHeader.contentType = headerVals[1];
                continue;
            }
            if (tempString.startsWith("Content-Transfer-Encoding:")) {
                headerVals = tempString.split("Content-Transfer-Encoding: ");
                if (headerVals == null || headerVals.length != 2) {
                    throw MimeHelper.generateMimeParseException();
                }
                retHeader.contentTransferEncoding = headerVals[1];
                continue;
            }
            throw MimeHelper.generateMimeParseException();
        }
        if (Utility.isNullOrEmpty(retHeader.boundary) || retHeader.contentType == null) {
            throw MimeHelper.generateMimeParseException();
        }
        if (retHeader.contentType.startsWith("multipart/mixed; boundary=")) {
            String[] headerVals = retHeader.contentType.split("multipart/mixed; boundary=");
            if (headerVals == null || headerVals.length != 2) {
                throw MimeHelper.generateMimeParseException();
            }
            retHeader.subBoundary = "--".concat(headerVals[1]);
        } else if (!retHeader.contentType.equals("application/http")) {
            throw MimeHelper.generateMimeParseException();
        }
        if (retHeader.contentTransferEncoding != null && !retHeader.contentTransferEncoding.equals("binary")) {
            throw MimeHelper.generateMimeParseException();
        }
        return retHeader;
    }

    private static MimePart readMimePart(BufferedReader reader, String boundary, OperationContext opContext) throws IOException, StorageException {
        MimePart retPart = new MimePart();
        String tempStr = MimeHelper.getNextLineSkippingBlankLines(reader);
        if (!tempStr.startsWith("HTTP/1.1 ")) {
            throw MimeHelper.generateMimeParseException();
        }
        String[] headerVals = tempStr.split(" ");
        if (headerVals.length < 3) {
            throw MimeHelper.generateMimeParseException();
        }
        retPart.httpStatusCode = Integer.parseInt(headerVals[1]);
        retPart.httpStatusMessage = tempStr.substring(13);
        tempStr = reader.readLine();
        while (tempStr != null && tempStr.length() > 0) {
            String[] headerParts = tempStr.split(": ");
            if (headerParts.length < 2) {
                throw MimeHelper.generateMimeParseException();
            }
            retPart.headers.put(headerParts[0], headerParts[1]);
            tempStr = reader.readLine();
        }
        reader.mark(0x100000);
        tempStr = MimeHelper.getNextLineSkippingBlankLines(reader);
        if (tempStr == null) {
            throw MimeHelper.generateMimeParseException();
        }
        if (tempStr.startsWith(boundary)) {
            reader.reset();
            retPart.payload = "";
            return retPart;
        }
        StringBuilder payloadBuilder = new StringBuilder();
        while (!tempStr.startsWith(boundary)) {
            payloadBuilder.append(tempStr);
            reader.mark(0x100000);
            tempStr = MimeHelper.getNextLineSkippingBlankLines(reader);
            if (tempStr != null) continue;
            throw MimeHelper.generateMimeParseException();
        }
        reader.reset();
        retPart.payload = payloadBuilder.toString();
        return retPart;
    }

    private static void writeMIMEBoundary(OutputStreamWriter outWriter, String boundaryID) throws IOException {
        outWriter.write(String.format("--%s\r\n", boundaryID));
    }

    private static void writeMIMEBoundaryClosure(OutputStreamWriter outWriter, String boundaryID) throws IOException {
        outWriter.write(String.format("--%s--\r\n", boundaryID));
    }

    private static void writeMIMEContentType(OutputStreamWriter outWriter, String boundaryName) throws IOException {
        outWriter.write(String.format("Content-Type: multipart/mixed; boundary=%s\r\n", boundaryName));
    }

    private static String writeStringForOperation(TableOperation operation, TableRequestOptions options, OperationContext opContext) throws StorageException, IOException {
        Utility.assertNotNull("entity", operation.getEntity());
        StringWriter outWriter = new StringWriter();
        TableEntitySerializer.writeSingleEntityToString(outWriter, options, operation.getEntity(), false, opContext);
        outWriter.write("\r\n");
        return outWriter.toString();
    }

    private static String generateAcceptHeaderValue(TablePayloadFormat payloadFormat) {
        if (payloadFormat == TablePayloadFormat.JsonFullMetadata) {
            return "application/json;odata=fullmetadata";
        }
        if (payloadFormat == TablePayloadFormat.Json) {
            return "application/json;odata=minimalmetadata";
        }
        return "application/json;odata=nometadata";
    }

    private static StorageException generateMimeParseException() {
        return new StorageException("OutOfRangeInput", "Invalid MIME response received.", 306, null, null);
    }

    private static String getNextLineSkippingBlankLines(BufferedReader reader) throws IOException {
        String tString = null;
        while ((tString = reader.readLine()) != null && tString.length() == 0) {
        }
        return tString;
    }
}

