/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.session;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import io.trino.plugin.session.SessionMatchSpec;
import io.trino.spi.session.SessionConfigurationContext;
import io.trino.spi.session.SessionPropertyConfigurationManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractSessionPropertyManager
implements SessionPropertyConfigurationManager {
    public final Map<String, String> getSystemSessionProperties(SessionConfigurationContext context) {
        Map<String, String> sessionProperties = this.getSessionProperties(context);
        return (Map)sessionProperties.entrySet().stream().filter(property -> !AbstractSessionPropertyManager.isCatalogSessionProperty(property)).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public final Map<String, Map<String, String>> getCatalogSessionProperties(SessionConfigurationContext context) {
        Map<String, String> sessionProperties = this.getSessionProperties(context);
        Table catalogsSessionProperties = (Table)sessionProperties.entrySet().stream().filter(AbstractSessionPropertyManager::isCatalogSessionProperty).collect(ImmutableTable.toImmutableTable(catalogProperty -> ((String)catalogProperty.getKey()).split("\\.", 2)[0], catalogProperty -> ((String)catalogProperty.getKey()).split("\\.", 2)[1], Map.Entry::getValue));
        return catalogsSessionProperties.rowMap();
    }

    protected abstract List<SessionMatchSpec> getSessionMatchSpecs();

    private Map<String, String> getSessionProperties(SessionConfigurationContext context) {
        HashMap<String, String> combinedProperties = new HashMap<String, String>();
        for (SessionMatchSpec sessionMatchSpec : this.getSessionMatchSpecs()) {
            combinedProperties.putAll(sessionMatchSpec.match(context));
        }
        return combinedProperties;
    }

    private static boolean isCatalogSessionProperty(Map.Entry<String, String> property) {
        return property.getKey().contains(".");
    }
}

