/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.projection;

import com.google.common.collect.ImmutableSet;
import io.trino.matching.Match;
import io.trino.plugin.base.expression.ConnectorExpressionRewriter;
import io.trino.plugin.base.projection.ProjectFunctionRule;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.expression.ConnectorExpression;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class ProjectFunctionRewriter<ProjectionResult, ExpressionResult> {
    private final ConnectorExpressionRewriter<ExpressionResult> connectorExpressionRewriter;
    private final Set<ProjectFunctionRule<ProjectionResult, ExpressionResult>> rules;

    public ProjectFunctionRewriter(ConnectorExpressionRewriter<ExpressionResult> connectorExpressionRewriter, Set<ProjectFunctionRule<ProjectionResult, ExpressionResult>> rules) {
        this.connectorExpressionRewriter = Objects.requireNonNull(connectorExpressionRewriter, "connectorExpressionRewriter is null");
        this.rules = ImmutableSet.copyOf((Collection)Objects.requireNonNull(rules, "rules is null"));
    }

    public Optional<ProjectionResult> rewrite(final ConnectorSession session, ConnectorTableHandle handle, ConnectorExpression projectionExpression, final Map<String, ColumnHandle> assignments) {
        Objects.requireNonNull(handle, "handle is null");
        Objects.requireNonNull(projectionExpression, "projectionExpression is null");
        Objects.requireNonNull(assignments, "assignments is null");
        ProjectFunctionRule.RewriteContext context = new ProjectFunctionRule.RewriteContext<ExpressionResult>(this){
            final /* synthetic */ ProjectFunctionRewriter this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Map<String, ColumnHandle> getAssignments() {
                return assignments;
            }

            @Override
            public ConnectorSession getSession() {
                return session;
            }

            @Override
            public Optional<ExpressionResult> rewriteExpression(ConnectorExpression expression) {
                return this.this$0.connectorExpressionRewriter.rewrite(session, expression, assignments);
            }
        };
        for (ProjectFunctionRule<ProjectionResult, ExpressionResult> rule : this.rules) {
            if (!rule.isEnabled(context.getSession())) continue;
            Iterator matches = rule.getPattern().match((Object)projectionExpression, (Object)context).iterator();
            while (matches.hasNext()) {
                Match match = (Match)matches.next();
                Optional<ProjectionResult> rewritten = rule.rewrite(handle, projectionExpression, match.captures(), context);
                if (!rewritten.isPresent()) continue;
                return rewritten;
            }
        }
        return Optional.empty();
    }
}

