/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.plugin.authentication.addon.gssapi;

import com.singlestore.jdbc.client.ReadableByteBuf;
import com.singlestore.jdbc.client.socket.Reader;
import com.singlestore.jdbc.client.socket.Writer;
import com.singlestore.jdbc.plugin.authentication.addon.gssapi.GssapiAuth;
import com.singlestore.jdbc.util.ThreadUtils;
import com.singlestore.jdbc.util.log.Logger;
import com.singlestore.jdbc.util.log.Loggers;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class StandardGssapiAuthentication
implements GssapiAuth {
    private final Logger logger = Loggers.getLogger(StandardGssapiAuthentication.class);

    @Override
    public void authenticate(Writer out, Reader in, String servicePrincipalName, String jaasApplicationName, String mechanisms) throws SQLException, IOException {
        block16: {
            String jaasEntryName;
            if ("".equals(servicePrincipalName)) {
                throw new SQLException("No principal name defined on server. Please set server variable \"gssapi-principal-name\" or set option \"servicePrincipalName\"", "28000");
            }
            String string = jaasEntryName = "".equals(jaasApplicationName) ? "Krb5ConnectorContext" : jaasApplicationName;
            if (System.getProperty("java.security.auth.login.config") == null) {
                File jaasConfFile;
                this.logger.debug("Using temp jaas.conf as java.security.auth.login.config");
                try {
                    jaasConfFile = File.createTempFile("jaas.conf", null);
                    try (PrintStream bos = new PrintStream(new FileOutputStream(jaasConfFile));){
                        bos.print("Krb5ConnectorContext {\ncom.sun.security.auth.module.Krb5LoginModule required useTicketCache=true debug=true renewTGT=true doNotPrompt=true; };");
                    }
                    jaasConfFile.deleteOnExit();
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
                System.setProperty("java.security.auth.login.config", jaasConfFile.getCanonicalPath());
            } else {
                this.logger.debug("Using {} as java.security.auth.login.config", System.getProperty("java.security.auth.login.config"));
            }
            try {
                LoginContext loginContext = new LoginContext(jaasEntryName);
                loginContext.login();
                Subject mySubject = loginContext.getSubject();
                if (!mySubject.getPrincipals().isEmpty()) {
                    try {
                        PrivilegedExceptionAction<Void> action = () -> {
                            try {
                                Oid krb5Mechanism = new Oid("1.2.840.113554.1.2.2");
                                GSSManager manager = GSSManager.getInstance();
                                GSSName peerName = manager.createName(servicePrincipalName, GSSName.NT_USER_NAME);
                                GSSContext context = manager.createContext(peerName, krb5Mechanism, null, 0);
                                context.requestMutualAuth(true);
                                byte[] inToken = new byte[]{};
                                while (true) {
                                    byte[] outToken;
                                    if ((outToken = context.initSecContext(inToken, 0, inToken.length)) != null) {
                                        out.writeBytes(outToken);
                                        out.flush();
                                    }
                                    if (!context.isEstablished()) {
                                        ReadableByteBuf buf = in.readReusablePacket();
                                        inToken = new byte[buf.readableBytes()];
                                        buf.readBytes(inToken);
                                        continue;
                                    }
                                    break;
                                }
                            }
                            catch (GSSException le) {
                                throw new SQLException("GSS-API authentication exception", "28000", 1045, le);
                            }
                            return null;
                        };
                        ThreadUtils.callAs(mySubject, () -> action);
                        break block16;
                    }
                    catch (Exception exception) {
                        throw new SQLException("GSS-API authentication exception", "28000", 1045, exception);
                    }
                }
                throw new SQLException("GSS-API authentication exception : no credential cache not found.", "28000", 1045);
            }
            catch (LoginException le) {
                throw new SQLException("GSS-API authentication exception", "28000", 1045, le);
            }
        }
    }
}

