/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.jmx;

import com.google.common.net.HostAndPort;
import com.google.inject.Inject;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import io.airlift.jmx.JmxConfig;
import io.airlift.log.Logger;
import java.io.IOException;
import java.util.Objects;
import java.util.Properties;
import javax.management.remote.JMXServiceURL;

public class JmxAgent {
    private static final Logger log = Logger.get(JmxAgent.class);
    private static final String JMX_REGISTRY_PORT = "com.sun.management.jmxremote.port";
    private static final String JMX_SERVER_PORT = "com.sun.management.jmxremote.rmi.port";
    private static final String ALLOW_SELF_ATTACH = "jdk.attach.allowAttachSelf";
    private final JMXServiceURL url;

    @Inject
    public JmxAgent(JmxConfig config) throws IOException {
        Integer configuredServerPort;
        int registryPort = Objects.requireNonNull(config.getRmiRegistryPort(), "RMI registry port is not configured");
        Integer existingRegistryPort = Integer.getInteger(JMX_REGISTRY_PORT);
        if (existingRegistryPort != null) {
            if (existingRegistryPort != registryPort) {
                throw new RuntimeException(String.format("System property '%s=%s' does match configured RMI registry port %s", JMX_REGISTRY_PORT, existingRegistryPort, registryPort));
            }
            if (existingRegistryPort.equals(0)) {
                throw new RuntimeException(String.format("JMX agent already running on an unknown port (system property '%s' is 0)", JMX_REGISTRY_PORT));
            }
        }
        int serverPort = 0;
        Integer existingServerPort = Integer.getInteger(JMX_SERVER_PORT);
        if (!Objects.equals(existingServerPort, configuredServerPort = config.getRmiServerPort())) {
            throw new RuntimeException(String.format("System property '%s=%s' does match configured RMI server port %s", JMX_SERVER_PORT, existingServerPort, configuredServerPort));
        }
        if (configuredServerPort != null && !configuredServerPort.equals(0)) {
            serverPort = configuredServerPort;
        }
        JMXServiceURL jmxUrl = new JMXServiceURL("rmi", null, registryPort);
        HostAndPort address = HostAndPort.fromParts((String)jmxUrl.getHost(), (int)jmxUrl.getPort());
        if (existingRegistryPort == null) {
            JmxAgent.startJmxAgent(registryPort, serverPort);
            log.info("JMX agent started and listening on %s", new Object[]{address});
        } else {
            log.info("JMX agent already running and listening on %s", new Object[]{address});
        }
        this.url = new JMXServiceURL(String.format("service:jmx:rmi:///jndi/rmi://%s:%s/jmxrmi", address.getHost(), address.getPort()));
    }

    public JMXServiceURL getUrl() {
        return this.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startJmxAgent(int registryPort, int serverPort) throws IOException {
        try {
            VirtualMachine virtualMachine = VirtualMachine.attach(Long.toString(JmxAgent.getProcessId()));
            try {
                virtualMachine.startLocalManagementAgent();
                Properties properties = new Properties();
                properties.setProperty(JMX_REGISTRY_PORT, Integer.toString(registryPort));
                properties.setProperty(JMX_SERVER_PORT, Integer.toString(serverPort));
                properties.setProperty("com.sun.management.jmxremote.authenticate", "false");
                properties.setProperty("com.sun.management.jmxremote.ssl", "false");
                virtualMachine.startManagementAgent(properties);
            }
            finally {
                virtualMachine.detach();
            }
        }
        catch (AttachNotSupportedException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            if (!Boolean.getBoolean(ALLOW_SELF_ATTACH)) {
                throw new IOException(String.format("%s (try adding '-D%s=true' to the JVM config)", e, ALLOW_SELF_ATTACH));
            }
            throw e;
        }
    }

    private static long getProcessId() {
        return ProcessHandle.current().pid();
    }
}

