/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.singlestore;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.plugin.base.expression.ConnectorExpressionRewriter;
import io.trino.plugin.base.mapping.IdentifierMapping;
import io.trino.plugin.base.util.JsonTypeUtil;
import io.trino.plugin.jdbc.BaseJdbcClient;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import io.trino.plugin.jdbc.BooleanWriteFunction;
import io.trino.plugin.jdbc.ColumnMapping;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.DecimalConfig;
import io.trino.plugin.jdbc.DecimalSessionSessionProperties;
import io.trino.plugin.jdbc.DoubleWriteFunction;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcErrorCode;
import io.trino.plugin.jdbc.JdbcJoinCondition;
import io.trino.plugin.jdbc.JdbcSortItem;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.plugin.jdbc.LongReadFunction;
import io.trino.plugin.jdbc.LongWriteFunction;
import io.trino.plugin.jdbc.ObjectWriteFunction;
import io.trino.plugin.jdbc.PredicatePushdownController;
import io.trino.plugin.jdbc.PreparedQuery;
import io.trino.plugin.jdbc.QueryBuilder;
import io.trino.plugin.jdbc.ReadFunction;
import io.trino.plugin.jdbc.RemoteTableName;
import io.trino.plugin.jdbc.SliceReadFunction;
import io.trino.plugin.jdbc.SliceWriteFunction;
import io.trino.plugin.jdbc.StandardColumnMappings;
import io.trino.plugin.jdbc.TypeHandlingJdbcSessionProperties;
import io.trino.plugin.jdbc.UnsupportedTypeHandling;
import io.trino.plugin.jdbc.WriteFunction;
import io.trino.plugin.jdbc.WriteMapping;
import io.trino.plugin.jdbc.expression.JdbcConnectorExpressionRewriterBuilder;
import io.trino.plugin.jdbc.expression.ParameterizedExpression;
import io.trino.plugin.jdbc.logging.RemoteQueryModifier;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.JoinCondition;
import io.trino.spi.connector.JoinStatistics;
import io.trino.spi.connector.JoinType;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Timestamps;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SingleStoreClient
extends BaseJdbcClient {
    static final int SINGLESTORE_DATE_TIME_MAX_PRECISION = 6;
    static final int SINGLESTORE_VARCHAR_MAX_LENGTH = 21844;
    static final int SINGLESTORE_TEXT_MAX_LENGTH = 65535;
    static final int SINGLESTORE_MEDIUMTEXT_MAX_LENGTH = 0xFFFFFF;
    private static final int ZERO_PRECISION_TIMESTAMP_COLUMN_SIZE = 19;
    private static final int ZERO_PRECISION_TIME_COLUMN_SIZE = 10;
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("uuuu-MM-dd");
    private static final Pattern UNSIGNED_TYPE_REGEX = Pattern.compile("(?i).*unsigned$");
    private final Type jsonType;
    private final ConnectorExpressionRewriter<ParameterizedExpression> connectorExpressionRewriter;

    @Inject
    public SingleStoreClient(BaseJdbcConfig config, ConnectionFactory connectionFactory, QueryBuilder queryBuilder, TypeManager typeManager, IdentifierMapping identifierMapping, RemoteQueryModifier queryModifier) {
        this(config, connectionFactory, queryBuilder, typeManager, identifierMapping, queryModifier, false);
    }

    protected SingleStoreClient(BaseJdbcConfig config, ConnectionFactory connectionFactory, QueryBuilder queryBuilder, TypeManager typeManager, IdentifierMapping identifierMapping, RemoteQueryModifier queryModifier, boolean supportsRetries) {
        super("`", connectionFactory, queryBuilder, config.getJdbcTypesMappedToVarchar(), identifierMapping, queryModifier, supportsRetries);
        Objects.requireNonNull(typeManager, "typeManager is null");
        this.jsonType = typeManager.getType(new TypeSignature("json", new TypeSignatureParameter[0]));
        this.connectorExpressionRewriter = JdbcConnectorExpressionRewriterBuilder.newBuilder().addStandardRules(arg_0 -> ((SingleStoreClient)this).quoted(arg_0)).withTypeClass("numeric_type", (Set)ImmutableSet.of((Object)"tinyint", (Object)"smallint", (Object)"integer", (Object)"bigint", (Object)"decimal", (Object)"double", (Object[])new String[0])).map("$equal(left: numeric_type, right: numeric_type)").to("left = right").map("$not_equal(left: numeric_type, right: numeric_type)").to("left <> right").map("$less_than(left: numeric_type, right: numeric_type)").to("left < right").map("$less_than_or_equal(left: numeric_type, right: numeric_type)").to("left <= right").map("$greater_than(left: numeric_type, right: numeric_type)").to("left > right").map("$greater_than_or_equal(left: numeric_type, right: numeric_type)").to("left >= right").build();
    }

    public boolean supportsAggregationPushdown(ConnectorSession session, JdbcTableHandle table, List<AggregateFunction> aggregates, Map<String, ColumnHandle> assignments, List<List<ColumnHandle>> groupingSets) {
        return SingleStoreClient.preventTextualTypeAggregationPushdown(groupingSets);
    }

    public Collection<String> listSchemas(Connection connection) {
        ImmutableSet immutableSet;
        block9: {
            ResultSet resultSet = connection.getMetaData().getCatalogs();
            try {
                ImmutableSet.Builder schemaNames = ImmutableSet.builder();
                while (resultSet.next()) {
                    String schemaName = resultSet.getString("TABLE_CAT");
                    if (!this.filterSchema(schemaName)) continue;
                    schemaNames.add((Object)schemaName);
                }
                immutableSet = schemaNames.build();
                if (resultSet == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            resultSet.close();
        }
        return immutableSet;
    }

    protected boolean filterSchema(String schemaName) {
        if (schemaName.equalsIgnoreCase("memsql")) {
            return false;
        }
        return super.filterSchema(schemaName);
    }

    protected void dropSchema(ConnectorSession session, Connection connection, String remoteSchemaName, boolean cascade) throws SQLException {
        if (!cascade) {
            try (ResultSet tables = this.getTables(connection, Optional.of(remoteSchemaName), Optional.empty());){
                if (tables.next()) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_EMPTY, "Cannot drop non-empty schema '%s'".formatted(remoteSchemaName));
                }
            }
        }
        this.execute(session, connection, "DROP SCHEMA " + this.quoted(remoteSchemaName));
    }

    public Optional<String> getTableComment(ResultSet resultSet) {
        return Optional.empty();
    }

    public Optional<ColumnMapping> toColumnMapping(ConnectorSession session, Connection connection, JdbcTypeHandle typeHandle) {
        String jdbcTypeName = (String)typeHandle.jdbcTypeName().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "Type name is missing: " + String.valueOf(typeHandle)));
        Optional mapping = this.getForcedMappingToVarchar(typeHandle);
        if (mapping.isPresent()) {
            return mapping;
        }
        Optional<ColumnMapping> unsignedMapping = SingleStoreClient.getUnsignedMapping(typeHandle);
        if (unsignedMapping.isPresent()) {
            return unsignedMapping;
        }
        if (jdbcTypeName.equalsIgnoreCase("json")) {
            return Optional.of(this.jsonColumnMapping());
        }
        switch (typeHandle.jdbcType()) {
            case -7: 
            case 16: {
                return Optional.of(StandardColumnMappings.booleanColumnMapping());
            }
            case -6: {
                return Optional.of(StandardColumnMappings.tinyintColumnMapping());
            }
            case 5: {
                return Optional.of(StandardColumnMappings.smallintColumnMapping());
            }
            case 4: {
                return Optional.of(StandardColumnMappings.integerColumnMapping());
            }
            case -5: {
                return Optional.of(StandardColumnMappings.bigintColumnMapping());
            }
            case 7: {
                return Optional.of(ColumnMapping.longMapping((Type)RealType.REAL, (resultSet, columnIndex) -> Float.floatToRawIntBits(resultSet.getFloat(columnIndex)), (LongWriteFunction)StandardColumnMappings.realWriteFunction(), (PredicatePushdownController)PredicatePushdownController.DISABLE_PUSHDOWN));
            }
            case 8: {
                return Optional.of(StandardColumnMappings.doubleColumnMapping());
            }
            case -15: 
            case 1: {
                return Optional.of(StandardColumnMappings.defaultCharColumnMapping((int)typeHandle.requiredColumnSize(), (boolean)false));
            }
            case -1: 
            case 12: {
                int columnSize = switch (jdbcTypeName) {
                    case "TINYTEXT" -> 255;
                    case "TEXT" -> 65535;
                    case "MEDIUMTEXT" -> 0xFFFFFF;
                    case "LONGTEXT" -> Integer.MAX_VALUE;
                    case "VARCHAR" -> typeHandle.requiredColumnSize();
                    default -> throw new IllegalStateException("Unexpected type: " + jdbcTypeName);
                };
                return Optional.of(SingleStoreClient.checkNullUsingBytes(StandardColumnMappings.defaultVarcharColumnMapping((int)columnSize, (boolean)false)));
            }
            case 3: {
                int precision = typeHandle.requiredColumnSize();
                int decimalDigits = typeHandle.requiredDecimalDigits();
                if (DecimalSessionSessionProperties.getDecimalRounding((ConnectorSession)session) == DecimalConfig.DecimalMapping.ALLOW_OVERFLOW && precision > 38) {
                    int scale = Math.min(decimalDigits, DecimalSessionSessionProperties.getDecimalDefaultScale((ConnectorSession)session));
                    return Optional.of(StandardColumnMappings.decimalColumnMapping((DecimalType)DecimalType.createDecimalType((int)38, (int)scale), (RoundingMode)DecimalSessionSessionProperties.getDecimalRoundingMode((ConnectorSession)session)));
                }
                if (precision > 38) break;
                return Optional.of(StandardColumnMappings.decimalColumnMapping((DecimalType)DecimalType.createDecimalType((int)precision, (int)Math.max(decimalDigits, 0))));
            }
            case -4: 
            case -3: 
            case -2: {
                return Optional.of(SingleStoreClient.checkNullUsingBytes(StandardColumnMappings.varbinaryColumnMapping()));
            }
            case 91: {
                return Optional.of(ColumnMapping.longMapping((Type)DateType.DATE, (LongReadFunction)StandardColumnMappings.dateReadFunctionUsingLocalDate(), (LongWriteFunction)SingleStoreClient.dateWriteFunction()));
            }
            case 92: {
                TimeType timeType = TimeType.createTimeType((int)SingleStoreClient.getTimePrecision(typeHandle.requiredColumnSize()));
                return Optional.of(ColumnMapping.longMapping((Type)timeType, (LongReadFunction)SingleStoreClient.singleStoreTimeReadFunction(timeType), (LongWriteFunction)StandardColumnMappings.timeWriteFunction((int)timeType.getPrecision())));
            }
            case 93: {
                TimestampType timestampType = TimestampType.createTimestampType((int)SingleStoreClient.getTimestampPrecision(typeHandle.requiredColumnSize()));
                return Optional.of(StandardColumnMappings.timestampColumnMapping((TimestampType)timestampType));
            }
        }
        if (TypeHandlingJdbcSessionProperties.getUnsupportedTypeHandling((ConnectorSession)session) == UnsupportedTypeHandling.CONVERT_TO_VARCHAR) {
            return SingleStoreClient.mapToUnboundedVarchar((JdbcTypeHandle)typeHandle);
        }
        return Optional.empty();
    }

    private static ColumnMapping checkNullUsingBytes(ColumnMapping mapping) {
        ReadFunction readFunction = mapping.getReadFunction();
        if (readFunction instanceof SliceReadFunction) {
            final SliceReadFunction sliceReadFunction = (SliceReadFunction)readFunction;
            SliceReadFunction wrapper = new SliceReadFunction(){

                public Slice readSlice(ResultSet resultSet, int columnIndex) throws SQLException {
                    return sliceReadFunction.readSlice(resultSet, columnIndex);
                }

                public boolean isNull(ResultSet resultSet, int columnIndex) throws SQLException {
                    resultSet.getBytes(columnIndex);
                    return resultSet.wasNull();
                }
            };
            return ColumnMapping.mapping((Type)mapping.getType(), (ReadFunction)wrapper, (WriteFunction)mapping.getWriteFunction(), (PredicatePushdownController)mapping.getPredicatePushdownController());
        }
        return mapping;
    }

    private static int getTimePrecision(int timeColumnSize) {
        if (timeColumnSize == 10) {
            return 0;
        }
        int timePrecision = timeColumnSize - 10 - 1;
        Verify.verify((1 <= timePrecision && timePrecision <= 6 ? 1 : 0) != 0, (String)"Unexpected time precision %s calculated from time column size %s", (int)timePrecision, (int)timeColumnSize);
        return timePrecision;
    }

    private static int getTimestampPrecision(int timestampColumnSize) {
        if (timestampColumnSize == 19) {
            return 0;
        }
        int timestampPrecision = timestampColumnSize - 19 - 1;
        Verify.verify((1 <= timestampPrecision && timestampPrecision <= 6 ? 1 : 0) != 0, (String)"Unexpected timestamp precision %s calculated from timestamp column size %s", (int)timestampPrecision, (int)timestampColumnSize);
        return timestampPrecision;
    }

    public ResultSet getTables(Connection connection, Optional<String> schemaName, Optional<String> tableName) throws SQLException {
        DatabaseMetaData metadata = connection.getMetaData();
        return metadata.getTables(schemaName.orElse(null), null, this.escapeObjectNameForMetadataQuery(tableName, metadata.getSearchStringEscape()).orElse(null), this.getTableTypes().map(types -> (String[])types.toArray(String[]::new)).orElse(null));
    }

    protected ResultSet getAllTableColumns(Connection connection, Optional<String> remoteSchemaName) throws SQLException {
        DatabaseMetaData metadata = connection.getMetaData();
        return metadata.getColumns(remoteSchemaName.orElse(null), null, null, null);
    }

    public void renameTable(ConnectorSession session, JdbcTableHandle handle, SchemaTableName newTableName) {
        RemoteTableName remoteTableName = handle.asPlainTable().getRemoteTableName();
        Verify.verify((boolean)remoteTableName.getSchemaName().isEmpty());
        String catalogName = remoteTableName.getCatalogName().orElse(null);
        if (catalogName != null && !catalogName.equalsIgnoreCase(newTableName.getSchemaName())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support renaming tables across schemas");
        }
        this.renameTable(session, null, catalogName, remoteTableName.getTableName(), newTableName);
    }

    protected void renameColumn(ConnectorSession session, Connection connection, RemoteTableName remoteTableName, String remoteColumnName, String newRemoteColumnName) throws SQLException {
        this.execute(session, connection, String.format("ALTER TABLE %s CHANGE %s %s", this.quoted(remoteTableName.getCatalogName().orElse(null), remoteTableName.getSchemaName().orElse(null), remoteTableName.getTableName()), this.quoted(remoteColumnName), this.quoted(newRemoteColumnName)));
    }

    public void setColumnType(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle column, Type type) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support setting column types");
    }

    public void dropNotNullConstraint(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle column) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support dropping a not null constraint");
    }

    public void renameSchema(ConnectorSession session, String schemaName, String newSchemaName) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support renaming schemas");
    }

    protected String getTableSchemaName(ResultSet resultSet) throws SQLException {
        return resultSet.getString("TABLE_CAT");
    }

    public WriteMapping toWriteMapping(ConnectorSession session, Type type) {
        if (type == BooleanType.BOOLEAN) {
            return WriteMapping.booleanMapping((String)"boolean", (BooleanWriteFunction)StandardColumnMappings.booleanWriteFunction());
        }
        if (type == TinyintType.TINYINT) {
            return WriteMapping.longMapping((String)"tinyint", (LongWriteFunction)StandardColumnMappings.tinyintWriteFunction());
        }
        if (type == SmallintType.SMALLINT) {
            return WriteMapping.longMapping((String)"smallint", (LongWriteFunction)StandardColumnMappings.smallintWriteFunction());
        }
        if (type == IntegerType.INTEGER) {
            return WriteMapping.longMapping((String)"integer", (LongWriteFunction)StandardColumnMappings.integerWriteFunction());
        }
        if (type == BigintType.BIGINT) {
            return WriteMapping.longMapping((String)"bigint", (LongWriteFunction)StandardColumnMappings.bigintWriteFunction());
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            String dataType = String.format("decimal(%s, %s)", decimalType.getPrecision(), decimalType.getScale());
            if (decimalType.isShort()) {
                return WriteMapping.longMapping((String)dataType, (LongWriteFunction)StandardColumnMappings.shortDecimalWriteFunction((DecimalType)decimalType));
            }
            return WriteMapping.objectMapping((String)dataType, (ObjectWriteFunction)StandardColumnMappings.longDecimalWriteFunction((DecimalType)decimalType));
        }
        if (RealType.REAL.equals((Object)type)) {
            return WriteMapping.longMapping((String)"float", (LongWriteFunction)StandardColumnMappings.realWriteFunction());
        }
        if (type == DoubleType.DOUBLE) {
            return WriteMapping.doubleMapping((String)"double precision", (DoubleWriteFunction)StandardColumnMappings.doubleWriteFunction());
        }
        if (type instanceof CharType) {
            CharType charType = (CharType)type;
            return WriteMapping.sliceMapping((String)("char(" + charType.getLength() + ")"), (SliceWriteFunction)StandardColumnMappings.charWriteFunction());
        }
        if (type instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)type;
            Object dataType = varcharType.isUnbounded() ? "longtext" : (varcharType.getBoundedLength() <= 21844 ? "varchar(" + varcharType.getBoundedLength() + ")" : (varcharType.getBoundedLength() <= 65535 ? "text" : (varcharType.getBoundedLength() <= 0xFFFFFF ? "mediumtext" : "longtext")));
            return WriteMapping.sliceMapping((String)dataType, (SliceWriteFunction)StandardColumnMappings.varcharWriteFunction());
        }
        if (VarbinaryType.VARBINARY.equals((Object)type)) {
            return WriteMapping.sliceMapping((String)"longblob", (SliceWriteFunction)StandardColumnMappings.varbinaryWriteFunction());
        }
        if (type == DateType.DATE) {
            return WriteMapping.longMapping((String)"date", (LongWriteFunction)SingleStoreClient.dateWriteFunction());
        }
        if (type instanceof TimeType) {
            TimeType timeType = (TimeType)type;
            Preconditions.checkArgument((timeType.getPrecision() <= 6 ? 1 : 0) != 0, (Object)"The max time precision in SingleStore is 6");
            if (timeType.getPrecision() == 0) {
                return WriteMapping.longMapping((String)"time", (LongWriteFunction)StandardColumnMappings.timeWriteFunction((int)0));
            }
            return WriteMapping.longMapping((String)"time(6)", (LongWriteFunction)StandardColumnMappings.timeWriteFunction((int)6));
        }
        if (type instanceof TimestampType) {
            TimestampType timestampType = (TimestampType)type;
            Preconditions.checkArgument((timestampType.getPrecision() <= 6 ? 1 : 0) != 0, (Object)"The max timestamp precision in SingleStore is 6");
            if (timestampType.getPrecision() == 0) {
                return WriteMapping.longMapping((String)"datetime", (LongWriteFunction)StandardColumnMappings.timestampWriteFunction((TimestampType)timestampType));
            }
            return WriteMapping.longMapping((String)String.format("datetime(%s)", 6), (LongWriteFunction)StandardColumnMappings.timestampWriteFunction((TimestampType)TimestampType.TIMESTAMP_MICROS));
        }
        if (type.equals((Object)this.jsonType)) {
            return WriteMapping.sliceMapping((String)"json", (SliceWriteFunction)StandardColumnMappings.varcharWriteFunction());
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported column type: " + type.getDisplayName());
    }

    protected Optional<BiFunction<String, Long, String>> limitFunction() {
        return Optional.of((sql, limit) -> sql + " LIMIT " + limit);
    }

    public boolean isLimitGuaranteed(ConnectorSession session) {
        return true;
    }

    public boolean supportsTopN(ConnectorSession session, JdbcTableHandle handle, List<JdbcSortItem> sortOrder) {
        for (JdbcSortItem sortItem : sortOrder) {
            Type sortItemType = sortItem.column().getColumnType();
            if (!(sortItemType instanceof CharType) && !(sortItemType instanceof VarcharType)) continue;
            return false;
        }
        return true;
    }

    protected Optional<BaseJdbcClient.TopNFunction> topNFunction() {
        return Optional.of((query, sortItems, limit) -> {
            String orderBy = sortItems.stream().flatMap(sortItem -> {
                String ordering = sortItem.sortOrder().isAscending() ? "ASC" : "DESC";
                String columnSorting = String.format("%s %s", this.quoted(sortItem.column().getColumnName()), ordering);
                return switch (sortItem.sortOrder()) {
                    default -> throw new MatchException(null, null);
                    case SortOrder.ASC_NULLS_FIRST, SortOrder.DESC_NULLS_LAST -> Stream.of(columnSorting);
                    case SortOrder.ASC_NULLS_LAST -> Stream.of(String.format("ISNULL(%s) ASC", this.quoted(sortItem.column().getColumnName())), columnSorting);
                    case SortOrder.DESC_NULLS_FIRST -> Stream.of(String.format("ISNULL(%s) DESC", this.quoted(sortItem.column().getColumnName())), columnSorting);
                };
            }).collect(Collectors.joining(", "));
            return String.format("%s ORDER BY %s LIMIT %s", query, orderBy, limit);
        });
    }

    public boolean isTopNGuaranteed(ConnectorSession session) {
        return true;
    }

    public Optional<ParameterizedExpression> convertPredicate(ConnectorSession session, ConnectorExpression expression, Map<String, ColumnHandle> assignments) {
        return this.connectorExpressionRewriter.rewrite(session, expression, assignments);
    }

    public Optional<PreparedQuery> implementJoin(ConnectorSession session, JoinType joinType, PreparedQuery leftSource, Map<JdbcColumnHandle, String> leftProjections, PreparedQuery rightSource, Map<JdbcColumnHandle, String> rightProjections, List<ParameterizedExpression> joinConditions, JoinStatistics statistics) {
        if (joinType == JoinType.FULL_OUTER) {
            return Optional.empty();
        }
        return super.implementJoin(session, joinType, leftSource, leftProjections, rightSource, rightProjections, joinConditions, statistics);
    }

    public Optional<PreparedQuery> legacyImplementJoin(ConnectorSession session, JoinType joinType, PreparedQuery leftSource, PreparedQuery rightSource, List<JdbcJoinCondition> joinConditions, Map<JdbcColumnHandle, String> rightAssignments, Map<JdbcColumnHandle, String> leftAssignments, JoinStatistics statistics) {
        if (joinType == JoinType.FULL_OUTER) {
            return Optional.empty();
        }
        return super.legacyImplementJoin(session, joinType, leftSource, rightSource, joinConditions, rightAssignments, leftAssignments, statistics);
    }

    protected boolean isSupportedJoinCondition(ConnectorSession session, JdbcJoinCondition joinCondition) {
        if (joinCondition.getOperator() == JoinCondition.Operator.IDENTICAL) {
            return false;
        }
        return Stream.of(joinCondition.getLeftColumn(), joinCondition.getRightColumn()).map(JdbcColumnHandle::getColumnType).noneMatch(type -> type instanceof CharType || type instanceof VarcharType);
    }

    private static Optional<ColumnMapping> getUnsignedMapping(JdbcTypeHandle typeHandle) {
        if (typeHandle.jdbcTypeName().isEmpty()) {
            return Optional.empty();
        }
        String typeName = (String)typeHandle.jdbcTypeName().get();
        if (UNSIGNED_TYPE_REGEX.matcher(typeName).matches()) {
            switch (typeHandle.jdbcType()) {
                case -7: {
                    return Optional.of(StandardColumnMappings.booleanColumnMapping());
                }
                case -6: {
                    return Optional.of(StandardColumnMappings.smallintColumnMapping());
                }
                case 5: {
                    return Optional.of(StandardColumnMappings.integerColumnMapping());
                }
                case 4: {
                    return Optional.of(StandardColumnMappings.bigintColumnMapping());
                }
                case -5: {
                    return Optional.of(StandardColumnMappings.decimalColumnMapping((DecimalType)DecimalType.createDecimalType((int)20)));
                }
            }
        }
        return Optional.empty();
    }

    private static LongReadFunction singleStoreTimeReadFunction(TimeType timeType) {
        Objects.requireNonNull(timeType, "timeType is null");
        Preconditions.checkArgument((timeType.getPrecision() <= 9 ? 1 : 0) != 0, (String)"Unsupported type precision: %s", (Object)timeType);
        return (resultSet, columnIndex) -> {
            String timeString = resultSet.getString(columnIndex);
            try {
                long nanosOfDay = LocalTime.from(DateTimeFormatter.ISO_LOCAL_TIME.parse(timeString)).toNanoOfDay();
                Verify.verify((nanosOfDay < 86400000000000L ? 1 : 0) != 0, (String)"Invalid value of nanosOfDay: %s", (long)nanosOfDay);
                long picosOfDay = nanosOfDay * 1000L;
                long rounded = Timestamps.round((long)picosOfDay, (int)(12 - timeType.getPrecision()));
                if (rounded == 86400000000000000L) {
                    rounded = 0L;
                }
                return rounded;
            }
            catch (DateTimeParseException e) {
                throw new IllegalStateException(String.format("Supported Trino TIME type range is between 00:00:00 and 23:59:59.999999 but got %s", timeString), e);
            }
        };
    }

    private static LongWriteFunction dateWriteFunction() {
        return (statement, index, day) -> statement.setString(index, DATE_FORMATTER.format(LocalDate.ofEpochDay(day)));
    }

    private ColumnMapping jsonColumnMapping() {
        return ColumnMapping.sliceMapping((Type)this.jsonType, (resultSet, columnIndex) -> JsonTypeUtil.jsonParse((Slice)Slices.utf8Slice((String)resultSet.getString(columnIndex))), (SliceWriteFunction)StandardColumnMappings.varcharWriteFunction(), (PredicatePushdownController)PredicatePushdownController.DISABLE_PUSHDOWN);
    }
}

