/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.plugin;

import com.singlestore.jdbc.client.ColumnDecoder;
import com.singlestore.jdbc.client.Context;
import com.singlestore.jdbc.client.ReadableByteBuf;
import com.singlestore.jdbc.client.socket.Writer;
import com.singlestore.jdbc.client.util.MutableInt;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.util.Calendar;

public interface Codec<T> {
    public String className();

    public boolean canDecode(ColumnDecoder var1, Class<?> var2);

    public boolean canEncode(Object var1);

    public int getApproximateTextProtocolLength(Object var1) throws SQLException;

    public T decodeText(ReadableByteBuf var1, MutableInt var2, ColumnDecoder var3, Calendar var4) throws SQLDataException;

    public T decodeBinary(ReadableByteBuf var1, MutableInt var2, ColumnDecoder var3, Calendar var4) throws SQLDataException;

    public void encodeText(Writer var1, Context var2, Object var3, Calendar var4, Long var5) throws IOException, SQLException;

    public void encodeBinary(Writer var1, Object var2, Calendar var3, Long var4) throws IOException, SQLException;

    default public boolean canEncodeLongData() {
        return false;
    }

    default public void encodeLongData(Writer encoder, T value, Long length) throws IOException, SQLException {
        throw new SQLException("Data is not supposed to be send in COM_STMT_LONG_DATA");
    }

    default public byte[] encodeData(T value, Long length) throws IOException, SQLException {
        throw new SQLException("Data is not supposed to be send in COM_STMT_LONG_DATA");
    }

    public int getBinaryEncodeType();

    default public void encodeBinaryAsString(Writer encoder, Object value, Long length) throws IOException {
        byte[] b = value.toString().getBytes(StandardCharsets.UTF_8);
        int len = length != null ? Math.min(length.intValue(), b.length) : b.length;
        encoder.writeLength(len);
        encoder.writeBytes(b, 0, len);
    }
}

