/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.plugin.codec;

import com.singlestore.jdbc.client.ColumnDecoder;
import com.singlestore.jdbc.client.Context;
import com.singlestore.jdbc.client.DataType;
import com.singlestore.jdbc.client.ReadableByteBuf;
import com.singlestore.jdbc.client.socket.Writer;
import com.singlestore.jdbc.client.util.MutableInt;
import com.singlestore.jdbc.plugin.Codec;
import java.io.IOException;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.EnumSet;

public class ByteCodec
implements Codec<Byte> {
    public static final ByteCodec INSTANCE = new ByteCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.TINYINT, new DataType[]{DataType.SMALLINT, DataType.MEDIUMINT, DataType.INT, DataType.BIGINT, DataType.YEAR, DataType.BIT, DataType.FLOAT, DataType.DOUBLE, DataType.OLDDECIMAL, DataType.BLOB, DataType.TINYBLOB, DataType.MEDIUMBLOB, DataType.LONGBLOB, DataType.DECIMAL, DataType.ENUM, DataType.CHAR, DataType.VARCHAR});

    public static long parseBit(ReadableByteBuf buf, MutableInt length) {
        if (length.get() == 1) {
            return buf.readUnsignedByte();
        }
        long val = 0L;
        int idx = 0;
        do {
            val += (long)buf.readUnsignedByte() << 8 * length.get();
        } while (++idx < length.get());
        return val;
    }

    @Override
    public String className() {
        return Byte.class.getName();
    }

    @Override
    public boolean canDecode(ColumnDecoder column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && (type.isPrimitive() && type == Byte.TYPE || type.isAssignableFrom(Byte.class));
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Byte;
    }

    @Override
    public int getApproximateTextProtocolLength(Object value) throws SQLException {
        return this.canEncode(value) ? String.valueOf(value).length() : -1;
    }

    @Override
    public Byte decodeText(ReadableByteBuf buffer, MutableInt length, ColumnDecoder column, Calendar cal) throws SQLDataException {
        return column.decodeByteText(buffer, length);
    }

    @Override
    public Byte decodeBinary(ReadableByteBuf buffer, MutableInt length, ColumnDecoder column, Calendar cal) throws SQLDataException {
        return column.decodeByteBinary(buffer, length);
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object value, Calendar cal, Long maxLength) throws IOException {
        encoder.writeAscii(Integer.toString(((Byte)value).byteValue()));
    }

    @Override
    public void encodeBinary(Writer encoder, Object value, Calendar cal, Long maxLength) throws IOException {
        encoder.writeByte(((Byte)value).byteValue());
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.TINYINT.get();
    }
}

