/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.plugin.codec;

import com.singlestore.jdbc.client.ColumnDecoder;
import com.singlestore.jdbc.client.Context;
import com.singlestore.jdbc.client.DataType;
import com.singlestore.jdbc.client.ReadableByteBuf;
import com.singlestore.jdbc.client.socket.Writer;
import com.singlestore.jdbc.client.util.MutableInt;
import com.singlestore.jdbc.plugin.Codec;
import com.singlestore.jdbc.plugin.codec.ByteArrayCodec;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.EnumSet;

public class StreamCodec
implements Codec<InputStream> {
    public static final StreamCodec INSTANCE = new StreamCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.BLOB, new DataType[]{DataType.TINYBLOB, DataType.MEDIUMBLOB, DataType.LONGBLOB, DataType.VARCHAR, DataType.CHAR, DataType.BLOB, DataType.TINYBLOB, DataType.MEDIUMBLOB, DataType.LONGBLOB});

    @Override
    public String className() {
        return InputStream.class.getName();
    }

    @Override
    public boolean canDecode(ColumnDecoder column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && type.isAssignableFrom(InputStream.class);
    }

    @Override
    public InputStream decodeText(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal) throws SQLDataException {
        switch (column.getType()) {
            case CHAR: 
            case VARCHAR: 
            case BLOB: 
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: {
                ByteArrayInputStream is = new ByteArrayInputStream(buf.buf(), buf.pos(), length.get());
                buf.skip(length.get());
                return is;
            }
        }
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Stream", new Object[]{column.getType()}));
    }

    @Override
    public InputStream decodeBinary(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal) throws SQLDataException {
        switch (column.getType()) {
            case CHAR: 
            case VARCHAR: 
            case BLOB: 
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: {
                ByteArrayInputStream is = new ByteArrayInputStream(buf.buf(), buf.pos(), length.get());
                buf.skip(length.get());
                return is;
            }
        }
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Stream", new Object[]{column.getType()}));
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof InputStream;
    }

    @Override
    public int getApproximateTextProtocolLength(Object value) throws SQLException {
        return -1;
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object value, Calendar cal, Long maxLen) throws IOException {
        encoder.writeBytes(ByteArrayCodec.BINARY_PREFIX);
        byte[] array = new byte[4096];
        InputStream stream = (InputStream)value;
        if (maxLen == null) {
            int len;
            while ((len = stream.read(array)) > 0) {
                encoder.writeBytesEscaped(array, len, (context.getServerStatus() & 0x200) != 0);
            }
        } else {
            int len;
            while ((len = stream.read(array)) > 0 && maxLen > 0L) {
                encoder.writeBytesEscaped(array, Math.min(len, maxLen.intValue()), (context.getServerStatus() & 0x200) != 0);
                maxLen = maxLen - (long)len;
            }
        }
        encoder.writeByte(39);
    }

    @Override
    public void encodeBinary(Writer encoder, Object value, Calendar cal, Long maxLength) throws IOException {
        byte[] blobBytes = new byte[4096];
        int pos = 0;
        byte[] array = new byte[4096];
        InputStream stream = (InputStream)value;
        if (maxLength == null) {
            int len;
            while ((len = stream.read(array)) > 0) {
                if (blobBytes.length - pos < len) {
                    byte[] newBlobBytes = new byte[blobBytes.length + 65536];
                    System.arraycopy(blobBytes, 0, newBlobBytes, 0, blobBytes.length);
                    blobBytes = newBlobBytes;
                }
                System.arraycopy(array, 0, blobBytes, pos, len);
                pos += len;
            }
        } else {
            int len;
            for (long remainingLen = maxLength.longValue(); (len = stream.read(array)) > 0 && remainingLen > 0L; remainingLen -= (long)len) {
                if (blobBytes.length - pos < (len = Math.min((int)remainingLen, len))) {
                    byte[] newBlobBytes = new byte[blobBytes.length + 65536];
                    System.arraycopy(blobBytes, 0, newBlobBytes, 0, blobBytes.length);
                    blobBytes = newBlobBytes;
                }
                System.arraycopy(array, 0, blobBytes, pos, len);
                pos += len;
            }
        }
        encoder.writeLength(pos);
        encoder.writeBytes(blobBytes, 0, pos);
    }

    @Override
    public void encodeLongData(Writer encoder, InputStream value, Long maxLength) throws IOException {
        byte[] array = new byte[4096];
        if (maxLength == null) {
            int len;
            while ((len = value.read(array)) > 0) {
                encoder.writeBytes(array, 0, len);
            }
        } else {
            int len;
            for (long maxLen = maxLength.longValue(); (len = value.read(array)) > 0 && maxLen > 0L; maxLen -= (long)len) {
                encoder.writeBytes(array, 0, Math.min(len, (int)maxLen));
            }
        }
    }

    @Override
    public byte[] encodeData(InputStream value, Long maxLength) throws IOException {
        ByteArrayOutputStream bb = new ByteArrayOutputStream();
        byte[] array = new byte[4096];
        if (maxLength == null) {
            int len;
            while ((len = value.read(array)) > 0) {
                bb.write(array, 0, len);
            }
        } else {
            int len;
            for (long maxLen = maxLength.longValue(); (len = value.read(array)) > 0 && maxLen > 0L; maxLen -= (long)len) {
                bb.write(array, 0, Math.min(len, (int)maxLen));
            }
        }
        return bb.toByteArray();
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.BLOB.get();
    }
}

