/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.plugin.credential.browser.keyring;

import com.singlestore.jdbc.plugin.credential.browser.ExpiringCredential;
import com.singlestore.jdbc.plugin.credential.browser.keyring.Keyring;
import com.singlestore.jdbc.util.log.Logger;
import com.singlestore.jdbc.util.log.Loggers;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.freedesktop.secret.simple.SimpleCollection;

public class LinuxKeyring
implements Keyring {
    private static final Map<String, String> ATTRIBUTES = Collections.singletonMap("application", "singlestore-jdbc");
    final SimpleCollection collection;
    private final Logger logger;

    public LinuxKeyring() throws IOException {
        try {
            this.collection = new SimpleCollection();
            this.logger = Loggers.getLogger(LinuxKeyring.class);
        }
        catch (IOException e) {
            throw new IOException("Error while accessing GNOME Keyring", e);
        }
    }

    @Override
    public ExpiringCredential getCredential() {
        String entryPath = this.getExistingEntry();
        if (entryPath == null) {
            return null;
        }
        try {
            return Keyring.fromBlob(String.valueOf(this.collection.getSecret(entryPath)));
        }
        catch (IOException e) {
            this.logger.debug("Error while parsing cached token from the GNOME Keyring", e);
            return null;
        }
    }

    @Override
    public void setCredential(ExpiringCredential cred) {
        String entryPath = this.getExistingEntry();
        String credBlob = Keyring.makeBlob(cred);
        if (entryPath == null) {
            entryPath = this.collection.createItem("SingleStore JDBC Safe Storage", (CharSequence)credBlob);
        }
        if (entryPath != null) {
            this.collection.updateItem(entryPath, "SingleStore JDBC Safe Storage", (CharSequence)credBlob, ATTRIBUTES);
        } else {
            this.logger.warn("Failed to save credentials in the GNOME keyring");
        }
    }

    @Override
    public void deleteCredential() {
        String entryPath = this.getExistingEntry();
        if (entryPath != null) {
            this.collection.updateItem(entryPath, "SingleStore JDBC Safe Storage", (CharSequence)"", ATTRIBUTES);
        }
    }

    private String getExistingEntry() {
        String foundPath = null;
        List entires = this.collection.getItems(ATTRIBUTES);
        if (entires != null) {
            for (String entry : this.collection.getItems(ATTRIBUTES)) {
                if (!this.collection.getLabel(entry).equals("SingleStore JDBC Safe Storage")) continue;
                if (foundPath != null) {
                    this.logger.debug("Found multiple keychain entries matching \"SingleStore JDBC Safe Storage\"");
                    return null;
                }
                foundPath = entry;
            }
        }
        return foundPath;
    }
}

