/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.snowflake;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.airlift.slice.Slice;
import io.trino.plugin.base.aggregation.AggregateFunctionRewriter;
import io.trino.plugin.base.expression.ConnectorExpressionRewriter;
import io.trino.plugin.base.mapping.IdentifierMapping;
import io.trino.plugin.jdbc.BaseJdbcClient;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import io.trino.plugin.jdbc.BooleanWriteFunction;
import io.trino.plugin.jdbc.ColumnMapping;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.DoubleWriteFunction;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcErrorCode;
import io.trino.plugin.jdbc.JdbcExpression;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.plugin.jdbc.LongWriteFunction;
import io.trino.plugin.jdbc.ObjectReadFunction;
import io.trino.plugin.jdbc.ObjectWriteFunction;
import io.trino.plugin.jdbc.PredicatePushdownController;
import io.trino.plugin.jdbc.QueryBuilder;
import io.trino.plugin.jdbc.SliceReadFunction;
import io.trino.plugin.jdbc.SliceWriteFunction;
import io.trino.plugin.jdbc.StandardColumnMappings;
import io.trino.plugin.jdbc.WriteMapping;
import io.trino.plugin.jdbc.aggregation.ImplementAvgDecimal;
import io.trino.plugin.jdbc.aggregation.ImplementAvgFloatingPoint;
import io.trino.plugin.jdbc.aggregation.ImplementCount;
import io.trino.plugin.jdbc.aggregation.ImplementCountAll;
import io.trino.plugin.jdbc.aggregation.ImplementMinMax;
import io.trino.plugin.jdbc.aggregation.ImplementSum;
import io.trino.plugin.jdbc.expression.JdbcConnectorExpressionRewriterBuilder;
import io.trino.plugin.jdbc.logging.RemoteQueryModifier;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.CharType;
import io.trino.spi.type.Chars;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Timestamps;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.BiFunction;

public class SnowflakeClient
extends BaseJdbcClient {
    private static final int MAX_SUPPORTED_TEMPORAL_PRECISION = 9;
    private static final DateTimeFormatter SNOWFLAKE_DATETIME_FORMATTER = DateTimeFormatter.ofPattern("u-MM-dd'T'HH:mm:ss.SSSSSSSSSXXX");
    private static final DateTimeFormatter SNOWFLAKE_DATE_FORMATTER = DateTimeFormatter.ofPattern("uuuu-MM-dd");
    private static final DateTimeFormatter SNOWFLAKE_TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("u-MM-dd'T'HH:mm:ss.SSSSSSSSS");
    private static final DateTimeFormatter SNOWFLAKE_TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss.SSSSSSSSS");
    private static final TimeZone UTC_TZ = TimeZone.getTimeZone(ZoneId.of("UTC"));
    private final AggregateFunctionRewriter<JdbcExpression, ?> aggregateFunctionRewriter;

    @Inject
    public SnowflakeClient(BaseJdbcConfig config, ConnectionFactory connectionFactory, QueryBuilder queryBuilder, IdentifierMapping identifierMapping, RemoteQueryModifier remoteQueryModifier) {
        super("\"", connectionFactory, queryBuilder, config.getJdbcTypesMappedToVarchar(), identifierMapping, remoteQueryModifier, false);
        JdbcTypeHandle bigintTypeHandle = new JdbcTypeHandle(-5, Optional.of("bigint"), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        ConnectorExpressionRewriter connectorExpressionRewriter = JdbcConnectorExpressionRewriterBuilder.newBuilder().addStandardRules(arg_0 -> ((SnowflakeClient)this).quoted(arg_0)).build();
        this.aggregateFunctionRewriter = new AggregateFunctionRewriter(connectorExpressionRewriter, (Set)ImmutableSet.builder().add((Object)new ImplementCountAll(bigintTypeHandle)).add((Object)new ImplementCount(bigintTypeHandle)).add((Object)new ImplementMinMax(false)).add((Object)new ImplementSum(SnowflakeClient::toTypeHandle)).add((Object)new ImplementAvgFloatingPoint()).add((Object)new ImplementAvgDecimal()).build());
    }

    public Optional<ColumnMapping> toColumnMapping(ConnectorSession session, Connection connection, JdbcTypeHandle typeHandle) {
        String jdbcTypeName = (String)typeHandle.getJdbcTypeName().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "Type name is missing: " + String.valueOf(typeHandle)));
        jdbcTypeName = jdbcTypeName.toLowerCase(Locale.ENGLISH);
        int type = typeHandle.getJdbcType();
        ImmutableMap standardColumnMappings = ImmutableMap.builder().put((Object)16, (Object)StandardColumnMappings.booleanColumnMapping()).put((Object)-6, (Object)StandardColumnMappings.tinyintColumnMapping()).put((Object)5, (Object)StandardColumnMappings.smallintColumnMapping()).put((Object)4, (Object)StandardColumnMappings.integerColumnMapping()).put((Object)-5, (Object)StandardColumnMappings.bigintColumnMapping()).put((Object)7, (Object)StandardColumnMappings.realColumnMapping()).put((Object)8, (Object)StandardColumnMappings.doubleColumnMapping()).put((Object)6, (Object)StandardColumnMappings.doubleColumnMapping()).put((Object)-2, (Object)StandardColumnMappings.varbinaryColumnMapping()).put((Object)-3, (Object)StandardColumnMappings.varbinaryColumnMapping()).put((Object)-4, (Object)StandardColumnMappings.varbinaryColumnMapping()).buildOrThrow();
        ColumnMapping columnMap = (ColumnMapping)standardColumnMappings.get(type);
        if (columnMap != null) {
            return Optional.of(columnMap);
        }
        ImmutableMap snowflakeColumnMappings = ImmutableMap.builder().put((Object)"time", handle -> Optional.of(SnowflakeClient.timeColumnMapping(handle.getRequiredDecimalDigits()))).put((Object)"timestampntz", handle -> Optional.of(SnowflakeClient.timestampColumnMapping(handle.getRequiredDecimalDigits()))).put((Object)"timestamptz", handle -> Optional.of(SnowflakeClient.timestampTZColumnMapping(handle.getRequiredDecimalDigits()))).put((Object)"date", handle -> Optional.of(ColumnMapping.longMapping((Type)DateType.DATE, (resultSet, columnIndex) -> LocalDate.ofEpochDay(resultSet.getLong(columnIndex)).toEpochDay(), (LongWriteFunction)SnowflakeClient.snowFlakeDateWriter()))).put((Object)"varchar", handle -> Optional.of(SnowflakeClient.varcharColumnMapping(handle.getRequiredColumnSize()))).put((Object)"number", handle -> {
            int decimalDigits = handle.getRequiredDecimalDigits();
            int precision = handle.getRequiredColumnSize() + Math.max(-decimalDigits, 0);
            if (precision > 38) {
                return Optional.empty();
            }
            return Optional.of(SnowflakeClient.columnMappingPushdown(StandardColumnMappings.decimalColumnMapping((DecimalType)DecimalType.createDecimalType((int)precision, (int)Math.max(decimalDigits, 0)), (RoundingMode)RoundingMode.UNNECESSARY)));
        }).buildOrThrow();
        ColumnMappingFunction columnMappingFunction = (ColumnMappingFunction)snowflakeColumnMappings.get(jdbcTypeName);
        if (columnMappingFunction != null) {
            return columnMappingFunction.convert(typeHandle);
        }
        return Optional.empty();
    }

    public WriteMapping toWriteMapping(ConnectorSession session, Type type) {
        Class myClass = type.getClass();
        String simple = myClass.getSimpleName();
        ImmutableMap standardWriteMappings = ImmutableMap.builder().put((Object)"BooleanType", (Object)WriteMapping.booleanMapping((String)"boolean", (BooleanWriteFunction)StandardColumnMappings.booleanWriteFunction())).put((Object)"BigintType", (Object)WriteMapping.longMapping((String)"number(19)", (LongWriteFunction)StandardColumnMappings.bigintWriteFunction())).put((Object)"IntegerType", (Object)WriteMapping.longMapping((String)"number(10)", (LongWriteFunction)StandardColumnMappings.integerWriteFunction())).put((Object)"SmallintType", (Object)WriteMapping.longMapping((String)"number(5)", (LongWriteFunction)StandardColumnMappings.smallintWriteFunction())).put((Object)"TinyintType", (Object)WriteMapping.longMapping((String)"number(3)", (LongWriteFunction)StandardColumnMappings.tinyintWriteFunction())).put((Object)"DoubleType", (Object)WriteMapping.doubleMapping((String)"double precision", (DoubleWriteFunction)StandardColumnMappings.doubleWriteFunction())).put((Object)"RealType", (Object)WriteMapping.longMapping((String)"real", (LongWriteFunction)StandardColumnMappings.realWriteFunction())).put((Object)"VarbinaryType", (Object)WriteMapping.sliceMapping((String)"varbinary", (SliceWriteFunction)StandardColumnMappings.varbinaryWriteFunction())).put((Object)"DateType", (Object)WriteMapping.longMapping((String)"date", (LongWriteFunction)SnowflakeClient.snowFlakeDateWriter())).buildOrThrow();
        WriteMapping writeMapping = (WriteMapping)standardWriteMappings.get(simple);
        if (writeMapping != null) {
            return writeMapping;
        }
        ImmutableMap snowflakeWriteMappings = ImmutableMap.builder().put((Object)"TimeType", writeType -> WriteMapping.longMapping((String)"time", (LongWriteFunction)SnowflakeClient.timeWriteFunction(((TimeType)writeType).getPrecision()))).put((Object)"ShortTimestampType", writeType -> SnowflakeClient.snowFlakeTimestampWriter(writeType)).put((Object)"ShortTimestampWithTimeZoneType", writeType -> SnowflakeClient.snowFlakeTimestampWithTZWriter(writeType)).put((Object)"LongTimestampType", writeType -> SnowflakeClient.snowFlakeTimestampWithTZWriter(writeType)).put((Object)"LongTimestampWithTimeZoneType", writeType -> SnowflakeClient.snowFlakeTimestampWithTZWriter(writeType)).put((Object)"VarcharType", writeType -> SnowflakeClient.snowFlakeVarCharWriter(writeType)).put((Object)"CharType", writeType -> SnowflakeClient.snowFlakeCharWriter(writeType)).put((Object)"LongDecimalType", writeType -> SnowflakeClient.snowFlakeDecimalWriter(writeType)).put((Object)"ShortDecimalType", writeType -> SnowflakeClient.snowFlakeDecimalWriter(writeType)).buildOrThrow();
        WriteMappingFunction writeMappingFunction = (WriteMappingFunction)snowflakeWriteMappings.get(simple);
        if (writeMappingFunction != null) {
            return writeMappingFunction.convert(type);
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported column type: " + type.getDisplayName() + ", simple:" + simple);
    }

    public Optional<JdbcExpression> implementAggregation(ConnectorSession session, AggregateFunction aggregate, Map<String, ColumnHandle> assignments) {
        return this.aggregateFunctionRewriter.rewrite(session, aggregate, assignments);
    }

    private static Optional<JdbcTypeHandle> toTypeHandle(DecimalType decimalType) {
        return Optional.of(new JdbcTypeHandle(2, Optional.of("decimal"), Optional.of(decimalType.getPrecision()), Optional.of(decimalType.getScale()), Optional.empty(), Optional.empty()));
    }

    protected Optional<BiFunction<String, Long, String>> limitFunction() {
        return Optional.of((sql, limit) -> sql + " LIMIT " + limit);
    }

    public boolean isLimitGuaranteed(ConnectorSession session) {
        return true;
    }

    public Optional<String> getTableComment(ResultSet resultSet) {
        return Optional.empty();
    }

    public void setColumnType(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle column, Type type) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support setting column types");
    }

    private static ColumnMapping columnMappingPushdown(ColumnMapping mapping) {
        if (mapping.getPredicatePushdownController() == PredicatePushdownController.DISABLE_PUSHDOWN) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "mapping.getPredicatePushdownController() is DISABLE_PUSHDOWN. Type was " + String.valueOf(mapping.getType()));
        }
        return new ColumnMapping(mapping.getType(), mapping.getReadFunction(), mapping.getWriteFunction(), PredicatePushdownController.FULL_PUSHDOWN);
    }

    private static ColumnMapping timeColumnMapping(int precision) {
        Preconditions.checkArgument((precision <= 9 ? 1 : 0) != 0, (Object)"The max timestamp precision in Snowflake is 9");
        return ColumnMapping.longMapping((Type)TimeType.createTimeType((int)precision), (resultSet, columnIndex) -> {
            LocalTime time = SNOWFLAKE_TIME_FORMATTER.parse((CharSequence)resultSet.getString(columnIndex), LocalTime::from);
            return Timestamps.round((long)(time.toNanoOfDay() * 1000L), (int)(12 - precision));
        }, (LongWriteFunction)SnowflakeClient.timeWriteFunction(precision), (PredicatePushdownController)PredicatePushdownController.FULL_PUSHDOWN);
    }

    private static ColumnMapping timestampTZColumnMapping(int precision) {
        if (precision <= 3) {
            return ColumnMapping.longMapping((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)precision), (resultSet, columnIndex) -> {
                ZonedDateTime timestamp = SNOWFLAKE_DATETIME_FORMATTER.parse((CharSequence)resultSet.getString(columnIndex), ZonedDateTime::from);
                return DateTimeEncoding.packDateTimeWithZone((long)timestamp.toInstant().toEpochMilli(), (String)timestamp.getZone().getId());
            }, (LongWriteFunction)SnowflakeClient.timestampWithTZWriter(), (PredicatePushdownController)PredicatePushdownController.FULL_PUSHDOWN);
        }
        return ColumnMapping.objectMapping((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)precision), (ObjectReadFunction)SnowflakeClient.longTimestampWithTimezoneReadFunction(), (ObjectWriteFunction)SnowflakeClient.longTimestampWithTZWriteFunction());
    }

    private static LongWriteFunction timestampWithTZWriter() {
        return (statement, index, encodedTimeWithZone) -> {
            Instant timeI = Instant.ofEpochMilli(DateTimeEncoding.unpackMillisUtc((long)encodedTimeWithZone));
            ZoneId zone = ZoneId.of(DateTimeEncoding.unpackZoneKey((long)encodedTimeWithZone).getId());
            statement.setString(index, SNOWFLAKE_DATETIME_FORMATTER.format(timeI.atZone(zone)));
        };
    }

    private static ObjectReadFunction longTimestampWithTimezoneReadFunction() {
        return ObjectReadFunction.of(LongTimestampWithTimeZone.class, (resultSet, columnIndex) -> {
            ZonedDateTime timestamp = SNOWFLAKE_DATETIME_FORMATTER.parse((CharSequence)resultSet.getString(columnIndex), ZonedDateTime::from);
            return LongTimestampWithTimeZone.fromEpochSecondsAndFraction((long)timestamp.toEpochSecond(), (long)((long)timestamp.getNano() * 1000L), (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)timestamp.getZone().getId()));
        });
    }

    private static ObjectWriteFunction longTimestampWithTZWriteFunction() {
        return ObjectWriteFunction.of(LongTimestampWithTimeZone.class, (statement, index, value) -> {
            long epoMilli = value.getEpochMillis();
            long epoSeconds = Math.floorDiv(epoMilli, 1000);
            long adjNano = (long)Math.floorMod(epoMilli, 1000) * 1000000L + (long)(value.getPicosOfMilli() / 1000);
            ZoneId zone = TimeZoneKey.getTimeZoneKey((short)value.getTimeZoneKey()).getZoneId();
            Instant timeI = Instant.ofEpochSecond(epoSeconds, adjNano);
            statement.setString(index, SNOWFLAKE_DATETIME_FORMATTER.format(ZonedDateTime.ofInstant(timeI, zone)));
        });
    }

    private static ColumnMapping timestampColumnMapping(int precision) {
        if (precision <= 6) {
            return ColumnMapping.longMapping((Type)TimestampType.createTimestampType((int)precision), (resultSet, columnIndex) -> StandardColumnMappings.toTrinoTimestamp((TimestampType)TimestampType.createTimestampType((int)precision), (LocalDateTime)SnowflakeClient.toLocalDateTime(resultSet, columnIndex)), (LongWriteFunction)SnowflakeClient.timestampWriteFunction());
        }
        return ColumnMapping.objectMapping((Type)TimestampType.createTimestampType((int)precision), (ObjectReadFunction)SnowflakeClient.longTimestampReader(), (ObjectWriteFunction)SnowflakeClient.longTimestampWriter(precision));
    }

    private static LocalDateTime toLocalDateTime(ResultSet resultSet, int columnIndex) throws SQLException {
        GregorianCalendar calendar = new GregorianCalendar(UTC_TZ, Locale.ENGLISH);
        calendar.setTime(new Date(0L));
        Timestamp ts = resultSet.getTimestamp(columnIndex, (Calendar)calendar);
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(ts.getTime()), ZoneOffset.UTC);
    }

    private static ObjectReadFunction longTimestampReader() {
        return ObjectReadFunction.of(LongTimestamp.class, (resultSet, columnIndex) -> {
            GregorianCalendar calendar = new GregorianCalendar(UTC_TZ, Locale.ENGLISH);
            calendar.setTime(new Date(0L));
            Timestamp ts = resultSet.getTimestamp(columnIndex, (Calendar)calendar);
            long epochMillis = ts.getTime();
            int nanosInTheSecond = ts.getNanos();
            int nanosInTheMilli = nanosInTheSecond % 1000000;
            long micro = epochMillis * 1000L + (long)(nanosInTheMilli / 1000);
            int picosOfMicro = nanosInTheMilli % 1000 * 1000;
            return new LongTimestamp(micro, picosOfMicro);
        });
    }

    private static LongWriteFunction timeWriteFunction(final int precision) {
        Preconditions.checkArgument((precision <= 9 ? 1 : 0) != 0, (String)"Unsupported precision: %s", (int)precision);
        return new LongWriteFunction(){

            public String getBindExpression() {
                return String.format("CAST(? AS time(%s))", precision);
            }

            public void set(PreparedStatement statement, int index, long picosOfDay) throws SQLException {
                if ((picosOfDay = Timestamps.round((long)picosOfDay, (int)(12 - precision))) == 86400000000000000L) {
                    picosOfDay = 0L;
                }
                LocalTime localTime = LocalTime.ofNanoOfDay(picosOfDay / 1000L);
                statement.setString(index, SNOWFLAKE_TIME_FORMATTER.format(localTime));
            }
        };
    }

    private static ColumnMapping varcharColumnMapping(int varcharLength) {
        VarcharType varcharType = varcharLength <= 0x7FFFFFFE ? VarcharType.createVarcharType((int)varcharLength) : VarcharType.createUnboundedVarcharType();
        return ColumnMapping.sliceMapping((Type)varcharType, (SliceReadFunction)StandardColumnMappings.varcharReadFunction((VarcharType)varcharType), (SliceWriteFunction)StandardColumnMappings.varcharWriteFunction());
    }

    private static ObjectWriteFunction longTimestampWithTzWriteFunction() {
        return ObjectWriteFunction.of(LongTimestampWithTimeZone.class, (statement, index, value) -> {
            long epochMilli = value.getEpochMillis();
            long epochSecond = Math.floorDiv(epochMilli, 1000);
            int nanosOfSecond = Math.floorMod(epochMilli, 1000) * 1000000 + value.getPicosOfMilli() / 1000;
            ZoneId zone = TimeZoneKey.getTimeZoneKey((short)value.getTimeZoneKey()).getZoneId();
            Instant instant = Instant.ofEpochSecond(epochSecond, nanosOfSecond);
            statement.setString(index, SNOWFLAKE_DATETIME_FORMATTER.format(ZonedDateTime.ofInstant(instant, zone)));
        });
    }

    private static WriteMapping snowFlakeDecimalWriter(Type type) {
        DecimalType decimalType = (DecimalType)type;
        String dataType = String.format("decimal(%s, %s)", decimalType.getPrecision(), decimalType.getScale());
        if (decimalType.isShort()) {
            return WriteMapping.longMapping((String)dataType, (LongWriteFunction)StandardColumnMappings.shortDecimalWriteFunction((DecimalType)decimalType));
        }
        return WriteMapping.objectMapping((String)dataType, (ObjectWriteFunction)StandardColumnMappings.longDecimalWriteFunction((DecimalType)decimalType));
    }

    private static LongWriteFunction snowFlakeDateWriter() {
        return (statement, index, day) -> statement.setString(index, SNOWFLAKE_DATE_FORMATTER.format(LocalDate.ofEpochDay(day)));
    }

    private static WriteMapping snowFlakeCharWriter(Type type) {
        CharType charType = (CharType)type;
        return WriteMapping.sliceMapping((String)("char(" + charType.getLength() + ")"), (SliceWriteFunction)SnowflakeClient.charWriteFunction(charType));
    }

    private static WriteMapping snowFlakeVarCharWriter(Type type) {
        VarcharType varcharType = (VarcharType)type;
        Object dataType = varcharType.isUnbounded() ? "varchar" : "varchar(" + varcharType.getBoundedLength() + ")";
        return WriteMapping.sliceMapping((String)dataType, (SliceWriteFunction)StandardColumnMappings.varcharWriteFunction());
    }

    private static SliceWriteFunction charWriteFunction(CharType charType) {
        return (statement, index, value) -> statement.setString(index, Chars.padSpaces((Slice)value, (CharType)charType).toStringUtf8());
    }

    private static WriteMapping snowFlakeTimestampWriter(Type type) {
        TimestampType timestampType = (TimestampType)type;
        Preconditions.checkArgument((timestampType.getPrecision() <= 9 ? 1 : 0) != 0, (Object)"The max timestamp precision in Snowflake is 9");
        if (timestampType.isShort()) {
            return WriteMapping.longMapping((String)String.format("timestamp_ntz(%d)", timestampType.getPrecision()), (LongWriteFunction)SnowflakeClient.timestampWriteFunction());
        }
        return WriteMapping.objectMapping((String)String.format("timestamp_ntz(%d)", timestampType.getPrecision()), (ObjectWriteFunction)SnowflakeClient.longTimestampWriter(timestampType.getPrecision()));
    }

    private static LongWriteFunction timestampWriteFunction() {
        return (statement, index, value) -> statement.setString(index, StandardColumnMappings.fromTrinoTimestamp((long)value).toString());
    }

    private static ObjectWriteFunction longTimestampWriter(int precision) {
        return ObjectWriteFunction.of(LongTimestamp.class, (statement, index, value) -> statement.setString(index, SNOWFLAKE_TIMESTAMP_FORMATTER.format(StandardColumnMappings.fromLongTrinoTimestamp((LongTimestamp)value, (int)precision))));
    }

    private static WriteMapping snowFlakeTimestampWithTZWriter(Type type) {
        TimestampWithTimeZoneType timeTZType = (TimestampWithTimeZoneType)type;
        Preconditions.checkArgument((timeTZType.getPrecision() <= 9 ? 1 : 0) != 0, (Object)"Max Snowflake precision is is 9");
        if (timeTZType.isShort()) {
            return WriteMapping.longMapping((String)String.format("timestamp_tz(%d)", timeTZType.getPrecision()), (LongWriteFunction)SnowflakeClient.timestampWithTimezoneWriteFunction());
        }
        return WriteMapping.objectMapping((String)String.format("timestamp_tz(%d)", timeTZType.getPrecision()), (ObjectWriteFunction)SnowflakeClient.longTimestampWithTzWriteFunction());
    }

    private static LongWriteFunction timestampWithTimezoneWriteFunction() {
        return (statement, index, encodedTimeWithZone) -> {
            Instant instant = Instant.ofEpochMilli(DateTimeEncoding.unpackMillisUtc((long)encodedTimeWithZone));
            ZoneId zone = ZoneId.of(DateTimeEncoding.unpackZoneKey((long)encodedTimeWithZone).getId());
            statement.setString(index, SNOWFLAKE_DATETIME_FORMATTER.format(instant.atZone(zone)));
        };
    }

    private static interface ColumnMappingFunction {
        public Optional<ColumnMapping> convert(JdbcTypeHandle var1);
    }

    private static interface WriteMappingFunction {
        public WriteMapping convert(Type var1);
    }
}

