/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;

public class DictionaryId {
    private static final UUID nodeId = UUID.randomUUID();
    private static final AtomicLong sequenceGenerator = new AtomicLong();
    private final long mostSignificantBits;
    private final long leastSignificantBits;
    private final long sequenceId;

    public static DictionaryId randomDictionaryId() {
        return new DictionaryId(nodeId.getMostSignificantBits(), nodeId.getLeastSignificantBits(), sequenceGenerator.getAndIncrement());
    }

    public DictionaryId(long mostSignificantBits, long leastSignificantBits, long sequenceId) {
        this.mostSignificantBits = mostSignificantBits;
        this.leastSignificantBits = leastSignificantBits;
        this.sequenceId = sequenceId;
    }

    public long getMostSignificantBits() {
        return this.mostSignificantBits;
    }

    public long getLeastSignificantBits() {
        return this.leastSignificantBits;
    }

    public long getSequenceId() {
        return this.sequenceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DictionaryId that = (DictionaryId)o;
        return this.mostSignificantBits == that.mostSignificantBits && this.leastSignificantBits == that.leastSignificantBits && this.sequenceId == that.sequenceId;
    }

    public int hashCode() {
        return Objects.hash(this.mostSignificantBits, this.leastSignificantBits, this.sequenceId);
    }
}

