/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.connector;

import io.trino.spi.connector.SortItem;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;

public class AggregateFunction {
    private final String functionName;
    private final Type outputType;
    private final List<ConnectorExpression> inputs;
    private final List<SortItem> sortItems;
    private final boolean isDistinct;
    private final Optional<ConnectorExpression> filter;

    public AggregateFunction(String aggregateFunctionName, Type outputType, List<ConnectorExpression> inputs, List<SortItem> sortItems, boolean isDistinct, Optional<ConnectorExpression> filter) {
        if (isDistinct && inputs.isEmpty()) {
            throw new IllegalArgumentException("DISTINCT requires inputs");
        }
        this.functionName = Objects.requireNonNull(aggregateFunctionName, "name is null");
        this.outputType = Objects.requireNonNull(outputType, "outputType is null");
        Objects.requireNonNull(inputs, "inputs is null");
        Objects.requireNonNull(sortItems, "sortOrder is null");
        this.inputs = List.copyOf(inputs);
        this.sortItems = List.copyOf(sortItems);
        this.isDistinct = isDistinct;
        this.filter = Objects.requireNonNull(filter, "filter is null");
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public List<ConnectorExpression> getInputs() {
        return this.inputs;
    }

    public Type getOutputType() {
        return this.outputType;
    }

    public List<SortItem> getSortItems() {
        return this.sortItems;
    }

    public boolean isDistinct() {
        return this.isDistinct;
    }

    public Optional<ConnectorExpression> getFilter() {
        return this.filter;
    }

    public String toString() {
        return new StringJoiner(", ", AggregateFunction.class.getSimpleName() + "[", "]").add("aggregationName='" + this.functionName + "'").add("inputs=" + this.inputs).add("outputType=" + this.outputType).add("sortOrder=" + this.sortItems).add("isDistinct=" + this.isDistinct).add("filter=" + this.filter).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregateFunction that = (AggregateFunction)o;
        return this.isDistinct == that.isDistinct && Objects.equals(this.functionName, that.functionName) && Objects.equals(this.inputs, that.inputs) && Objects.equals(this.outputType, that.outputType) && Objects.equals(this.sortItems, that.sortItems) && Objects.equals(this.filter, that.filter);
    }

    public int hashCode() {
        return Objects.hash(this.functionName, this.inputs, this.outputType, this.sortItems, this.isDistinct, this.filter);
    }
}

