/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.connector;

import io.trino.spi.connector.Assignment;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.expression.ConnectorExpression;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AggregationApplicationResult<T> {
    private final T handle;
    private final List<ConnectorExpression> projections;
    private final List<Assignment> assignments;
    private final Map<ColumnHandle, ColumnHandle> groupingColumnMapping;

    public AggregationApplicationResult(T handle, List<ConnectorExpression> projections, List<Assignment> assignments, Map<ColumnHandle, ColumnHandle> groupingColumnMapping) {
        this.handle = Objects.requireNonNull(handle, "handle is null");
        Objects.requireNonNull(groupingColumnMapping, "goupingSetMapping is null");
        Objects.requireNonNull(projections, "projections is null");
        Objects.requireNonNull(assignments, "assignment is null");
        this.groupingColumnMapping = Map.copyOf(groupingColumnMapping);
        this.projections = List.copyOf(projections);
        this.assignments = List.copyOf(assignments);
    }

    public T getHandle() {
        return this.handle;
    }

    public List<ConnectorExpression> getProjections() {
        return this.projections;
    }

    public List<Assignment> getAssignments() {
        return this.assignments;
    }

    public Map<ColumnHandle, ColumnHandle> getGroupingColumnMapping() {
        return this.groupingColumnMapping;
    }
}

