/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.connector;

import io.trino.spi.connector.ConnectorPartitionHandle;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.NotPartitionedPartitionHandle;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class FixedSplitSource
implements ConnectorSplitSource {
    private final List<ConnectorSplit> splits;
    private int offset;

    public FixedSplitSource(Iterable<? extends ConnectorSplit> splits) {
        Objects.requireNonNull(splits, "splits is null");
        this.splits = StreamSupport.stream(splits.spliterator(), false).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public CompletableFuture<ConnectorSplitSource.ConnectorSplitBatch> getNextBatch(ConnectorPartitionHandle partitionHandle, int maxSize) {
        if (!partitionHandle.equals(NotPartitionedPartitionHandle.NOT_PARTITIONED)) {
            throw new IllegalArgumentException("partitionHandle must be NOT_PARTITIONED");
        }
        int remainingSplits = this.splits.size() - this.offset;
        int size = Math.min(remainingSplits, maxSize);
        List<ConnectorSplit> results = this.splits.subList(this.offset, this.offset + size);
        this.offset += size;
        return CompletableFuture.completedFuture(new ConnectorSplitSource.ConnectorSplitBatch(results, this.isFinished()));
    }

    @Override
    public boolean isFinished() {
        return this.offset >= this.splits.size();
    }

    @Override
    public void close() {
    }
}

