/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.eventlistener;

import io.trino.spi.TrinoWarning;
import io.trino.spi.eventlistener.QueryContext;
import io.trino.spi.eventlistener.QueryFailureInfo;
import io.trino.spi.eventlistener.QueryIOMetadata;
import io.trino.spi.eventlistener.QueryMetadata;
import io.trino.spi.eventlistener.QueryStatistics;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;

public class QueryCompletedEvent {
    private final QueryMetadata metadata;
    private final QueryStatistics statistics;
    private final QueryContext context;
    private final QueryIOMetadata ioMetadata;
    private final Optional<QueryFailureInfo> failureInfo;
    private final List<TrinoWarning> warnings;
    private final Instant createTime;
    private final Instant executionStartTime;
    private final Instant endTime;

    public QueryCompletedEvent(QueryMetadata metadata, QueryStatistics statistics, QueryContext context, QueryIOMetadata ioMetadata, Optional<QueryFailureInfo> failureInfo, List<TrinoWarning> warnings, Instant createTime, Instant executionStartTime, Instant endTime) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.statistics = Objects.requireNonNull(statistics, "statistics is null");
        this.context = Objects.requireNonNull(context, "context is null");
        this.ioMetadata = Objects.requireNonNull(ioMetadata, "ioMetadata is null");
        this.failureInfo = Objects.requireNonNull(failureInfo, "failureInfo is null");
        this.warnings = Objects.requireNonNull(warnings, "queryWarnings is null");
        this.createTime = Objects.requireNonNull(createTime, "createTime is null");
        this.executionStartTime = Objects.requireNonNull(executionStartTime, "executionStartTime is null");
        this.endTime = Objects.requireNonNull(endTime, "endTime is null");
    }

    public QueryMetadata getMetadata() {
        return this.metadata;
    }

    public QueryStatistics getStatistics() {
        return this.statistics;
    }

    public QueryContext getContext() {
        return this.context;
    }

    public QueryIOMetadata getIoMetadata() {
        return this.ioMetadata;
    }

    public Optional<QueryFailureInfo> getFailureInfo() {
        return this.failureInfo;
    }

    public List<TrinoWarning> getWarnings() {
        return this.warnings;
    }

    public Instant getCreateTime() {
        return this.createTime;
    }

    public Instant getExecutionStartTime() {
        return this.executionStartTime;
    }

    public Instant getEndTime() {
        return this.endTime;
    }

    public String toString() {
        return new StringJoiner(", ", QueryCompletedEvent.class.getSimpleName() + "[", "]").add("queryId='" + this.getMetadata().getQueryId() + "'").add("queryState='" + this.getMetadata().getQueryState() + "'").toString();
    }
}

