/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.eventlistener;

import io.trino.spi.eventlistener.QueryContext;
import io.trino.spi.eventlistener.QueryMetadata;
import java.time.Instant;
import java.util.Objects;
import java.util.StringJoiner;

public class QueryCreatedEvent {
    private final Instant createTime;
    private final QueryContext context;
    private final QueryMetadata metadata;

    public QueryCreatedEvent(Instant createTime, QueryContext context, QueryMetadata metadata) {
        this.createTime = Objects.requireNonNull(createTime, "createTime is null");
        this.context = Objects.requireNonNull(context, "context is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    public Instant getCreateTime() {
        return this.createTime;
    }

    public QueryContext getContext() {
        return this.context;
    }

    public QueryMetadata getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return new StringJoiner(", ", QueryCreatedEvent.class.getSimpleName() + "[", "]").add("queryId='" + this.getMetadata().getQueryId() + "'").toString();
    }
}

