/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.predicate;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeUtils;
import java.lang.invoke.MethodHandle;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;

public final class Marker
implements Comparable<Marker> {
    private final Type type;
    private final MethodHandle comparisonOperator;
    private final Optional<Block> valueBlock;
    private final Bound bound;
    private final MethodHandle equalOperator;
    private final MethodHandle hashCodeOperator;

    @JsonCreator
    public Marker(@JsonProperty(value="type") Type type, @JsonProperty(value="valueBlock") Optional<Block> valueBlock, @JsonProperty(value="bound") Bound bound) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(valueBlock, "valueBlock is null");
        Objects.requireNonNull(bound, "bound is null");
        if (!type.isOrderable()) {
            throw new IllegalArgumentException("type must be orderable");
        }
        if (valueBlock.isEmpty() && bound == Bound.EXACTLY) {
            throw new IllegalArgumentException("Cannot be equal to unbounded");
        }
        if (valueBlock.isPresent() && valueBlock.get().getPositionCount() != 1) {
            throw new IllegalArgumentException("value block should only have one position");
        }
        if (valueBlock.isPresent() && TypeUtils.isFloatingPointNaN(type, Utils.blockToNativeValue(type, valueBlock.get()))) {
            throw new IllegalArgumentException("cannot use NaN as range bound");
        }
        this.type = type;
        this.comparisonOperator = Utils.TUPLE_DOMAIN_TYPE_OPERATORS.getComparisonOperator(type, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION));
        this.valueBlock = valueBlock;
        this.bound = bound;
        this.equalOperator = Utils.TUPLE_DOMAIN_TYPE_OPERATORS.getEqualOperator(type, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION));
        this.hashCodeOperator = Utils.TUPLE_DOMAIN_TYPE_OPERATORS.getHashCodeOperator(type, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION));
    }

    private static Marker create(Type type, Optional<Object> value, Bound bound) {
        return new Marker(type, value.map(object -> Utils.nativeValueToBlock(type, object)), bound);
    }

    public static Marker upperUnbounded(Type type) {
        Objects.requireNonNull(type, "type is null");
        return Marker.create(type, Optional.empty(), Bound.BELOW);
    }

    public static Marker lowerUnbounded(Type type) {
        Objects.requireNonNull(type, "type is null");
        return Marker.create(type, Optional.empty(), Bound.ABOVE);
    }

    public static Marker above(Type type, Object value) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(value, "value is null");
        return Marker.create(type, Optional.of(value), Bound.ABOVE);
    }

    public static Marker exactly(Type type, Object value) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(value, "value is null");
        return Marker.create(type, Optional.of(value), Bound.EXACTLY);
    }

    public static Marker below(Type type, Object value) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(value, "value is null");
        return Marker.create(type, Optional.of(value), Bound.BELOW);
    }

    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @JsonProperty
    public Optional<Block> getValueBlock() {
        return this.valueBlock;
    }

    public Object getValue() {
        if (this.valueBlock.isEmpty()) {
            throw new IllegalStateException("No value to get");
        }
        return Utils.blockToNativeValue(this.type, this.valueBlock.get());
    }

    public Object getPrintableValue(ConnectorSession session) {
        if (this.valueBlock.isEmpty()) {
            throw new IllegalStateException("No value to get");
        }
        return this.type.getObjectValue(session, this.valueBlock.get(), 0);
    }

    @JsonProperty
    public Bound getBound() {
        return this.bound;
    }

    public boolean isUpperUnbounded() {
        return this.valueBlock.isEmpty() && this.bound == Bound.BELOW;
    }

    public boolean isLowerUnbounded() {
        return this.valueBlock.isEmpty() && this.bound == Bound.ABOVE;
    }

    private void checkTypeCompatibility(Marker marker) {
        if (!this.type.equals(marker.getType())) {
            throw new IllegalArgumentException(String.format("Mismatched Marker types: %s vs %s", this.type, marker.getType()));
        }
    }

    public boolean isAdjacent(Marker other) {
        this.checkTypeCompatibility(other);
        if (this.isUpperUnbounded() || this.isLowerUnbounded() || other.isUpperUnbounded() || other.isLowerUnbounded()) {
            return false;
        }
        if (this.compare(this.valueBlock.get(), other.valueBlock.get()) != 0) {
            return false;
        }
        return this.bound == Bound.EXACTLY && other.bound != Bound.EXACTLY || this.bound != Bound.EXACTLY && other.bound == Bound.EXACTLY;
    }

    public Marker greaterAdjacent() {
        if (this.valueBlock.isEmpty()) {
            throw new IllegalStateException("No marker adjacent to unbounded");
        }
        switch (this.bound) {
            case BELOW: {
                return new Marker(this.type, this.valueBlock, Bound.EXACTLY);
            }
            case EXACTLY: {
                return new Marker(this.type, this.valueBlock, Bound.ABOVE);
            }
            case ABOVE: {
                throw new IllegalStateException("No greater marker adjacent to an ABOVE bound");
            }
        }
        throw new AssertionError((Object)("Unsupported type: " + this.bound));
    }

    public Marker lesserAdjacent() {
        if (this.valueBlock.isEmpty()) {
            throw new IllegalStateException("No marker adjacent to unbounded");
        }
        switch (this.bound) {
            case BELOW: {
                throw new IllegalStateException("No lesser marker adjacent to a BELOW bound");
            }
            case EXACTLY: {
                return new Marker(this.type, this.valueBlock, Bound.BELOW);
            }
            case ABOVE: {
                return new Marker(this.type, this.valueBlock, Bound.EXACTLY);
            }
        }
        throw new AssertionError((Object)("Unsupported type: " + this.bound));
    }

    @Override
    public int compareTo(Marker o) {
        this.checkTypeCompatibility(o);
        if (this.isUpperUnbounded()) {
            return o.isUpperUnbounded() ? 0 : 1;
        }
        if (this.isLowerUnbounded()) {
            return o.isLowerUnbounded() ? 0 : -1;
        }
        if (o.isUpperUnbounded()) {
            return -1;
        }
        if (o.isLowerUnbounded()) {
            return 1;
        }
        int compare = this.compare(this.valueBlock.get(), o.valueBlock.get());
        if (compare == 0) {
            if (this.bound == o.bound) {
                return 0;
            }
            if (this.bound == Bound.BELOW) {
                return -1;
            }
            if (this.bound == Bound.ABOVE) {
                return 1;
            }
            return o.bound == Bound.BELOW ? 1 : -1;
        }
        return compare;
    }

    public int compare(Block left, Block right) {
        try {
            return (int)this.comparisonOperator.invokeExact(left, 0, right, 0);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable throwable) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, throwable);
        }
    }

    public static Marker min(Marker marker1, Marker marker2) {
        return marker1.compareTo(marker2) <= 0 ? marker1 : marker2;
    }

    public static Marker max(Marker marker1, Marker marker2) {
        return marker1.compareTo(marker2) >= 0 ? marker1 : marker2;
    }

    public int hashCode() {
        long hash = Objects.hash(new Object[]{this.type, this.bound});
        if (this.valueBlock.isPresent()) {
            hash = hash * 31L + this.valueHash();
        }
        return (int)hash;
    }

    private long valueHash() {
        try {
            return this.hashCodeOperator.invokeExact(this.valueBlock.get(), 0);
        }
        catch (Throwable throwable) {
            throw Utils.handleThrowable(throwable);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Marker other = (Marker)obj;
        return Objects.equals(this.type, other.type) && this.bound == other.bound && this.valueBlock.isPresent() == other.valueBlock.isPresent() && (this.valueBlock.isEmpty() || this.valueEqual(this.valueBlock.get(), other.valueBlock.get()));
    }

    private boolean valueEqual(Block leftBlock, Block rightBlock) {
        try {
            return Boolean.TRUE.equals(this.equalOperator.invokeExact(leftBlock, 0, rightBlock, 0));
        }
        catch (Throwable throwable) {
            throw Utils.handleThrowable(throwable);
        }
    }

    public String toString() {
        StringJoiner stringJoiner = new StringJoiner(", ", Marker.class.getSimpleName() + "[", "]");
        if (this.isLowerUnbounded()) {
            stringJoiner.add("lower unbounded");
        } else if (this.isUpperUnbounded()) {
            stringJoiner.add("upper unbounded");
        }
        stringJoiner.add("bound=" + this.bound);
        this.valueBlock.ifPresent(valueBlock -> stringJoiner.add("valueBlock=..."));
        return stringJoiner.toString();
    }

    public String toString(ConnectorSession session) {
        StringBuilder buffer = new StringBuilder("{");
        buffer.append("type=").append(this.type);
        buffer.append(", value=");
        if (this.isLowerUnbounded()) {
            buffer.append("<min>");
        } else if (this.isUpperUnbounded()) {
            buffer.append("<max>");
        } else {
            buffer.append(this.getPrintableValue(session));
        }
        buffer.append(", bound=").append((Object)this.bound);
        buffer.append("}");
        return buffer.toString();
    }

    public static enum Bound {
        BELOW,
        EXACTLY,
        ABOVE;

    }
}

