/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.block.RowBlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorMethodHandle;
import io.trino.spi.type.AbstractType;
import io.trino.spi.type.NamedTypeSignature;
import io.trino.spi.type.RowFieldName;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperatorDeclaration;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class RowType
extends AbstractType {
    private static final InvocationConvention EQUAL_CONVENTION = InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL);
    private static final InvocationConvention HASH_CODE_CONVENTION = InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL);
    private static final InvocationConvention DISTINCT_FROM_CONVENTION = InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE, InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE);
    private static final InvocationConvention INDETERMINATE_CONVENTION = InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE);
    private static final InvocationConvention COMPARISON_CONVENTION = InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL);
    private static final MethodHandle EQUAL;
    private static final MethodHandle CHAIN_EQUAL;
    private static final MethodHandle HASH_CODE;
    private static final MethodHandle CHAIN_HASH_CODE;
    private static final MethodHandle DISTINCT_FROM;
    private static final MethodHandle CHAIN_DISTINCT_FROM_START;
    private static final MethodHandle CHAIN_DISTINCT_FROM;
    private static final MethodHandle INDETERMINATE;
    private static final MethodHandle CHAIN_INDETERMINATE;
    private static final MethodHandle COMPARISON;
    private static final MethodHandle CHAIN_COMPARISON;
    private static final int MEGAMORPHIC_FIELD_COUNT = 64;
    private volatile TypeOperatorDeclaration typeOperatorDeclaration;
    private final List<Field> fields;
    private final List<Type> fieldTypes;
    private final boolean comparable;
    private final boolean orderable;

    private RowType(TypeSignature typeSignature, List<Field> fields) {
        super(typeSignature, Block.class);
        this.fields = fields;
        this.fieldTypes = fields.stream().map(Field::getType).collect(Collectors.toList());
        this.comparable = fields.stream().allMatch(field -> field.getType().isComparable());
        this.orderable = fields.stream().allMatch(field -> field.getType().isOrderable());
    }

    public static RowType from(List<Field> fields) {
        return new RowType(RowType.makeSignature(fields), fields);
    }

    public static RowType anonymous(List<Type> types) {
        List<Field> fields = types.stream().map(type -> new Field(Optional.empty(), (Type)type)).collect(Collectors.toList());
        return new RowType(RowType.makeSignature(fields), fields);
    }

    public static RowType rowType(Field ... field) {
        return RowType.from(Arrays.asList(field));
    }

    public static RowType anonymousRow(Type ... types) {
        return RowType.anonymous(Arrays.asList(types));
    }

    public static RowType createWithTypeSignature(TypeSignature typeSignature, List<Field> fields) {
        return new RowType(typeSignature, fields);
    }

    public static Field field(String name, Type type) {
        return new Field(Optional.of(name), type);
    }

    public static Field field(Type type) {
        return new Field(Optional.empty(), type);
    }

    private static TypeSignature makeSignature(List<Field> fields) {
        int size = fields.size();
        if (size == 0) {
            throw new IllegalArgumentException("Row type must have at least 1 field");
        }
        List<TypeSignatureParameter> parameters = fields.stream().map(field -> new NamedTypeSignature(field.getName().map(RowFieldName::new), field.getType().getTypeSignature())).map(TypeSignatureParameter::namedTypeParameter).collect(Collectors.toList());
        return new TypeSignature("row", parameters);
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        return new RowBlockBuilder(this.getTypeParameters(), blockBuilderStatus, expectedEntries);
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return new RowBlockBuilder(this.getTypeParameters(), blockBuilderStatus, expectedEntries);
    }

    @Override
    public String getDisplayName() {
        StringBuilder result = new StringBuilder();
        result.append("row").append('(');
        for (Field field : this.fields) {
            String typeDisplayName = field.getType().getDisplayName();
            if (field.getName().isPresent()) {
                result.append(field.getName().get()).append(' ').append(typeDisplayName);
            } else {
                result.append(typeDisplayName);
            }
            result.append(", ");
        }
        result.setLength(result.length() - 2);
        result.append(')');
        return result.toString();
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        Block arrayBlock = this.getObject(block, position);
        ArrayList<Object> values = new ArrayList<Object>(arrayBlock.getPositionCount());
        for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
            values.add(this.fields.get(i).getType().getObjectValue(session, arrayBlock, i));
        }
        return Collections.unmodifiableList(values);
    }

    @Override
    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            block.writePositionTo(position, blockBuilder);
        }
    }

    @Override
    public Block getObject(Block block, int position) {
        return block.getObject(position, Block.class);
    }

    @Override
    public void writeObject(BlockBuilder blockBuilder, Object value) {
        blockBuilder.appendStructure((Block)value);
    }

    @Override
    public List<Type> getTypeParameters() {
        return this.fieldTypes;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    @Override
    public boolean isComparable() {
        return this.comparable;
    }

    @Override
    public boolean isOrderable() {
        return this.orderable;
    }

    @Override
    public TypeOperatorDeclaration getTypeOperatorDeclaration(TypeOperators typeOperators) {
        if (this.typeOperatorDeclaration == null) {
            this.generateTypeOperators(typeOperators);
        }
        return this.typeOperatorDeclaration;
    }

    private synchronized void generateTypeOperators(TypeOperators typeOperators) {
        if (this.typeOperatorDeclaration != null) {
            return;
        }
        this.typeOperatorDeclaration = TypeOperatorDeclaration.builder(this.getJavaType()).addEqualOperators(RowType.getEqualOperatorMethodHandles(typeOperators, this.fields)).addHashCodeOperators(RowType.getHashCodeOperatorMethodHandles(typeOperators, this.fields)).addXxHash64Operators(RowType.getXxHash64OperatorMethodHandles(typeOperators, this.fields)).addDistinctFromOperators(RowType.getDistinctFromOperatorInvokers(typeOperators, this.fields)).addIndeterminateOperators(RowType.getIndeterminateOperatorInvokers(typeOperators, this.fields)).addComparisonOperators(RowType.getComparisonOperatorInvokers(typeOperators, this.fields)).build();
    }

    private static List<OperatorMethodHandle> getEqualOperatorMethodHandles(TypeOperators typeOperators, List<Field> fields) {
        boolean comparable = fields.stream().allMatch(field -> field.getType().isComparable());
        if (!comparable) {
            return Collections.emptyList();
        }
        if (fields.size() > 64) {
            List equalOperators = fields.stream().map(field -> typeOperators.getEqualOperator(field.getType(), InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION))).collect(Collectors.toUnmodifiableList());
            return Collections.singletonList(new OperatorMethodHandle(EQUAL_CONVENTION, EQUAL.bindTo(equalOperators)));
        }
        MethodHandle equal = MethodHandles.dropArguments(MethodHandles.constant(Boolean.class, Boolean.TRUE), 0, new Class[]{Block.class, Block.class});
        for (int fieldId = 0; fieldId < fields.size(); ++fieldId) {
            Field field2 = fields.get(fieldId);
            equal = MethodHandles.collectArguments(CHAIN_EQUAL, 0, equal);
            MethodHandle fieldEqualOperator = typeOperators.getEqualOperator(field2.getType(), InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION));
            equal = MethodHandles.insertArguments(equal, 2, fieldId, fieldEqualOperator);
            equal = MethodHandles.permuteArguments(equal, MethodType.methodType(Boolean.class, Block.class, Block.class), 0, 1, 0, 1);
        }
        return Collections.singletonList(new OperatorMethodHandle(EQUAL_CONVENTION, equal));
    }

    private static Boolean megamorphicEqualOperator(List<MethodHandle> equalOperators, Block leftRow, Block rightRow) throws Throwable {
        boolean unknown = false;
        for (int fieldIndex = 0; fieldIndex < equalOperators.size(); ++fieldIndex) {
            if (leftRow.isNull(fieldIndex) || rightRow.isNull(fieldIndex)) {
                unknown = true;
                continue;
            }
            MethodHandle equalOperator = equalOperators.get(fieldIndex);
            Boolean result = equalOperator.invokeExact(leftRow, fieldIndex, rightRow, fieldIndex);
            if (result == null) {
                unknown = true;
                continue;
            }
            if (result.booleanValue()) continue;
            return false;
        }
        if (unknown) {
            return null;
        }
        return true;
    }

    private static Boolean chainEqual(Boolean previousFieldsEqual, int currentFieldIndex, MethodHandle currentFieldEqual, Block rightRow, Block leftRow) throws Throwable {
        if (previousFieldsEqual == Boolean.FALSE) {
            return Boolean.FALSE;
        }
        if (leftRow.isNull(currentFieldIndex) || rightRow.isNull(currentFieldIndex)) {
            return null;
        }
        Boolean result = currentFieldEqual.invokeExact(rightRow, currentFieldIndex, leftRow, currentFieldIndex);
        if (result == Boolean.TRUE) {
            return previousFieldsEqual;
        }
        return result;
    }

    private static List<OperatorMethodHandle> getHashCodeOperatorMethodHandles(TypeOperators typeOperators, List<Field> fields) {
        return RowType.getHashCodeOperatorMethodHandles(fields, (Type type) -> typeOperators.getHashCodeOperator((Type)type, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION)));
    }

    private static List<OperatorMethodHandle> getXxHash64OperatorMethodHandles(TypeOperators typeOperators, List<Field> fields) {
        return RowType.getHashCodeOperatorMethodHandles(fields, (Type type) -> typeOperators.getHashCodeOperator((Type)type, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION)));
    }

    private static List<OperatorMethodHandle> getHashCodeOperatorMethodHandles(List<Field> fields, Function<Type, MethodHandle> getHashOperator) {
        boolean comparable = fields.stream().allMatch(field -> field.getType().isComparable());
        if (!comparable) {
            return Collections.emptyList();
        }
        if (fields.size() > 64) {
            List hashCodeOperators = fields.stream().map(field -> (MethodHandle)getHashOperator.apply(field.getType())).collect(Collectors.toUnmodifiableList());
            return Collections.singletonList(new OperatorMethodHandle(HASH_CODE_CONVENTION, HASH_CODE.bindTo(hashCodeOperators)));
        }
        MethodHandle hashCode = MethodHandles.dropArguments(MethodHandles.constant(Long.TYPE, 1), 0, new Class[]{Block.class});
        for (int fieldId = 0; fieldId < fields.size(); ++fieldId) {
            Field field2 = fields.get(fieldId);
            hashCode = MethodHandles.collectArguments(CHAIN_HASH_CODE, 0, hashCode);
            MethodHandle fieldHashCodeOperator = getHashOperator.apply(field2.getType());
            hashCode = MethodHandles.insertArguments(hashCode, 1, fieldId, fieldHashCodeOperator);
            hashCode = MethodHandles.permuteArguments(hashCode, MethodType.methodType(Long.TYPE, Block.class), 0, 0);
        }
        return Collections.singletonList(new OperatorMethodHandle(HASH_CODE_CONVENTION, hashCode));
    }

    private static long megamorphicHashCodeOperator(List<MethodHandle> hashCodeOperators, Block rowBlock) throws Throwable {
        long result = 1L;
        for (int fieldIndex = 0; fieldIndex < hashCodeOperators.size(); ++fieldIndex) {
            long fieldHashCode = 0L;
            if (!rowBlock.isNull(fieldIndex)) {
                MethodHandle hashCodeOperator = hashCodeOperators.get(fieldIndex);
                fieldHashCode = hashCodeOperator.invokeExact(rowBlock, fieldIndex);
            }
            result = 31L * result + fieldHashCode;
        }
        return result;
    }

    private static long chainHashCode(long previousFieldHashCode, int currentFieldIndex, MethodHandle currentFieldHashCodeOperator, Block row) throws Throwable {
        long fieldHashCode = 0L;
        if (!row.isNull(currentFieldIndex)) {
            fieldHashCode = currentFieldHashCodeOperator.invokeExact(row, currentFieldIndex);
        }
        return 31L * previousFieldHashCode + fieldHashCode;
    }

    private static List<OperatorMethodHandle> getDistinctFromOperatorInvokers(TypeOperators typeOperators, List<Field> fields) {
        boolean comparable = fields.stream().allMatch(field -> field.getType().isComparable());
        if (!comparable) {
            return Collections.emptyList();
        }
        if (fields.size() > 64) {
            List distinctFromOperators = fields.stream().map(field -> typeOperators.getDistinctFromOperator(field.getType(), InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION))).collect(Collectors.toUnmodifiableList());
            return Collections.singletonList(new OperatorMethodHandle(DISTINCT_FROM_CONVENTION, DISTINCT_FROM.bindTo(distinctFromOperators)));
        }
        MethodHandle distinctFrom = MethodHandles.dropArguments(MethodHandles.constant(Boolean.TYPE, false), 0, new Class[]{Block.class, Block.class});
        for (int fieldId = 0; fieldId < fields.size(); ++fieldId) {
            Field field2 = fields.get(fieldId);
            distinctFrom = MethodHandles.collectArguments(CHAIN_DISTINCT_FROM, 0, distinctFrom);
            MethodHandle fieldDistinctFromOperator = typeOperators.getDistinctFromOperator(field2.getType(), InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION));
            distinctFrom = MethodHandles.insertArguments(distinctFrom, 2, fieldId, fieldDistinctFromOperator);
            distinctFrom = MethodHandles.permuteArguments(distinctFrom, MethodType.methodType(Boolean.TYPE, Block.class, Block.class), 0, 1, 0, 1);
        }
        distinctFrom = CHAIN_DISTINCT_FROM_START.bindTo(distinctFrom);
        return Collections.singletonList(new OperatorMethodHandle(DISTINCT_FROM_CONVENTION, distinctFrom));
    }

    private static boolean megamorphicDistinctFromOperator(List<MethodHandle> distinctFromOperators, Block leftRow, Block rightRow) throws Throwable {
        boolean rightIsNull;
        boolean leftIsNull = leftRow == null;
        boolean bl = rightIsNull = rightRow == null;
        if (leftIsNull || rightIsNull) {
            return leftIsNull != rightIsNull;
        }
        for (int fieldIndex = 0; fieldIndex < distinctFromOperators.size(); ++fieldIndex) {
            MethodHandle equalOperator = distinctFromOperators.get(fieldIndex);
            boolean result = equalOperator.invoke(leftRow, fieldIndex, rightRow, fieldIndex);
            if (!result) continue;
            return true;
        }
        return false;
    }

    private static boolean chainDistinctFromStart(MethodHandle chain, Block rightRow, Block leftRow) throws Throwable {
        boolean rightIsNull;
        boolean leftIsNull = leftRow == null;
        boolean bl = rightIsNull = rightRow == null;
        if (leftIsNull || rightIsNull) {
            return leftIsNull != rightIsNull;
        }
        return chain.invokeExact(rightRow, leftRow);
    }

    private static boolean chainDistinctFrom(boolean previousFieldsDistinctFrom, int currentFieldIndex, MethodHandle currentFieldDistinctFrom, Block rightRow, Block leftRow) throws Throwable {
        if (previousFieldsDistinctFrom) {
            return true;
        }
        return currentFieldDistinctFrom.invokeExact(rightRow, currentFieldIndex, leftRow, currentFieldIndex);
    }

    private static List<OperatorMethodHandle> getIndeterminateOperatorInvokers(TypeOperators typeOperators, List<Field> fields) {
        boolean comparable = fields.stream().allMatch(field -> field.getType().isComparable());
        if (!comparable) {
            return Collections.emptyList();
        }
        if (fields.size() > 64) {
            List indeterminateOperators = fields.stream().map(field -> typeOperators.getIndeterminateOperator(field.getType(), InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION))).collect(Collectors.toUnmodifiableList());
            return Collections.singletonList(new OperatorMethodHandle(INDETERMINATE_CONVENTION, INDETERMINATE.bindTo(indeterminateOperators)));
        }
        MethodHandle indeterminate = MethodHandles.dropArguments(MethodHandles.constant(Boolean.TYPE, false), 0, new Class[]{Block.class});
        for (int fieldId = 0; fieldId < fields.size(); ++fieldId) {
            Field field2 = fields.get(fieldId);
            indeterminate = MethodHandles.collectArguments(CHAIN_INDETERMINATE, 0, indeterminate);
            MethodHandle fieldIndeterminateOperator = typeOperators.getIndeterminateOperator(field2.getType(), InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION));
            indeterminate = MethodHandles.insertArguments(indeterminate, 1, fieldId, fieldIndeterminateOperator);
            indeterminate = MethodHandles.permuteArguments(indeterminate, MethodType.methodType(Boolean.TYPE, Block.class), 0, 0);
        }
        return Collections.singletonList(new OperatorMethodHandle(INDETERMINATE_CONVENTION, indeterminate));
    }

    private static boolean megamorphicIndeterminateOperator(List<MethodHandle> indeterminateOperators, Block rowBlock) throws Throwable {
        if (rowBlock == null) {
            return true;
        }
        for (int fieldIndex = 0; fieldIndex < indeterminateOperators.size(); ++fieldIndex) {
            MethodHandle indeterminateOperator;
            if (rowBlock.isNull(fieldIndex) || !(indeterminateOperator = indeterminateOperators.get(fieldIndex)).invokeExact(rowBlock, fieldIndex)) continue;
            return true;
        }
        return false;
    }

    private static boolean chainIndeterminate(boolean previousFieldIndeterminate, int currentFieldIndex, MethodHandle currentFieldIndeterminateOperator, Block row) throws Throwable {
        if (row == null || previousFieldIndeterminate) {
            return true;
        }
        return currentFieldIndeterminateOperator.invokeExact(row, currentFieldIndex);
    }

    private static List<OperatorMethodHandle> getComparisonOperatorInvokers(TypeOperators typeOperators, List<Field> fields) {
        boolean orderable = fields.stream().allMatch(field -> field.getType().isOrderable());
        if (!orderable) {
            return Collections.emptyList();
        }
        if (fields.size() > 64) {
            List comparisonOperators = fields.stream().map(field -> typeOperators.getComparisonOperator(field.getType(), InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION))).collect(Collectors.toUnmodifiableList());
            return Collections.singletonList(new OperatorMethodHandle(COMPARISON_CONVENTION, COMPARISON.bindTo(comparisonOperators)));
        }
        MethodHandle comparison = MethodHandles.dropArguments(MethodHandles.constant(Long.TYPE, 0), 0, new Class[]{Block.class, Block.class});
        for (int fieldId = 0; fieldId < fields.size(); ++fieldId) {
            Field field2 = fields.get(fieldId);
            comparison = MethodHandles.collectArguments(CHAIN_COMPARISON, 0, comparison);
            MethodHandle fieldComparisonOperator = typeOperators.getComparisonOperator(field2.getType(), InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION));
            comparison = MethodHandles.insertArguments(comparison, 2, fieldId, fieldComparisonOperator);
            comparison = MethodHandles.permuteArguments(comparison, MethodType.methodType(Long.TYPE, Block.class, Block.class), 0, 1, 0, 1);
        }
        return Collections.singletonList(new OperatorMethodHandle(COMPARISON_CONVENTION, comparison));
    }

    private static long megamorphicComparisonOperator(List<MethodHandle> comparisonOperators, Block leftRow, Block rightRow) throws Throwable {
        for (int fieldIndex = 0; fieldIndex < comparisonOperators.size(); ++fieldIndex) {
            RowType.checkElementNotNull(leftRow.isNull(fieldIndex));
            RowType.checkElementNotNull(rightRow.isNull(fieldIndex));
            MethodHandle comparisonOperator = comparisonOperators.get(fieldIndex);
            long result = comparisonOperator.invoke(leftRow, fieldIndex, rightRow, fieldIndex);
            if (result != 0L) continue;
            return result;
        }
        return 0L;
    }

    private static long chainComparison(long previousFieldsResult, int fieldIndex, MethodHandle nextFieldComparison, Block rightRow, Block leftRow) throws Throwable {
        if (previousFieldsResult != 0L) {
            return previousFieldsResult;
        }
        RowType.checkElementNotNull(leftRow.isNull(fieldIndex));
        RowType.checkElementNotNull(rightRow.isNull(fieldIndex));
        return nextFieldComparison.invokeExact(rightRow, fieldIndex, leftRow, fieldIndex);
    }

    private static void checkElementNotNull(boolean isNull) {
        if (isNull) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "ROW comparison not supported for fields with null elements");
        }
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            EQUAL = lookup.findStatic(RowType.class, "megamorphicEqualOperator", MethodType.methodType(Boolean.class, List.class, Block.class, Block.class));
            CHAIN_EQUAL = lookup.findStatic(RowType.class, "chainEqual", MethodType.methodType(Boolean.class, Boolean.class, Integer.TYPE, MethodHandle.class, Block.class, Block.class));
            HASH_CODE = lookup.findStatic(RowType.class, "megamorphicHashCodeOperator", MethodType.methodType(Long.TYPE, List.class, Block.class));
            CHAIN_HASH_CODE = lookup.findStatic(RowType.class, "chainHashCode", MethodType.methodType(Long.TYPE, Long.TYPE, Integer.TYPE, MethodHandle.class, Block.class));
            DISTINCT_FROM = lookup.findStatic(RowType.class, "megamorphicDistinctFromOperator", MethodType.methodType(Boolean.TYPE, List.class, Block.class, Block.class));
            CHAIN_DISTINCT_FROM_START = lookup.findStatic(RowType.class, "chainDistinctFromStart", MethodType.methodType(Boolean.TYPE, MethodHandle.class, Block.class, Block.class));
            CHAIN_DISTINCT_FROM = lookup.findStatic(RowType.class, "chainDistinctFrom", MethodType.methodType(Boolean.TYPE, Boolean.TYPE, Integer.TYPE, MethodHandle.class, Block.class, Block.class));
            INDETERMINATE = lookup.findStatic(RowType.class, "megamorphicIndeterminateOperator", MethodType.methodType(Boolean.TYPE, List.class, Block.class));
            CHAIN_INDETERMINATE = lookup.findStatic(RowType.class, "chainIndeterminate", MethodType.methodType(Boolean.TYPE, Boolean.TYPE, Integer.TYPE, MethodHandle.class, Block.class));
            COMPARISON = lookup.findStatic(RowType.class, "megamorphicComparisonOperator", MethodType.methodType(Long.TYPE, List.class, Block.class, Block.class));
            CHAIN_COMPARISON = lookup.findStatic(RowType.class, "chainComparison", MethodType.methodType(Long.TYPE, Long.TYPE, Integer.TYPE, MethodHandle.class, Block.class, Block.class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Field {
        private final Type type;
        private final Optional<String> name;

        public Field(Optional<String> name, Type type) {
            this.type = Objects.requireNonNull(type, "type is null");
            this.name = Objects.requireNonNull(name, "name is null");
        }

        public Type getType() {
            return this.type;
        }

        public Optional<String> getName() {
            return this.name;
        }
    }
}

