/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import com.fasterxml.jackson.annotation.JsonValue;
import io.trino.spi.type.Timestamps;
import java.util.Objects;

public final class SqlTime {
    private final int precision;
    private final long picos;

    public static SqlTime newInstance(int precision, long picos) {
        if (Timestamps.rescale(Timestamps.rescale(picos, 12, precision), precision, 12) != picos) {
            throw new IllegalArgumentException("picos contains data beyond specified precision: " + precision);
        }
        if (picos < 0L || picos > 86400000000000000L) {
            throw new IllegalArgumentException("picos is out of range: " + picos);
        }
        return new SqlTime(precision, picos);
    }

    private SqlTime(int precision, long picos) {
        this.precision = precision;
        this.picos = picos;
    }

    public long getPicos() {
        return this.picos;
    }

    public SqlTime roundTo(int precision) {
        return new SqlTime(precision, Timestamps.round(this.picos, 12 - precision));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlTime sqlTime = (SqlTime)o;
        return this.precision == sqlTime.precision && this.picos == sqlTime.picos;
    }

    public int hashCode() {
        return Objects.hash(this.precision, this.picos);
    }

    @JsonValue
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("%02d:%02d:%02d", this.picos / 3600000000000000L, this.picos / 60000000000000L % 60L, this.picos / 1000000000000L % 60L));
        if (this.precision > 0) {
            long scaledFraction = this.picos % 1000000000000L / Timestamps.POWERS_OF_TEN[12 - this.precision];
            builder.append(".");
            builder.append(String.format("%0" + this.precision + "d", scaledFraction));
        }
        return builder.toString();
    }
}

