/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.airlift.slice.XxHash64;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.type.AbstractLongType;
import io.trino.spi.type.SqlTime;
import io.trino.spi.type.TypeOperatorDeclaration;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import java.lang.invoke.MethodHandles;

public final class TimeType
extends AbstractLongType {
    private static final TypeOperatorDeclaration TYPE_OPERATOR_DECLARATION = TypeOperatorDeclaration.extractOperatorDeclaration(TimeType.class, MethodHandles.lookup(), Long.TYPE);
    public static final int MAX_PRECISION = 12;
    public static final int DEFAULT_PRECISION = 3;
    private static final TimeType[] TYPES = new TimeType[13];
    public static final TimeType TIME_SECONDS;
    public static final TimeType TIME_MILLIS;
    public static final TimeType TIME_MICROS;
    public static final TimeType TIME_NANOS;
    public static final TimeType TIME_PICOS;
    @Deprecated
    public static final TimeType TIME;
    private final int precision;

    private TimeType(int precision) {
        super(new TypeSignature("time", TypeSignatureParameter.numericParameter(precision)));
        this.precision = precision;
    }

    public static TimeType createTimeType(int precision) {
        if (precision < 0 || precision > 12) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, String.format("TIME precision must be in range [0, %s]: %s", 12, precision));
        }
        return TYPES[precision];
    }

    public int getPrecision() {
        return this.precision;
    }

    @Override
    public TypeOperatorDeclaration getTypeOperatorDeclaration(TypeOperators typeOperators) {
        return TYPE_OPERATOR_DECLARATION;
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        return SqlTime.newInstance(this.precision, block.getLong(position, 0));
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    public static boolean equalOperator(long left, long right) {
        return left == right;
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    public static long hashCodeOperator(long value) {
        return AbstractLongType.hash(value);
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    public static long xxHash64Operator(long value) {
        return XxHash64.hash((long)value);
    }

    @ScalarOperator(value=OperatorType.COMPARISON)
    private static long comparisonOperator(long left, long right) {
        return Long.compare(left, right);
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    public static boolean lessThan(long left, long right) {
        return left < right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    public static boolean lessThanOrEqual(long left, long right) {
        return left <= right;
    }

    static {
        for (int precision = 0; precision <= 12; ++precision) {
            TimeType.TYPES[precision] = new TimeType(precision);
        }
        TIME_SECONDS = TimeType.createTimeType(0);
        TIME_MILLIS = TimeType.createTimeType(3);
        TIME_MICROS = TimeType.createTimeType(6);
        TIME_NANOS = TimeType.createTimeType(9);
        TIME_PICOS = TimeType.createTimeType(12);
        TIME = new TimeType(3);
    }
}

