/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.type.Decimals;
import java.math.BigInteger;
import java.nio.ByteOrder;
import java.util.Arrays;

public final class UnscaledDecimal128Arithmetic {
    private static final int NUMBER_OF_LONGS = 2;
    private static final int NUMBER_OF_INTS = 4;
    public static final int UNSCALED_DECIMAL_128_SLICE_LENGTH = 16;
    private static final Slice[] POWERS_OF_TEN;
    private static final Slice[] POWERS_OF_FIVE;
    private static final int SIGN_LONG_INDEX = 1;
    private static final int SIGN_INT_INDEX = 3;
    private static final long SIGN_LONG_MASK = Long.MIN_VALUE;
    private static final int SIGN_INT_MASK = Integer.MIN_VALUE;
    private static final int SIGN_BYTE_MASK = 128;
    private static final long ALL_BITS_SET_64 = -1L;
    private static final long INT_BASE = 0x100000000L;
    private static final long LOW_32_BITS = 0xFFFFFFFFL;
    private static final int MAX_POWER_OF_FIVE_INT = 13;
    private static final int[] POWERS_OF_FIVES_INT;
    private static final int MAX_POWER_OF_FIVE_LONG = 27;
    private static final long[] POWERS_OF_FIVE_LONG;
    private static final int MAX_POWER_OF_TEN_INT = 9;
    private static final int MAX_POWER_OF_TEN_LONG = 18;
    private static final int[] POWERS_OF_TEN_INT;

    public static Slice unscaledDecimal() {
        return Slices.allocate((int)16);
    }

    public static Slice unscaledDecimal(Slice decimal) {
        return Slices.copyOf((Slice)decimal);
    }

    public static Slice unscaledDecimal(String unscaledValue) {
        return UnscaledDecimal128Arithmetic.unscaledDecimal(new BigInteger(unscaledValue));
    }

    public static Slice unscaledDecimal(BigInteger unscaledValue) {
        Slice decimal = Slices.allocate((int)16);
        return UnscaledDecimal128Arithmetic.pack(unscaledValue, decimal);
    }

    public static Slice pack(BigInteger unscaledValue, Slice result) {
        UnscaledDecimal128Arithmetic.pack(0L, 0L, false, result);
        byte[] bytes = unscaledValue.abs().toByteArray();
        if (bytes.length > 16 || bytes.length == 16 && (bytes[0] & 0x80) != 0) {
            UnscaledDecimal128Arithmetic.throwOverflowException();
        }
        UnscaledDecimal128Arithmetic.reverse(bytes);
        result.setBytes(0, bytes);
        if (unscaledValue.signum() < 0) {
            UnscaledDecimal128Arithmetic.setNegative(result, true);
        }
        UnscaledDecimal128Arithmetic.throwIfOverflows(result);
        return result;
    }

    public static Slice unscaledDecimal(long unscaledValue) {
        long[] longs = new long[2];
        if (unscaledValue < 0L) {
            longs[0] = -unscaledValue;
            longs[1] = Long.MIN_VALUE;
        } else {
            longs[0] = unscaledValue;
        }
        return Slices.wrappedLongArray((long[])longs);
    }

    public static BigInteger unscaledDecimalToBigInteger(Slice decimal) {
        byte[] bytes = decimal.getBytes(0, 16);
        UnscaledDecimal128Arithmetic.reverse(bytes);
        bytes[0] = (byte)(bytes[0] & 0xFFFFFF7F);
        return new BigInteger(UnscaledDecimal128Arithmetic.isNegative(decimal) ? -1 : 1, bytes);
    }

    public static long unscaledDecimalToUnscaledLong(Slice decimal) {
        long low = UnscaledDecimal128Arithmetic.getLong(decimal, 0);
        long high = UnscaledDecimal128Arithmetic.getLong(decimal, 1);
        boolean negative = UnscaledDecimal128Arithmetic.isNegative(decimal);
        if (high != 0L || (low > Long.MIN_VALUE || !negative) && low < 0L) {
            UnscaledDecimal128Arithmetic.throwOverflowException();
        }
        return negative ? -low : low;
    }

    public static long unscaledDecimalToUnscaledLongUnsafe(Slice decimal) {
        long low = UnscaledDecimal128Arithmetic.getLong(decimal, 0);
        return UnscaledDecimal128Arithmetic.isNegative(decimal) ? -low : low;
    }

    public static Slice rescale(Slice decimal, int rescaleFactor) {
        if (rescaleFactor == 0) {
            return decimal;
        }
        Slice result = UnscaledDecimal128Arithmetic.unscaledDecimal();
        UnscaledDecimal128Arithmetic.rescale(decimal, rescaleFactor, result);
        return result;
    }

    public static void rescale(Slice decimal, int rescaleFactor, Slice result) {
        if (rescaleFactor == 0) {
            UnscaledDecimal128Arithmetic.copyUnscaledDecimal(decimal, result);
        } else if (rescaleFactor > 0) {
            if (rescaleFactor >= POWERS_OF_TEN.length) {
                UnscaledDecimal128Arithmetic.throwOverflowException();
            }
            UnscaledDecimal128Arithmetic.shiftLeftBy10(decimal, rescaleFactor, result);
        } else {
            UnscaledDecimal128Arithmetic.scaleDownRoundUp(decimal, -rescaleFactor, result);
        }
    }

    public static Slice rescale(long decimal, int rescaleFactor) {
        Slice result = UnscaledDecimal128Arithmetic.unscaledDecimal();
        if (rescaleFactor == 0) {
            return UnscaledDecimal128Arithmetic.unscaledDecimal(decimal);
        }
        if (rescaleFactor > 0) {
            if (rescaleFactor >= POWERS_OF_TEN.length) {
                UnscaledDecimal128Arithmetic.throwOverflowException();
            }
            UnscaledDecimal128Arithmetic.shiftLeftBy10(decimal, rescaleFactor, result);
        } else {
            UnscaledDecimal128Arithmetic.scaleDownRoundUp(UnscaledDecimal128Arithmetic.unscaledDecimal(decimal), -rescaleFactor, result);
        }
        return result;
    }

    public static Slice rescaleTruncate(Slice decimal, int rescaleFactor) {
        if (rescaleFactor == 0) {
            return decimal;
        }
        Slice result = UnscaledDecimal128Arithmetic.unscaledDecimal();
        UnscaledDecimal128Arithmetic.rescaleTruncate(decimal, rescaleFactor, result);
        return result;
    }

    public static void rescaleTruncate(Slice decimal, int rescaleFactor, Slice result) {
        if (rescaleFactor == 0) {
            UnscaledDecimal128Arithmetic.copyUnscaledDecimal(decimal, result);
        } else if (rescaleFactor > 0) {
            if (rescaleFactor >= POWERS_OF_TEN.length) {
                UnscaledDecimal128Arithmetic.throwOverflowException();
            }
            UnscaledDecimal128Arithmetic.shiftLeftBy10(decimal, rescaleFactor, result);
        } else {
            UnscaledDecimal128Arithmetic.scaleDownTruncate(decimal, -rescaleFactor, result);
        }
    }

    private static void shiftLeftBy10(Slice decimal, int rescaleFactor, Slice result) {
        if (rescaleFactor <= 9) {
            UnscaledDecimal128Arithmetic.multiply(decimal, (int)Decimals.longTenToNth(rescaleFactor), result);
        } else if (rescaleFactor <= 18) {
            UnscaledDecimal128Arithmetic.multiply(decimal, Decimals.longTenToNth(rescaleFactor), result);
        } else {
            UnscaledDecimal128Arithmetic.multiply(POWERS_OF_TEN[rescaleFactor], decimal, result);
        }
    }

    private static void shiftLeftBy10(long decimal, int rescaleFactor, Slice result) {
        if (rescaleFactor <= 9) {
            UnscaledDecimal128Arithmetic.multiply(decimal, (int)Decimals.longTenToNth(rescaleFactor), result);
        } else if (rescaleFactor <= 18) {
            UnscaledDecimal128Arithmetic.multiply(decimal, Decimals.longTenToNth(rescaleFactor), result);
        } else {
            UnscaledDecimal128Arithmetic.multiply(POWERS_OF_TEN[rescaleFactor], decimal, result);
        }
    }

    private static void scaleDownTruncate(Slice decimal, int scaleFactor, Slice result) {
        long low = UnscaledDecimal128Arithmetic.getLong(decimal, 0);
        long high = UnscaledDecimal128Arithmetic.getLong(decimal, 1);
        if (scaleFactor <= 18 && high == 0L && low >= 0L) {
            long divisor = Decimals.longTenToNth(scaleFactor);
            long newLow = low / divisor;
            UnscaledDecimal128Arithmetic.pack(result, newLow, 0L, UnscaledDecimal128Arithmetic.isNegative(decimal));
            return;
        }
        if ((scaleFactor - 1) / 13 < (scaleFactor - 1) / 9) {
            UnscaledDecimal128Arithmetic.scaleDownFive(decimal, scaleFactor, result);
            UnscaledDecimal128Arithmetic.shiftRightTruncate(result, scaleFactor, result);
        } else {
            UnscaledDecimal128Arithmetic.scaleDownTenTruncate(decimal, scaleFactor, result);
        }
    }

    public static Slice add(Slice left, Slice right) {
        Slice result = UnscaledDecimal128Arithmetic.unscaledDecimal();
        UnscaledDecimal128Arithmetic.add(left, right, result);
        return result;
    }

    public static void add(Slice left, Slice right, Slice result) {
        long overflow = UnscaledDecimal128Arithmetic.addWithOverflow(left, right, result);
        if (overflow != 0L) {
            UnscaledDecimal128Arithmetic.throwOverflowException();
        }
    }

    public static long addWithOverflow(Slice left, Slice right, Slice result) {
        boolean leftNegative = UnscaledDecimal128Arithmetic.isNegative(left);
        boolean rightNegative = UnscaledDecimal128Arithmetic.isNegative(right);
        long overflow = 0L;
        if (leftNegative == rightNegative) {
            overflow = UnscaledDecimal128Arithmetic.addUnsignedReturnOverflow(left, right, result, leftNegative);
            if (leftNegative) {
                overflow = -overflow;
            }
        } else {
            int compare = UnscaledDecimal128Arithmetic.compareAbsolute(left, right);
            if (compare > 0) {
                UnscaledDecimal128Arithmetic.subtractUnsigned(left, right, result, leftNegative);
            } else if (compare < 0) {
                UnscaledDecimal128Arithmetic.subtractUnsigned(right, left, result, !leftNegative);
            } else {
                UnscaledDecimal128Arithmetic.setToZero(result);
            }
        }
        return overflow;
    }

    public static Slice subtract(Slice left, Slice right) {
        Slice result = UnscaledDecimal128Arithmetic.unscaledDecimal();
        UnscaledDecimal128Arithmetic.subtract(left, right, result);
        return result;
    }

    public static void subtract(Slice left, Slice right, Slice result) {
        boolean rightNegative;
        boolean leftNegative = UnscaledDecimal128Arithmetic.isNegative(left);
        if (leftNegative != (rightNegative = UnscaledDecimal128Arithmetic.isNegative(right))) {
            if (UnscaledDecimal128Arithmetic.addUnsignedReturnOverflow(left, right, result, leftNegative) != 0L) {
                UnscaledDecimal128Arithmetic.throwOverflowException();
            }
        } else {
            int compare = UnscaledDecimal128Arithmetic.compareAbsolute(left, right);
            if (compare > 0) {
                UnscaledDecimal128Arithmetic.subtractUnsigned(left, right, result, leftNegative);
            } else if (compare < 0) {
                UnscaledDecimal128Arithmetic.subtractUnsigned(right, left, result, !leftNegative);
            } else {
                UnscaledDecimal128Arithmetic.setToZero(result);
            }
        }
    }

    private static long addUnsignedReturnOverflow(Slice left, Slice right, Slice result, boolean resultNegative) {
        long l0 = UnscaledDecimal128Arithmetic.getLong(left, 0);
        long l1 = UnscaledDecimal128Arithmetic.getLong(left, 1);
        long r0 = UnscaledDecimal128Arithmetic.getLong(right, 0);
        long r1 = UnscaledDecimal128Arithmetic.getLong(right, 1);
        long z0 = l0 + r0;
        int overflow = UnscaledDecimal128Arithmetic.unsignedIsSmaller(z0, l0) ? 1 : 0;
        long intermediateResult = l1 + r1 + (long)overflow;
        long z1 = intermediateResult & Long.MAX_VALUE;
        UnscaledDecimal128Arithmetic.pack(result, z0, z1, resultNegative);
        return intermediateResult >>> 63;
    }

    private static void subtractUnsigned(Slice left, Slice right, Slice result, boolean resultNegative) {
        long l0 = UnscaledDecimal128Arithmetic.getLong(left, 0);
        long l1 = UnscaledDecimal128Arithmetic.getLong(left, 1);
        long r0 = UnscaledDecimal128Arithmetic.getLong(right, 0);
        long r1 = UnscaledDecimal128Arithmetic.getLong(right, 1);
        long z0 = l0 - r0;
        int underflow = UnscaledDecimal128Arithmetic.unsignedIsSmaller(l0, z0) ? 1 : 0;
        long z1 = l1 - r1 - (long)underflow;
        UnscaledDecimal128Arithmetic.pack(result, z0, z1, resultNegative);
    }

    public static Slice multiply(Slice left, Slice right) {
        Slice result = UnscaledDecimal128Arithmetic.unscaledDecimal();
        UnscaledDecimal128Arithmetic.multiply(left, right, result);
        return result;
    }

    public static Slice multiply(Slice left, long right) {
        Slice result = UnscaledDecimal128Arithmetic.unscaledDecimal();
        UnscaledDecimal128Arithmetic.multiply(left, right, result);
        return result;
    }

    public static Slice multiply(long left, long right) {
        Slice result = UnscaledDecimal128Arithmetic.unscaledDecimal();
        UnscaledDecimal128Arithmetic.multiply(left, right, result);
        return result;
    }

    public static void multiply(Slice left, Slice right, Slice result) {
        UnscaledDecimal128Arithmetic.checkArgument(result.length() == 16);
        UnscaledDecimal128Arithmetic.multiply(UnscaledDecimal128Arithmetic.getRawLong(left, 0), UnscaledDecimal128Arithmetic.getRawLong(left, 1), UnscaledDecimal128Arithmetic.getRawLong(right, 0), UnscaledDecimal128Arithmetic.getRawLong(right, 1), result);
    }

    public static void multiply(long leftLow, long leftHigh, long rightLow, long rightHigh, Slice result) {
        long accumulator;
        UnscaledDecimal128Arithmetic.checkArgument(result.length() == 16);
        long l0 = UnscaledDecimal128Arithmetic.low(leftLow);
        long l1 = UnscaledDecimal128Arithmetic.high(leftLow);
        long l2 = UnscaledDecimal128Arithmetic.low(leftHigh);
        boolean leftNegative = UnscaledDecimal128Arithmetic.isNegative(leftHigh);
        long l3 = UnscaledDecimal128Arithmetic.unpackUnsignedInt(UnscaledDecimal128Arithmetic.high(leftHigh));
        long r0 = UnscaledDecimal128Arithmetic.low(rightLow);
        long r1 = UnscaledDecimal128Arithmetic.high(rightLow);
        long r2 = UnscaledDecimal128Arithmetic.low(rightHigh);
        boolean rightNegative = UnscaledDecimal128Arithmetic.isNegative(rightHigh);
        long r3 = UnscaledDecimal128Arithmetic.unpackUnsignedInt(UnscaledDecimal128Arithmetic.high(rightHigh));
        if (r3 != 0L && (l3 | l2 | l1) != 0L || r2 != 0L && (l3 | l2) != 0L || r1 != 0L && l3 != 0L) {
            UnscaledDecimal128Arithmetic.throwOverflowException();
        }
        long z0 = 0L;
        long z1 = 0L;
        long z2 = 0L;
        long z3 = 0L;
        if (l0 != 0L) {
            accumulator = r0 * l0;
            z0 = UnscaledDecimal128Arithmetic.low(accumulator);
            accumulator = UnscaledDecimal128Arithmetic.high(accumulator) + r1 * l0;
            z1 = UnscaledDecimal128Arithmetic.low(accumulator);
            accumulator = UnscaledDecimal128Arithmetic.high(accumulator) + r2 * l0;
            z2 = UnscaledDecimal128Arithmetic.low(accumulator);
            accumulator = UnscaledDecimal128Arithmetic.high(accumulator) + r3 * l0;
            z3 = UnscaledDecimal128Arithmetic.low(accumulator);
            if (UnscaledDecimal128Arithmetic.high(accumulator) != 0L) {
                UnscaledDecimal128Arithmetic.throwOverflowException();
            }
        }
        if (l1 != 0L) {
            accumulator = r0 * l1 + z1;
            z1 = UnscaledDecimal128Arithmetic.low(accumulator);
            accumulator = UnscaledDecimal128Arithmetic.high(accumulator) + r1 * l1 + z2;
            z2 = UnscaledDecimal128Arithmetic.low(accumulator);
            accumulator = UnscaledDecimal128Arithmetic.high(accumulator) + r2 * l1 + z3;
            z3 = UnscaledDecimal128Arithmetic.low(accumulator);
            if (UnscaledDecimal128Arithmetic.high(accumulator) != 0L) {
                UnscaledDecimal128Arithmetic.throwOverflowException();
            }
        }
        if (l2 != 0L) {
            accumulator = r0 * l2 + z2;
            z2 = UnscaledDecimal128Arithmetic.low(accumulator);
            accumulator = UnscaledDecimal128Arithmetic.high(accumulator) + r1 * l2 + z3;
            z3 = UnscaledDecimal128Arithmetic.low(accumulator);
            if (UnscaledDecimal128Arithmetic.high(accumulator) != 0L) {
                UnscaledDecimal128Arithmetic.throwOverflowException();
            }
        }
        if (l3 != 0L) {
            accumulator = r0 * l3 + z3;
            z3 = UnscaledDecimal128Arithmetic.low(accumulator);
            if (UnscaledDecimal128Arithmetic.high(accumulator) != 0L) {
                UnscaledDecimal128Arithmetic.throwOverflowException();
            }
        }
        UnscaledDecimal128Arithmetic.pack(result, (int)z0, (int)z1, (int)z2, (int)z3, leftNegative != rightNegative);
    }

    public static void multiply(Slice left, long right, Slice result) {
        boolean rightNegative;
        UnscaledDecimal128Arithmetic.checkArgument(result.length() == 16);
        boolean bl = rightNegative = right < 0L;
        if (rightNegative) {
            right = -right;
        }
        UnscaledDecimal128Arithmetic.multiply(UnscaledDecimal128Arithmetic.getRawLong(left, 0), UnscaledDecimal128Arithmetic.getRawLong(left, 1), right, rightNegative ? Long.MIN_VALUE : 0L, result);
    }

    public static void multiply(Slice left, int right, Slice result) {
        UnscaledDecimal128Arithmetic.checkArgument(result.length() == 16);
        long l0 = Integer.toUnsignedLong(UnscaledDecimal128Arithmetic.getInt(left, 0));
        long l1 = Integer.toUnsignedLong(UnscaledDecimal128Arithmetic.getInt(left, 1));
        long l2 = Integer.toUnsignedLong(UnscaledDecimal128Arithmetic.getInt(left, 2));
        int l3raw = UnscaledDecimal128Arithmetic.getRawInt(left, 3);
        boolean leftNegative = UnscaledDecimal128Arithmetic.isNegative(l3raw);
        long l3 = Integer.toUnsignedLong(UnscaledDecimal128Arithmetic.unpackUnsignedInt(l3raw));
        boolean rightNegative = right < 0;
        long r0 = Math.abs(right);
        long accumulator = r0 * l0;
        long z0 = UnscaledDecimal128Arithmetic.low(accumulator);
        accumulator = UnscaledDecimal128Arithmetic.high(accumulator) + l1 * r0;
        long z1 = UnscaledDecimal128Arithmetic.low(accumulator);
        accumulator = UnscaledDecimal128Arithmetic.high(accumulator) + l2 * r0;
        long z2 = UnscaledDecimal128Arithmetic.low(accumulator);
        accumulator = UnscaledDecimal128Arithmetic.high(accumulator) + l3 * r0;
        long z3 = UnscaledDecimal128Arithmetic.low(accumulator);
        if (UnscaledDecimal128Arithmetic.high(accumulator) != 0L) {
            UnscaledDecimal128Arithmetic.throwOverflowException();
        }
        UnscaledDecimal128Arithmetic.pack(result, (int)z0, (int)z1, (int)z2, (int)z3, leftNegative != rightNegative);
    }

    public static void multiply(long left, long right, Slice result) {
        UnscaledDecimal128Arithmetic.checkArgument(result.length() == 16);
        boolean rightNegative = right < 0L;
        boolean leftNegative = left < 0L;
        left = Math.abs(left);
        right = Math.abs(right);
        long l0 = UnscaledDecimal128Arithmetic.low(left);
        long l1 = UnscaledDecimal128Arithmetic.high(left);
        long r0 = UnscaledDecimal128Arithmetic.low(right);
        long r1 = UnscaledDecimal128Arithmetic.high(right);
        long accumulator = r0 * l0;
        long z0 = UnscaledDecimal128Arithmetic.low(accumulator);
        accumulator = UnscaledDecimal128Arithmetic.high(accumulator) + r1 * l0;
        long z1 = UnscaledDecimal128Arithmetic.low(accumulator);
        long z2 = accumulator >> 32;
        accumulator = r0 * l1 + z1;
        z1 = UnscaledDecimal128Arithmetic.low(accumulator);
        accumulator = UnscaledDecimal128Arithmetic.high(accumulator) + r1 * l1 + z2;
        z2 = UnscaledDecimal128Arithmetic.low(accumulator);
        long z3 = UnscaledDecimal128Arithmetic.high(accumulator);
        UnscaledDecimal128Arithmetic.pack(result, (int)z0, (int)z1, (int)z2, (int)z3, leftNegative != rightNegative);
    }

    public static void multiply(long left, int right, Slice result) {
        UnscaledDecimal128Arithmetic.checkArgument(result.length() == 16);
        boolean rightNegative = right < 0;
        boolean leftNegative = left < 0L;
        left = Math.abs(left);
        long r0 = Math.abs(right);
        long l0 = UnscaledDecimal128Arithmetic.low(left);
        long l1 = UnscaledDecimal128Arithmetic.high(left);
        long accumulator = r0 * l0;
        long z0 = UnscaledDecimal128Arithmetic.low(accumulator);
        long z1 = UnscaledDecimal128Arithmetic.high(accumulator);
        accumulator = r0 * l1 + z1;
        z1 = UnscaledDecimal128Arithmetic.low(accumulator);
        long z2 = UnscaledDecimal128Arithmetic.high(accumulator);
        UnscaledDecimal128Arithmetic.pack(result, (int)z0, (int)z1, (int)z2, 0, leftNegative != rightNegative);
    }

    static void multiply256Destructive(int[] left, Slice right) {
        long accumulator;
        long l0 = Integer.toUnsignedLong(left[0]);
        long l1 = Integer.toUnsignedLong(left[1]);
        long l2 = Integer.toUnsignedLong(left[2]);
        long l3 = Integer.toUnsignedLong(left[3]);
        long r0 = Integer.toUnsignedLong(UnscaledDecimal128Arithmetic.getInt(right, 0));
        long r1 = Integer.toUnsignedLong(UnscaledDecimal128Arithmetic.getInt(right, 1));
        long r2 = Integer.toUnsignedLong(UnscaledDecimal128Arithmetic.getInt(right, 2));
        long r3 = Integer.toUnsignedLong(UnscaledDecimal128Arithmetic.getInt(right, 3));
        long z0 = 0L;
        long z1 = 0L;
        long z2 = 0L;
        long z3 = 0L;
        long z4 = 0L;
        long z5 = 0L;
        long z6 = 0L;
        long z7 = 0L;
        if (l0 != 0L) {
            accumulator = r0 * l0;
            z0 = UnscaledDecimal128Arithmetic.low(accumulator);
            accumulator = UnscaledDecimal128Arithmetic.high(accumulator) + r1 * l0;
            z1 = UnscaledDecimal128Arithmetic.low(accumulator);
            accumulator = UnscaledDecimal128Arithmetic.high(accumulator) + r2 * l0;
            z2 = UnscaledDecimal128Arithmetic.low(accumulator);
            accumulator = UnscaledDecimal128Arithmetic.high(accumulator) + r3 * l0;
            z3 = UnscaledDecimal128Arithmetic.low(accumulator);
            z4 = UnscaledDecimal128Arithmetic.high(accumulator);
        }
        if (l1 != 0L) {
            accumulator = r0 * l1 + z1;
            z1 = UnscaledDecimal128Arithmetic.low(accumulator);
            accumulator = UnscaledDecimal128Arithmetic.high(accumulator) + r1 * l1 + z2;
            z2 = UnscaledDecimal128Arithmetic.low(accumulator);
            accumulator = UnscaledDecimal128Arithmetic.high(accumulator) + r2 * l1 + z3;
            z3 = UnscaledDecimal128Arithmetic.low(accumulator);
            accumulator = UnscaledDecimal128Arithmetic.high(accumulator) + r3 * l1 + z4;
            z4 = UnscaledDecimal128Arithmetic.low(accumulator);
            z5 = UnscaledDecimal128Arithmetic.high(accumulator);
        }
        if (l2 != 0L) {
            accumulator = r0 * l2 + z2;
            z2 = UnscaledDecimal128Arithmetic.low(accumulator);
            accumulator = UnscaledDecimal128Arithmetic.high(accumulator) + r1 * l2 + z3;
            z3 = UnscaledDecimal128Arithmetic.low(accumulator);
            accumulator = UnscaledDecimal128Arithmetic.high(accumulator) + r2 * l2 + z4;
            z4 = UnscaledDecimal128Arithmetic.low(accumulator);
            accumulator = UnscaledDecimal128Arithmetic.high(accumulator) + r3 * l2 + z5;
            z5 = UnscaledDecimal128Arithmetic.low(accumulator);
            z6 = UnscaledDecimal128Arithmetic.high(accumulator);
        }
        if (l3 != 0L) {
            accumulator = r0 * l3 + z3;
            z3 = UnscaledDecimal128Arithmetic.low(accumulator);
            accumulator = UnscaledDecimal128Arithmetic.high(accumulator) + r1 * l3 + z4;
            z4 = UnscaledDecimal128Arithmetic.low(accumulator);
            accumulator = UnscaledDecimal128Arithmetic.high(accumulator) + r2 * l3 + z5;
            z5 = UnscaledDecimal128Arithmetic.low(accumulator);
            accumulator = UnscaledDecimal128Arithmetic.high(accumulator) + r3 * l3 + z6;
            z6 = UnscaledDecimal128Arithmetic.low(accumulator);
            z7 = UnscaledDecimal128Arithmetic.high(accumulator);
        }
        left[0] = (int)z0;
        left[1] = (int)z1;
        left[2] = (int)z2;
        left[3] = (int)z3;
        left[4] = (int)z4;
        left[5] = (int)z5;
        left[6] = (int)z6;
        left[7] = (int)z7;
    }

    static void multiply256Destructive(int[] left, long right) {
        long accumulator;
        long l0 = Integer.toUnsignedLong(left[0]);
        long l1 = Integer.toUnsignedLong(left[1]);
        long l2 = Integer.toUnsignedLong(left[2]);
        long l3 = Integer.toUnsignedLong(left[3]);
        long r0 = UnscaledDecimal128Arithmetic.low(right);
        long r1 = UnscaledDecimal128Arithmetic.high(right);
        long z0 = 0L;
        long z1 = 0L;
        long z2 = 0L;
        long z3 = 0L;
        long z4 = 0L;
        long z5 = 0L;
        if (l0 != 0L) {
            accumulator = r0 * l0;
            z0 = UnscaledDecimal128Arithmetic.low(accumulator);
            accumulator = UnscaledDecimal128Arithmetic.high(accumulator) + r1 * l0;
            z1 = UnscaledDecimal128Arithmetic.low(accumulator);
            z2 = UnscaledDecimal128Arithmetic.high(accumulator);
        }
        if (l1 != 0L) {
            accumulator = r0 * l1 + z1;
            z1 = UnscaledDecimal128Arithmetic.low(accumulator);
            accumulator = UnscaledDecimal128Arithmetic.high(accumulator) + r1 * l1 + z2;
            z2 = UnscaledDecimal128Arithmetic.low(accumulator);
            z3 = UnscaledDecimal128Arithmetic.high(accumulator);
        }
        if (l2 != 0L) {
            accumulator = r0 * l2 + z2;
            z2 = UnscaledDecimal128Arithmetic.low(accumulator);
            accumulator = UnscaledDecimal128Arithmetic.high(accumulator) + r1 * l2 + z3;
            z3 = UnscaledDecimal128Arithmetic.low(accumulator);
            z4 = UnscaledDecimal128Arithmetic.high(accumulator);
        }
        if (l3 != 0L) {
            accumulator = r0 * l3 + z3;
            z3 = UnscaledDecimal128Arithmetic.low(accumulator);
            accumulator = UnscaledDecimal128Arithmetic.high(accumulator) + r1 * l3 + z4;
            z4 = UnscaledDecimal128Arithmetic.low(accumulator);
            z5 = UnscaledDecimal128Arithmetic.high(accumulator);
        }
        left[0] = (int)z0;
        left[1] = (int)z1;
        left[2] = (int)z2;
        left[3] = (int)z3;
        left[4] = (int)z4;
        left[5] = (int)z5;
    }

    static void multiply256Destructive(int[] left, int r0) {
        long l0 = Integer.toUnsignedLong(left[0]);
        long l1 = Integer.toUnsignedLong(left[1]);
        long l2 = Integer.toUnsignedLong(left[2]);
        long l3 = Integer.toUnsignedLong(left[3]);
        long accumulator = (long)r0 * l0;
        long z0 = UnscaledDecimal128Arithmetic.low(accumulator);
        long z1 = UnscaledDecimal128Arithmetic.high(accumulator);
        accumulator = (long)r0 * l1 + z1;
        z1 = UnscaledDecimal128Arithmetic.low(accumulator);
        long z2 = UnscaledDecimal128Arithmetic.high(accumulator);
        accumulator = (long)r0 * l2 + z2;
        z2 = UnscaledDecimal128Arithmetic.low(accumulator);
        long z3 = UnscaledDecimal128Arithmetic.high(accumulator);
        accumulator = (long)r0 * l3 + z3;
        z3 = UnscaledDecimal128Arithmetic.low(accumulator);
        long z4 = UnscaledDecimal128Arithmetic.high(accumulator);
        left[0] = (int)z0;
        left[1] = (int)z1;
        left[2] = (int)z2;
        left[3] = (int)z3;
        left[4] = (int)z4;
    }

    public static int compare(Slice left, Slice right) {
        boolean rightStrictlyNegative;
        boolean leftStrictlyNegative = UnscaledDecimal128Arithmetic.isStrictlyNegative(left);
        if (leftStrictlyNegative != (rightStrictlyNegative = UnscaledDecimal128Arithmetic.isStrictlyNegative(right))) {
            return leftStrictlyNegative ? -1 : 1;
        }
        return UnscaledDecimal128Arithmetic.compareAbsolute(left, right) * (leftStrictlyNegative ? -1 : 1);
    }

    public static int compare(long leftRawLow, long leftRawHigh, long rightRawLow, long rightRawHigh) {
        boolean rightStrictlyNegative;
        boolean leftStrictlyNegative = UnscaledDecimal128Arithmetic.isStrictlyNegative(leftRawLow, leftRawHigh);
        if (leftStrictlyNegative != (rightStrictlyNegative = UnscaledDecimal128Arithmetic.isStrictlyNegative(rightRawLow, rightRawHigh))) {
            return leftStrictlyNegative ? -1 : 1;
        }
        long leftHigh = UnscaledDecimal128Arithmetic.unpackUnsignedLong(leftRawHigh);
        long rightHigh = UnscaledDecimal128Arithmetic.unpackUnsignedLong(rightRawHigh);
        return UnscaledDecimal128Arithmetic.compareUnsigned(leftRawLow, leftHigh, rightRawLow, rightHigh) * (leftStrictlyNegative ? -1 : 1);
    }

    public static int compareAbsolute(Slice left, Slice right) {
        long rightLow;
        long rightHigh;
        long leftHigh = UnscaledDecimal128Arithmetic.getLong(left, 1);
        if (leftHigh != (rightHigh = UnscaledDecimal128Arithmetic.getLong(right, 1))) {
            return Long.compareUnsigned(leftHigh, rightHigh);
        }
        long leftLow = UnscaledDecimal128Arithmetic.getLong(left, 0);
        if (leftLow != (rightLow = UnscaledDecimal128Arithmetic.getLong(right, 0))) {
            return Long.compareUnsigned(leftLow, rightLow);
        }
        return 0;
    }

    public static int compareUnsigned(long leftRawLow, long leftRawHigh, long rightRawLow, long rightRawHigh) {
        if (leftRawHigh != rightRawHigh) {
            return Long.compareUnsigned(leftRawHigh, rightRawHigh);
        }
        if (leftRawLow != rightRawLow) {
            return Long.compareUnsigned(leftRawLow, rightRawLow);
        }
        return 0;
    }

    public static void incrementUnsafe(Slice decimal) {
        long low = UnscaledDecimal128Arithmetic.getLong(decimal, 0);
        if (low != -1L) {
            UnscaledDecimal128Arithmetic.setRawLong(decimal, 0, low + 1L);
            return;
        }
        long high = UnscaledDecimal128Arithmetic.getLong(decimal, 1);
        UnscaledDecimal128Arithmetic.setNegativeLong(decimal, high + 1L, UnscaledDecimal128Arithmetic.isNegative(decimal));
    }

    public static void negate(Slice decimal) {
        UnscaledDecimal128Arithmetic.setNegative(decimal, !UnscaledDecimal128Arithmetic.isNegative(decimal));
    }

    public static boolean isStrictlyNegative(Slice decimal) {
        return UnscaledDecimal128Arithmetic.isStrictlyNegative(UnscaledDecimal128Arithmetic.getRawLong(decimal, 0), UnscaledDecimal128Arithmetic.getRawLong(decimal, 1));
    }

    public static boolean isStrictlyNegative(long rawLow, long rawHigh) {
        return UnscaledDecimal128Arithmetic.isNegative(rawHigh) && (rawLow != 0L || UnscaledDecimal128Arithmetic.unpackUnsignedLong(rawHigh) != 0L);
    }

    private static boolean isNegative(int lastRawHigh) {
        return lastRawHigh >>> 31 != 0;
    }

    public static boolean isNegative(Slice decimal) {
        return UnscaledDecimal128Arithmetic.isNegative(UnscaledDecimal128Arithmetic.getRawInt(decimal, 3));
    }

    public static boolean isNegative(long rawHigh) {
        return rawHigh >>> 63 != 0L;
    }

    public static boolean isZero(Slice decimal) {
        return UnscaledDecimal128Arithmetic.getLong(decimal, 0) == 0L && UnscaledDecimal128Arithmetic.getLong(decimal, 1) == 0L;
    }

    public static String toUnscaledString(Slice decimal) {
        if (UnscaledDecimal128Arithmetic.isZero(decimal)) {
            return "0";
        }
        char[] buffer = new char[39];
        int index = buffer.length;
        boolean negative = UnscaledDecimal128Arithmetic.isNegative(decimal);
        decimal = UnscaledDecimal128Arithmetic.unscaledDecimal(decimal);
        do {
            int remainder = UnscaledDecimal128Arithmetic.divide(decimal, 10, decimal);
            buffer[--index] = (char)(48 + remainder);
        } while (!UnscaledDecimal128Arithmetic.isZero(decimal));
        if (negative) {
            buffer[--index] = 45;
        }
        return new String(buffer, index, buffer.length - index);
    }

    public static boolean overflows(Slice value, int precision) {
        if (precision == 38) {
            return UnscaledDecimal128Arithmetic.exceedsOrEqualTenToThirtyEight(value);
        }
        return precision < 38 && UnscaledDecimal128Arithmetic.compareAbsolute(value, POWERS_OF_TEN[precision]) >= 0;
    }

    public static void throwIfOverflows(Slice decimal) {
        if (UnscaledDecimal128Arithmetic.exceedsOrEqualTenToThirtyEight(decimal)) {
            UnscaledDecimal128Arithmetic.throwOverflowException();
        }
    }

    public static void throwIfOverflows(Slice value, int precision) {
        if (UnscaledDecimal128Arithmetic.overflows(value, precision)) {
            UnscaledDecimal128Arithmetic.throwOverflowException();
        }
    }

    private static void scaleDownRoundUp(Slice decimal, int scaleFactor, Slice result) {
        long low = UnscaledDecimal128Arithmetic.getLong(decimal, 0);
        long high = UnscaledDecimal128Arithmetic.getLong(decimal, 1);
        if (scaleFactor <= 18 && high == 0L && low >= 0L) {
            long divisor = Decimals.longTenToNth(scaleFactor);
            long newLow = low / divisor;
            if (low % divisor >= divisor >> 1) {
                ++newLow;
            }
            UnscaledDecimal128Arithmetic.pack(result, newLow, 0L, UnscaledDecimal128Arithmetic.isNegative(decimal));
            return;
        }
        if ((scaleFactor - 1) / 13 < (scaleFactor - 1) / 9) {
            UnscaledDecimal128Arithmetic.scaleDownFive(decimal, scaleFactor, result);
            UnscaledDecimal128Arithmetic.shiftRightRoundUp(result, scaleFactor, result);
        } else {
            UnscaledDecimal128Arithmetic.scaleDownTenRoundUp(decimal, scaleFactor, result);
        }
    }

    private static void scaleDownFive(Slice decimal, int fiveScale, Slice result) {
        int powerFive;
        do {
            powerFive = Math.min(fiveScale, 13);
            int divisor = POWERS_OF_FIVES_INT[powerFive];
            UnscaledDecimal128Arithmetic.divide(decimal, divisor, result);
            decimal = result;
        } while ((fiveScale -= powerFive) != 0);
    }

    private static void scaleDownTenRoundUp(Slice decimal, int tenScale, Slice result) {
        boolean round;
        int powerTen;
        do {
            powerTen = Math.min(tenScale, 9);
            int divisor = POWERS_OF_TEN_INT[powerTen];
            round = UnscaledDecimal128Arithmetic.divideCheckRound(decimal, divisor, result);
            decimal = result;
        } while ((tenScale -= powerTen) > 0);
        if (round) {
            UnscaledDecimal128Arithmetic.incrementUnsafe(decimal);
        }
    }

    private static void scaleDownTenTruncate(Slice decimal, int tenScale, Slice result) {
        int powerTen;
        do {
            powerTen = Math.min(tenScale, 9);
            int divisor = POWERS_OF_TEN_INT[powerTen];
            UnscaledDecimal128Arithmetic.divide(decimal, divisor, result);
            decimal = result;
        } while ((tenScale -= powerTen) > 0);
    }

    private static void shiftRightRoundUp(Slice decimal, int rightShifts, Slice result) {
        UnscaledDecimal128Arithmetic.shiftRight(decimal, rightShifts, true, result);
    }

    private static void shiftRightTruncate(Slice decimal, int rightShifts, Slice result) {
        UnscaledDecimal128Arithmetic.shiftRight(decimal, rightShifts, false, result);
    }

    static void shiftRight(Slice decimal, int rightShifts, boolean roundUp, Slice result) {
        long high;
        long low;
        if (rightShifts == 0) {
            UnscaledDecimal128Arithmetic.copyUnscaledDecimal(decimal, result);
            return;
        }
        int wordShifts = rightShifts / 64;
        int bitShiftsInWord = rightShifts % 64;
        int shiftRestore = 64 - bitShiftsInWord;
        boolean roundCarry = bitShiftsInWord == 0 ? roundUp && UnscaledDecimal128Arithmetic.getLong(decimal, wordShifts - 1) < 0L : roundUp && (UnscaledDecimal128Arithmetic.getLong(decimal, wordShifts) & 1L << bitShiftsInWord - 1) != 0L;
        boolean negative = UnscaledDecimal128Arithmetic.isNegative(decimal);
        switch (wordShifts) {
            case 0: {
                low = UnscaledDecimal128Arithmetic.getLong(decimal, 0);
                high = UnscaledDecimal128Arithmetic.getLong(decimal, 1);
                break;
            }
            case 1: {
                low = UnscaledDecimal128Arithmetic.getLong(decimal, 1);
                high = 0L;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (bitShiftsInWord > 0) {
            low = low >>> bitShiftsInWord | high << shiftRestore;
            high >>>= bitShiftsInWord;
        }
        if (roundCarry) {
            if (low != -1L) {
                ++low;
            } else {
                low = 0L;
                ++high;
            }
        }
        UnscaledDecimal128Arithmetic.pack(result, low, high, negative);
    }

    public static Slice divideRoundUp(long dividend, int dividendScaleFactor, long divisor) {
        return UnscaledDecimal128Arithmetic.divideRoundUp(Math.abs(dividend), dividend < 0L ? Long.MIN_VALUE : 0L, dividendScaleFactor, Math.abs(divisor), divisor < 0L ? Long.MIN_VALUE : 0L);
    }

    public static Slice divideRoundUp(long dividend, int dividendScaleFactor, Slice divisor) {
        return UnscaledDecimal128Arithmetic.divideRoundUp(Math.abs(dividend), dividend < 0L ? Long.MIN_VALUE : 0L, dividendScaleFactor, UnscaledDecimal128Arithmetic.getRawLong(divisor, 0), UnscaledDecimal128Arithmetic.getRawLong(divisor, 1));
    }

    public static Slice divideRoundUp(Slice dividend, int dividendScaleFactor, long divisor) {
        return UnscaledDecimal128Arithmetic.divideRoundUp(UnscaledDecimal128Arithmetic.getRawLong(dividend, 0), UnscaledDecimal128Arithmetic.getRawLong(dividend, 1), dividendScaleFactor, Math.abs(divisor), divisor < 0L ? Long.MIN_VALUE : 0L);
    }

    public static Slice divideRoundUp(Slice dividend, int dividendScaleFactor, Slice divisor) {
        return UnscaledDecimal128Arithmetic.divideRoundUp(UnscaledDecimal128Arithmetic.getRawLong(dividend, 0), UnscaledDecimal128Arithmetic.getRawLong(dividend, 1), dividendScaleFactor, UnscaledDecimal128Arithmetic.getRawLong(divisor, 0), UnscaledDecimal128Arithmetic.getRawLong(divisor, 1));
    }

    private static Slice divideRoundUp(long dividendLow, long dividendHigh, int dividendScaleFactor, long divisorLow, long divisorHigh) {
        Slice quotient = UnscaledDecimal128Arithmetic.unscaledDecimal();
        Slice remainder = UnscaledDecimal128Arithmetic.unscaledDecimal();
        UnscaledDecimal128Arithmetic.divide(dividendLow, dividendHigh, dividendScaleFactor, divisorLow, divisorHigh, 0, quotient, remainder);
        boolean quotientIsNegative = UnscaledDecimal128Arithmetic.isNegative(quotient);
        UnscaledDecimal128Arithmetic.setNegative(quotient, false);
        UnscaledDecimal128Arithmetic.setNegative(remainder, false);
        UnscaledDecimal128Arithmetic.shiftLeftDestructive(remainder, 1);
        long remainderLow = UnscaledDecimal128Arithmetic.getRawLong(remainder, 0);
        long remainderHigh = UnscaledDecimal128Arithmetic.getRawLong(remainder, 1);
        long divisorHighUnsigned = UnscaledDecimal128Arithmetic.unpackUnsignedLong(divisorHigh);
        if (UnscaledDecimal128Arithmetic.compareUnsigned(remainderLow, remainderHigh, divisorLow, divisorHighUnsigned) >= 0) {
            UnscaledDecimal128Arithmetic.incrementUnsafe(quotient);
            UnscaledDecimal128Arithmetic.throwIfOverflows(quotient);
        }
        UnscaledDecimal128Arithmetic.setNegative(quotient, quotientIsNegative);
        return quotient;
    }

    static Slice shiftLeft(Slice decimal, int leftShifts) {
        Slice result = Slices.copyOf((Slice)decimal);
        UnscaledDecimal128Arithmetic.shiftLeftDestructive(result, leftShifts);
        return result;
    }

    static void shiftLeftDestructive(Slice decimal, int leftShifts) {
        long high;
        long low;
        if (leftShifts == 0) {
            return;
        }
        int wordShifts = leftShifts / 64;
        int bitShiftsInWord = leftShifts % 64;
        int shiftRestore = 64 - bitShiftsInWord;
        if (bitShiftsInWord != 0 && (UnscaledDecimal128Arithmetic.getLong(decimal, 1 - wordShifts) & -1L << shiftRestore) != 0L) {
            UnscaledDecimal128Arithmetic.throwOverflowException();
        }
        if (wordShifts == 1 && UnscaledDecimal128Arithmetic.getLong(decimal, 1) != 0L) {
            UnscaledDecimal128Arithmetic.throwOverflowException();
        }
        boolean negative = UnscaledDecimal128Arithmetic.isNegative(decimal);
        switch (wordShifts) {
            case 0: {
                low = UnscaledDecimal128Arithmetic.getLong(decimal, 0);
                high = UnscaledDecimal128Arithmetic.getLong(decimal, 1);
                break;
            }
            case 1: {
                low = 0L;
                high = UnscaledDecimal128Arithmetic.getLong(decimal, 0);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (bitShiftsInWord > 0) {
            high = high << bitShiftsInWord | low >>> shiftRestore;
            low <<= bitShiftsInWord;
        }
        UnscaledDecimal128Arithmetic.pack(decimal, low, high, negative);
    }

    public static Slice remainder(long dividend, int dividendScaleFactor, long divisor, int divisorScaleFactor) {
        return UnscaledDecimal128Arithmetic.remainder(Math.abs(dividend), dividend < 0L ? Long.MIN_VALUE : 0L, dividendScaleFactor, Math.abs(divisor), divisor < 0L ? Long.MIN_VALUE : 0L, divisorScaleFactor);
    }

    public static Slice remainder(long dividend, int dividendScaleFactor, Slice divisor, int divisorScaleFactor) {
        return UnscaledDecimal128Arithmetic.remainder(Math.abs(dividend), dividend < 0L ? Long.MIN_VALUE : 0L, dividendScaleFactor, UnscaledDecimal128Arithmetic.getRawLong(divisor, 0), UnscaledDecimal128Arithmetic.getRawLong(divisor, 1), divisorScaleFactor);
    }

    public static Slice remainder(Slice dividend, int dividendScaleFactor, long divisor, int divisorScaleFactor) {
        return UnscaledDecimal128Arithmetic.remainder(UnscaledDecimal128Arithmetic.getRawLong(dividend, 0), UnscaledDecimal128Arithmetic.getRawLong(dividend, 1), dividendScaleFactor, Math.abs(divisor), divisor < 0L ? Long.MIN_VALUE : 0L, divisorScaleFactor);
    }

    public static Slice remainder(Slice dividend, int dividendScaleFactor, Slice divisor, int divisorScaleFactor) {
        return UnscaledDecimal128Arithmetic.remainder(UnscaledDecimal128Arithmetic.getRawLong(dividend, 0), UnscaledDecimal128Arithmetic.getRawLong(dividend, 1), dividendScaleFactor, UnscaledDecimal128Arithmetic.getRawLong(divisor, 0), UnscaledDecimal128Arithmetic.getRawLong(divisor, 1), divisorScaleFactor);
    }

    private static Slice remainder(long dividendLow, long dividendHigh, int dividendScaleFactor, long divisorLow, long divisorHigh, int divisorScaleFactor) {
        Slice quotient = UnscaledDecimal128Arithmetic.unscaledDecimal();
        Slice remainder = UnscaledDecimal128Arithmetic.unscaledDecimal();
        UnscaledDecimal128Arithmetic.divide(dividendLow, dividendHigh, dividendScaleFactor, divisorLow, divisorHigh, divisorScaleFactor, quotient, remainder);
        return remainder;
    }

    static void divide(Slice dividend, int dividendScaleFactor, Slice divisor, int divisorScaleFactor, Slice quotient, Slice remainder) {
        UnscaledDecimal128Arithmetic.divide(UnscaledDecimal128Arithmetic.getRawLong(dividend, 0), UnscaledDecimal128Arithmetic.getRawLong(dividend, 1), dividendScaleFactor, UnscaledDecimal128Arithmetic.getRawLong(divisor, 0), UnscaledDecimal128Arithmetic.getRawLong(divisor, 1), divisorScaleFactor, quotient, remainder);
    }

    private static void divide(long dividendLow, long dividendHigh, int dividendScaleFactor, long divisorLow, long divisorHigh, int divisorScaleFactor, Slice quotient, Slice remainder) {
        boolean divisorIsNegative;
        boolean dividendIsNegative;
        if (UnscaledDecimal128Arithmetic.compare(divisorLow, divisorHigh, 0L, 0L) == 0) {
            UnscaledDecimal128Arithmetic.throwDivisionByZeroException();
        }
        if (dividendScaleFactor >= 38) {
            UnscaledDecimal128Arithmetic.throwOverflowException();
        }
        if (divisorScaleFactor >= 38) {
            UnscaledDecimal128Arithmetic.throwOverflowException();
        }
        boolean quotientIsNegative = (dividendIsNegative = UnscaledDecimal128Arithmetic.isNegative(dividendHigh)) != (divisorIsNegative = UnscaledDecimal128Arithmetic.isNegative(divisorHigh));
        int[] dividend = new int[9];
        dividend[0] = UnscaledDecimal128Arithmetic.lowInt(dividendLow);
        dividend[1] = UnscaledDecimal128Arithmetic.highInt(dividendLow);
        dividend[2] = UnscaledDecimal128Arithmetic.lowInt(dividendHigh);
        dividend[3] = UnscaledDecimal128Arithmetic.highInt(dividendHigh) & Integer.MAX_VALUE;
        if (dividendScaleFactor > 0) {
            UnscaledDecimal128Arithmetic.shiftLeftBy5Destructive(dividend, dividendScaleFactor);
            UnscaledDecimal128Arithmetic.shiftLeftMultiPrecision(dividend, 8, dividendScaleFactor);
        }
        int[] divisor = new int[8];
        divisor[0] = UnscaledDecimal128Arithmetic.lowInt(divisorLow);
        divisor[1] = UnscaledDecimal128Arithmetic.highInt(divisorLow);
        divisor[2] = UnscaledDecimal128Arithmetic.lowInt(divisorHigh);
        divisor[3] = UnscaledDecimal128Arithmetic.highInt(divisorHigh) & Integer.MAX_VALUE;
        if (divisorScaleFactor > 0) {
            UnscaledDecimal128Arithmetic.shiftLeftBy5Destructive(divisor, divisorScaleFactor);
            UnscaledDecimal128Arithmetic.shiftLeftMultiPrecision(divisor, 8, divisorScaleFactor);
        }
        int[] multiPrecisionQuotient = new int[8];
        UnscaledDecimal128Arithmetic.divideUnsignedMultiPrecision(dividend, divisor, multiPrecisionQuotient);
        UnscaledDecimal128Arithmetic.packUnsigned(multiPrecisionQuotient, quotient);
        UnscaledDecimal128Arithmetic.packUnsigned(dividend, remainder);
        UnscaledDecimal128Arithmetic.setNegative(quotient, quotientIsNegative);
        UnscaledDecimal128Arithmetic.setNegative(remainder, dividendIsNegative);
        UnscaledDecimal128Arithmetic.throwIfOverflows(quotient);
        UnscaledDecimal128Arithmetic.throwIfOverflows(remainder);
    }

    private static void shiftLeftBy5Destructive(int[] value, int shift) {
        if (shift <= 13) {
            UnscaledDecimal128Arithmetic.multiply256Destructive(value, POWERS_OF_FIVES_INT[shift]);
        } else if (shift < 18) {
            UnscaledDecimal128Arithmetic.multiply256Destructive(value, POWERS_OF_FIVE_LONG[shift]);
        } else {
            UnscaledDecimal128Arithmetic.multiply256Destructive(value, POWERS_OF_FIVE[shift]);
        }
    }

    private static void divideUnsignedMultiPrecision(int[] dividend, int[] divisor, int[] quotient) {
        UnscaledDecimal128Arithmetic.checkArgument(dividend.length == 9);
        UnscaledDecimal128Arithmetic.checkArgument(divisor.length == 8);
        UnscaledDecimal128Arithmetic.checkArgument(quotient.length == 8);
        int divisorLength = UnscaledDecimal128Arithmetic.digitsInIntegerBase(divisor);
        int dividendLength = UnscaledDecimal128Arithmetic.digitsInIntegerBase(dividend);
        if (dividendLength < divisorLength) {
            return;
        }
        if (divisorLength == 1) {
            int remainder = UnscaledDecimal128Arithmetic.divideUnsignedMultiPrecision(dividend, dividendLength, divisor[0]);
            UnscaledDecimal128Arithmetic.checkState(dividend[dividend.length - 1] == 0);
            System.arraycopy(dividend, 0, quotient, 0, quotient.length);
            Arrays.fill(dividend, 0);
            dividend[0] = remainder;
            return;
        }
        int nlz = Integer.numberOfLeadingZeros(divisor[divisorLength - 1]);
        UnscaledDecimal128Arithmetic.shiftLeftMultiPrecision(divisor, divisorLength, nlz);
        int normalizedDividendLength = Math.min(dividend.length, dividendLength + 1);
        UnscaledDecimal128Arithmetic.shiftLeftMultiPrecision(dividend, normalizedDividendLength, nlz);
        UnscaledDecimal128Arithmetic.divideKnuthNormalized(dividend, normalizedDividendLength, divisor, divisorLength, quotient);
        UnscaledDecimal128Arithmetic.shiftRightMultiPrecision(dividend, normalizedDividendLength, nlz);
    }

    private static void divideKnuthNormalized(int[] remainder, int dividendLength, int[] divisor, int divisorLength, int[] quotient) {
        int v1 = divisor[divisorLength - 1];
        int v0 = divisor[divisorLength - 2];
        for (int reminderIndex = dividendLength - 1; reminderIndex >= divisorLength; --reminderIndex) {
            boolean overflow;
            int qHat = UnscaledDecimal128Arithmetic.estimateQuotient(remainder[reminderIndex], remainder[reminderIndex - 1], remainder[reminderIndex - 2], v1, v0);
            if (qHat != 0 && (overflow = UnscaledDecimal128Arithmetic.multiplyAndSubtractUnsignedMultiPrecision(remainder, reminderIndex, divisor, divisorLength, qHat))) {
                UnscaledDecimal128Arithmetic.addUnsignedMultiPrecision(remainder, reminderIndex, divisor, divisorLength);
            }
            quotient[reminderIndex - divisorLength] = --qHat;
        }
    }

    private static int estimateQuotient(int u2, int u1, int u0, int v1, int v0) {
        long u21 = UnscaledDecimal128Arithmetic.combineInts(u2, u1);
        long qhat = u2 == v1 ? 0xFFFFFFFFL : (u21 >= 0L ? u21 / Integer.toUnsignedLong(v1) : UnscaledDecimal128Arithmetic.divideUnsignedLong(u21, v1));
        if (qhat == 0L) {
            return 0;
        }
        int iterations = 0;
        long rhat = u21 - Integer.toUnsignedLong(v1) * qhat;
        while (Long.compareUnsigned(rhat, 0x100000000L) < 0 && Long.compareUnsigned(Integer.toUnsignedLong(v0) * qhat, UnscaledDecimal128Arithmetic.combineInts(UnscaledDecimal128Arithmetic.lowInt(rhat), u0)) > 0) {
            ++iterations;
            --qhat;
            rhat += Integer.toUnsignedLong(v1);
        }
        if (iterations > 2) {
            throw new IllegalStateException("qhat is greater than q by more than 2: " + iterations);
        }
        return (int)qhat;
    }

    private static long divideUnsignedLong(long dividend, int divisor) {
        long unsignedDivisor = Integer.toUnsignedLong(divisor);
        if (dividend > 0L) {
            return dividend / unsignedDivisor;
        }
        long quotient = (dividend >>> 1) / unsignedDivisor * 2L;
        long remainder = dividend - quotient * unsignedDivisor;
        if (Long.compareUnsigned(remainder, unsignedDivisor) >= 0) {
            ++quotient;
        }
        return quotient;
    }

    private static boolean multiplyAndSubtractUnsignedMultiPrecision(int[] left, int leftOffset, int[] right, int length, int multiplier) {
        long unsignedMultiplier = Integer.toUnsignedLong(multiplier);
        int leftIndex = leftOffset - length;
        long multiplyAccumulator = 0L;
        long subtractAccumulator = 0x100000000L;
        int rightIndex = 0;
        while (rightIndex < length) {
            multiplyAccumulator = Integer.toUnsignedLong(right[rightIndex]) * unsignedMultiplier + multiplyAccumulator;
            subtractAccumulator = subtractAccumulator + Integer.toUnsignedLong(left[leftIndex]) - Integer.toUnsignedLong(UnscaledDecimal128Arithmetic.lowInt(multiplyAccumulator));
            multiplyAccumulator = UnscaledDecimal128Arithmetic.high(multiplyAccumulator);
            left[leftIndex] = UnscaledDecimal128Arithmetic.lowInt(subtractAccumulator);
            subtractAccumulator = UnscaledDecimal128Arithmetic.high(subtractAccumulator) + 0x100000000L - 1L;
            ++rightIndex;
            ++leftIndex;
        }
        left[leftIndex] = UnscaledDecimal128Arithmetic.lowInt(subtractAccumulator += Integer.toUnsignedLong(left[leftIndex]) - multiplyAccumulator);
        return UnscaledDecimal128Arithmetic.highInt(subtractAccumulator) == 0;
    }

    private static void addUnsignedMultiPrecision(int[] left, int leftOffset, int[] right, int length) {
        int leftIndex = leftOffset - length;
        int carry = 0;
        int rightIndex = 0;
        while (rightIndex < length) {
            long accumulator = Integer.toUnsignedLong(left[leftIndex]) + Integer.toUnsignedLong(right[rightIndex]) + Integer.toUnsignedLong(carry);
            left[leftIndex] = UnscaledDecimal128Arithmetic.lowInt(accumulator);
            carry = UnscaledDecimal128Arithmetic.highInt(accumulator);
            ++rightIndex;
            ++leftIndex;
        }
        int n = leftIndex;
        left[n] = left[n] + carry;
    }

    static int[] shiftLeftMultiPrecision(int[] number, int length, int shifts) {
        int bitShifts;
        if (shifts == 0) {
            return number;
        }
        int wordShifts = shifts >>> 5;
        for (int i = 0; i < wordShifts; ++i) {
            UnscaledDecimal128Arithmetic.checkState(number[length - i - 1] == 0);
        }
        if (wordShifts > 0) {
            System.arraycopy(number, 0, number, wordShifts, length - wordShifts);
            Arrays.fill(number, 0, wordShifts, 0);
        }
        if ((bitShifts = shifts & 0x1F) > 0) {
            UnscaledDecimal128Arithmetic.checkState(number[length - 1] >>> 32 - bitShifts == 0);
            for (int position = length - 1; position > 0; --position) {
                number[position] = number[position] << bitShifts | number[position - 1] >>> 32 - bitShifts;
            }
            number[0] = number[0] << bitShifts;
        }
        return number;
    }

    static int[] shiftRightMultiPrecision(int[] number, int length, int shifts) {
        int bitShifts;
        if (shifts == 0) {
            return number;
        }
        int wordShifts = shifts >>> 5;
        for (int i = 0; i < wordShifts; ++i) {
            UnscaledDecimal128Arithmetic.checkState(number[i] == 0);
        }
        if (wordShifts > 0) {
            System.arraycopy(number, wordShifts, number, 0, length - wordShifts);
            Arrays.fill(number, length - wordShifts, length, 0);
        }
        if ((bitShifts = shifts & 0x1F) > 0) {
            UnscaledDecimal128Arithmetic.checkState(number[0] << 32 - bitShifts == 0);
            for (int position = 0; position < length - 1; ++position) {
                number[position] = number[position] >>> bitShifts | number[position + 1] << 32 - bitShifts;
            }
            number[length - 1] = number[length - 1] >>> bitShifts;
        }
        return number;
    }

    private static int divideUnsignedMultiPrecision(int[] dividend, int dividendLength, int divisor) {
        if (divisor == 0) {
            UnscaledDecimal128Arithmetic.throwDivisionByZeroException();
        }
        if (dividendLength == 1) {
            long dividendUnsigned = Integer.toUnsignedLong(dividend[0]);
            long divisorUnsigned = Integer.toUnsignedLong(divisor);
            long quotient = dividendUnsigned / divisorUnsigned;
            long remainder = dividendUnsigned - divisorUnsigned * quotient;
            dividend[0] = (int)quotient;
            return (int)remainder;
        }
        long divisorUnsigned = Integer.toUnsignedLong(divisor);
        long remainder = 0L;
        for (int dividendIndex = dividendLength - 1; dividendIndex >= 0; --dividendIndex) {
            remainder = (remainder << 32) + Integer.toUnsignedLong(dividend[dividendIndex]);
            long quotient = UnscaledDecimal128Arithmetic.divideUnsignedLong(remainder, divisor);
            dividend[dividendIndex] = (int)quotient;
            remainder -= quotient * divisorUnsigned;
        }
        return (int)remainder;
    }

    private static int digitsInIntegerBase(int[] digits) {
        int length;
        for (length = digits.length; length > 0 && digits[length - 1] == 0; --length) {
        }
        return length;
    }

    private static long combineInts(int high, int low) {
        return (long)high << 32 | Integer.toUnsignedLong(low);
    }

    private static long high(long value) {
        return value >>> 32;
    }

    private static long low(long value) {
        return value & 0xFFFFFFFFL;
    }

    private static int highInt(long val) {
        return (int)UnscaledDecimal128Arithmetic.high(val);
    }

    private static int lowInt(long val) {
        return (int)val;
    }

    private static void packUnsigned(int[] digits, Slice decimal) {
        if (UnscaledDecimal128Arithmetic.digitsInIntegerBase(digits) > 4) {
            UnscaledDecimal128Arithmetic.throwOverflowException();
        }
        if ((digits[3] & Integer.MIN_VALUE) != 0) {
            UnscaledDecimal128Arithmetic.throwOverflowException();
        }
        UnscaledDecimal128Arithmetic.pack(decimal, digits[0], digits[1], digits[2], digits[3], false);
    }

    private static boolean divideCheckRound(Slice decimal, int divisor, Slice result) {
        int remainder = UnscaledDecimal128Arithmetic.divide(decimal, divisor, result);
        return remainder >= divisor >> 1;
    }

    static int divide(Slice decimal, int divisor, Slice result) {
        if (divisor == 0) {
            UnscaledDecimal128Arithmetic.throwDivisionByZeroException();
        }
        UnscaledDecimal128Arithmetic.checkArgument(divisor > 0);
        long remainder = UnscaledDecimal128Arithmetic.getLong(decimal, 1);
        long high = remainder / (long)divisor;
        remainder %= (long)divisor;
        remainder = Integer.toUnsignedLong(UnscaledDecimal128Arithmetic.getInt(decimal, 1)) + (remainder << 32);
        int z1 = (int)(remainder / (long)divisor);
        remainder %= (long)divisor;
        remainder = Integer.toUnsignedLong(UnscaledDecimal128Arithmetic.getInt(decimal, 0)) + (remainder << 32);
        int z0 = (int)(remainder / (long)divisor);
        UnscaledDecimal128Arithmetic.pack(result, z0, z1, high, UnscaledDecimal128Arithmetic.isNegative(decimal));
        return (int)(remainder % (long)divisor);
    }

    private static void throwDivisionByZeroException() {
        throw new ArithmeticException("Division by zero");
    }

    private static void setNegative(Slice decimal, boolean negative) {
        UnscaledDecimal128Arithmetic.setRawInt(decimal, 3, UnscaledDecimal128Arithmetic.getInt(decimal, 3) | (negative ? Integer.MIN_VALUE : 0));
    }

    private static void setNegativeInt(Slice decimal, int v3, boolean negative) {
        if (v3 < 0) {
            UnscaledDecimal128Arithmetic.throwOverflowException();
        }
        UnscaledDecimal128Arithmetic.setRawInt(decimal, 3, v3 | (negative ? Integer.MIN_VALUE : 0));
    }

    private static void setNegativeLong(Slice decimal, long high, boolean negative) {
        UnscaledDecimal128Arithmetic.setRawLong(decimal, 1, high | (negative ? Long.MIN_VALUE : 0L));
    }

    private static void copyUnscaledDecimal(Slice from, Slice to) {
        UnscaledDecimal128Arithmetic.setRawLong(to, 0, UnscaledDecimal128Arithmetic.getRawLong(from, 0));
        UnscaledDecimal128Arithmetic.setRawLong(to, 1, UnscaledDecimal128Arithmetic.getRawLong(from, 1));
    }

    private static void pack(Slice decimal, int v0, int v1, int v2, int v3, boolean negative) {
        UnscaledDecimal128Arithmetic.setRawInt(decimal, 0, v0);
        UnscaledDecimal128Arithmetic.setRawInt(decimal, 1, v1);
        UnscaledDecimal128Arithmetic.setRawInt(decimal, 2, v2);
        UnscaledDecimal128Arithmetic.setNegativeInt(decimal, v3, negative);
    }

    private static void pack(Slice decimal, int v0, int v1, long high, boolean negative) {
        UnscaledDecimal128Arithmetic.setRawInt(decimal, 0, v0);
        UnscaledDecimal128Arithmetic.setRawInt(decimal, 1, v1);
        UnscaledDecimal128Arithmetic.setNegativeLong(decimal, high, negative);
    }

    private static void pack(Slice decimal, long low, long high, boolean negative) {
        UnscaledDecimal128Arithmetic.setRawLong(decimal, 0, low);
        UnscaledDecimal128Arithmetic.setNegativeLong(decimal, high, negative);
    }

    public static Slice pack(long low, long high, boolean negative) {
        Slice decimal = UnscaledDecimal128Arithmetic.unscaledDecimal();
        UnscaledDecimal128Arithmetic.pack(low, high, negative, decimal);
        return decimal;
    }

    public static void pack(long low, long high, boolean negative, Slice result) {
        UnscaledDecimal128Arithmetic.setRawLong(result, 0, low);
        UnscaledDecimal128Arithmetic.setRawLong(result, 1, high | (negative ? Long.MIN_VALUE : 0L));
    }

    public static void pack(long low, long high, boolean negative, Slice result, int resultOffset) {
        result.setLong(resultOffset, low);
        long value = high | (negative ? Long.MIN_VALUE : 0L);
        result.setLong(resultOffset + 8, value);
    }

    public static void pack(long low, long high, boolean negative, long[] result, int resultOffset) {
        long value;
        result[resultOffset] = low;
        result[resultOffset + 1] = value = high | (negative ? Long.MIN_VALUE : 0L);
    }

    public static void throwOverflowException() {
        throw new ArithmeticException("Decimal overflow");
    }

    public static int getInt(Slice decimal, int index) {
        int value = UnscaledDecimal128Arithmetic.getRawInt(decimal, index);
        if (index == 3) {
            value &= Integer.MAX_VALUE;
        }
        return value;
    }

    public static long getLong(Slice decimal, int index) {
        long value = UnscaledDecimal128Arithmetic.getRawLong(decimal, index);
        if (index == 1) {
            return UnscaledDecimal128Arithmetic.unpackUnsignedLong(value);
        }
        return value;
    }

    private static boolean exceedsOrEqualTenToThirtyEight(Slice decimal) {
        long high = UnscaledDecimal128Arithmetic.getLong(decimal, 1);
        if (high >= 0L && high < 5421010862427522170L) {
            return false;
        }
        if (high != 5421010862427522170L) {
            return true;
        }
        long low = UnscaledDecimal128Arithmetic.getLong(decimal, 0);
        return low < 0L || low >= 687399551400673280L;
    }

    private static void reverse(byte[] a) {
        int length = a.length;
        int i = length / 2;
        while (i-- != 0) {
            byte t = a[length - i - 1];
            a[length - i - 1] = a[i];
            a[i] = t;
        }
    }

    private static void setToZero(Slice decimal) {
        for (int i = 0; i < 2; ++i) {
            UnscaledDecimal128Arithmetic.setRawLong(decimal, i, 0L);
        }
    }

    private static int unpackUnsignedInt(int value) {
        return value & Integer.MAX_VALUE;
    }

    private static long unpackUnsignedInt(long value) {
        return value & Integer.MAX_VALUE;
    }

    private static long unpackUnsignedLong(long value) {
        return value & Long.MAX_VALUE;
    }

    private static int getRawInt(Slice decimal, int index) {
        return decimal.getInt(4 * index);
    }

    private static void setRawInt(Slice decimal, int index, int value) {
        decimal.setInt(4 * index, value);
    }

    private static long getRawLong(Slice decimal, int index) {
        return decimal.getLong(8 * index);
    }

    private static void setRawLong(Slice decimal, int index, long value) {
        decimal.setLong(8 * index, value);
    }

    private static boolean unsignedIsSmaller(long first, long second) {
        return first + Long.MIN_VALUE < second + Long.MIN_VALUE;
    }

    private static void checkArgument(boolean condition) {
        if (!condition) {
            throw new IllegalArgumentException();
        }
    }

    private static void checkState(boolean condition) {
        if (!condition) {
            throw new IllegalStateException();
        }
    }

    private UnscaledDecimal128Arithmetic() {
    }

    static {
        int i;
        POWERS_OF_TEN = new Slice[38];
        POWERS_OF_FIVE = new Slice[38];
        POWERS_OF_FIVES_INT = new int[14];
        POWERS_OF_FIVE_LONG = new long[28];
        POWERS_OF_TEN_INT = new int[10];
        for (i = 0; i < POWERS_OF_FIVE.length; ++i) {
            UnscaledDecimal128Arithmetic.POWERS_OF_FIVE[i] = UnscaledDecimal128Arithmetic.unscaledDecimal(BigInteger.valueOf(5L).pow(i));
        }
        for (i = 0; i < POWERS_OF_TEN.length; ++i) {
            UnscaledDecimal128Arithmetic.POWERS_OF_TEN[i] = UnscaledDecimal128Arithmetic.unscaledDecimal(BigInteger.TEN.pow(i));
        }
        UnscaledDecimal128Arithmetic.POWERS_OF_FIVES_INT[0] = 1;
        for (i = 1; i < POWERS_OF_FIVES_INT.length; ++i) {
            UnscaledDecimal128Arithmetic.POWERS_OF_FIVES_INT[i] = POWERS_OF_FIVES_INT[i - 1] * 5;
        }
        UnscaledDecimal128Arithmetic.POWERS_OF_FIVE_LONG[0] = 1L;
        for (i = 1; i < POWERS_OF_FIVE_LONG.length; ++i) {
            UnscaledDecimal128Arithmetic.POWERS_OF_FIVE_LONG[i] = POWERS_OF_FIVE_LONG[i - 1] * 5L;
        }
        UnscaledDecimal128Arithmetic.POWERS_OF_TEN_INT[0] = 1;
        for (i = 1; i < POWERS_OF_TEN_INT.length; ++i) {
            UnscaledDecimal128Arithmetic.POWERS_OF_TEN_INT[i] = POWERS_OF_TEN_INT[i - 1] * 10;
        }
        if (!ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN)) {
            throw new IllegalStateException("UnsignedDecimal128Arithmetic is supported on little-endian machines only");
        }
    }
}

