/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SizeOf;
import io.trino.spi.block.AbstractArrayBlock;
import io.trino.spi.block.Block;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class ArrayBlock
extends AbstractArrayBlock {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(ArrayBlock.class).instanceSize();
    private final int arrayOffset;
    private final int positionCount;
    private final boolean[] valueIsNull;
    private final Block values;
    private final int[] offsets;
    private volatile long sizeInBytes;
    private final long retainedSizeInBytes;

    public static Block fromElementBlock(int positionCount, Optional<boolean[]> valueIsNull, int[] arrayOffset, Block values) {
        ArrayBlock.validateConstructorArguments(0, positionCount, valueIsNull.orElse(null), arrayOffset, values);
        for (int i = 0; i < positionCount; ++i) {
            int offset = arrayOffset[i];
            int length = arrayOffset[i + 1] - offset;
            if (length < 0) {
                throw new IllegalArgumentException(String.format("Offset is not monotonically ascending. offsets[%s]=%s, offsets[%s]=%s", i, arrayOffset[i], i + 1, arrayOffset[i + 1]));
            }
            if (!valueIsNull.isPresent() || !valueIsNull.get()[i] || length == 0) continue;
            throw new IllegalArgumentException("A null array must have zero entries");
        }
        return new ArrayBlock(0, positionCount, valueIsNull.orElse(null), arrayOffset, values);
    }

    static ArrayBlock createArrayBlockInternal(int arrayOffset, int positionCount, @Nullable boolean[] valueIsNull, int[] offsets, Block values) {
        ArrayBlock.validateConstructorArguments(arrayOffset, positionCount, valueIsNull, offsets, values);
        return new ArrayBlock(arrayOffset, positionCount, valueIsNull, offsets, values);
    }

    private static void validateConstructorArguments(int arrayOffset, int positionCount, @Nullable boolean[] valueIsNull, int[] offsets, Block values) {
        if (arrayOffset < 0) {
            throw new IllegalArgumentException("arrayOffset is negative");
        }
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        if (valueIsNull != null && valueIsNull.length - arrayOffset < positionCount) {
            throw new IllegalArgumentException("isNull length is less than positionCount");
        }
        Objects.requireNonNull(offsets, "offsets is null");
        if (offsets.length - arrayOffset < positionCount + 1) {
            throw new IllegalArgumentException("offsets length is less than positionCount");
        }
        Objects.requireNonNull(values, "values is null");
    }

    private ArrayBlock(int arrayOffset, int positionCount, @Nullable boolean[] valueIsNull, int[] offsets, Block values) {
        this.arrayOffset = arrayOffset;
        this.positionCount = positionCount;
        this.valueIsNull = valueIsNull;
        this.offsets = offsets;
        this.values = Objects.requireNonNull(values);
        this.sizeInBytes = -1L;
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + SizeOf.sizeOf((int[])offsets) + SizeOf.sizeOf((boolean[])valueIsNull);
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getSizeInBytes() {
        if (this.sizeInBytes < 0L) {
            if (!this.values.isLoaded()) {
                return this.getBaseSizeInBytes();
            }
            this.calculateSize();
        }
        return this.sizeInBytes;
    }

    private void calculateSize() {
        int valueStart = this.offsets[this.arrayOffset];
        int valueEnd = this.offsets[this.arrayOffset + this.positionCount];
        this.sizeInBytes = this.values.getRegionSizeInBytes(valueStart, valueEnd - valueStart) + this.getBaseSizeInBytes();
    }

    private long getBaseSizeInBytes() {
        return 5L * (long)this.positionCount;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes + this.values.getRetainedSizeInBytes();
    }

    @Override
    public void retainedBytesForEachPart(BiConsumer<Object, Long> consumer) {
        consumer.accept(this.values, this.values.getRetainedSizeInBytes());
        consumer.accept(this.offsets, SizeOf.sizeOf((int[])this.offsets));
        consumer.accept(this.valueIsNull, SizeOf.sizeOf((boolean[])this.valueIsNull));
        consumer.accept(this, Long.valueOf(INSTANCE_SIZE));
    }

    @Override
    protected Block getRawElementBlock() {
        return this.values;
    }

    @Override
    protected int[] getOffsets() {
        return this.offsets;
    }

    @Override
    protected int getOffsetBase() {
        return this.arrayOffset;
    }

    @Override
    @Nullable
    protected boolean[] getValueIsNull() {
        return this.valueIsNull;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ArrayBlock{");
        sb.append("positionCount=").append(this.getPositionCount());
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean isLoaded() {
        return this.values.isLoaded();
    }

    @Override
    public Block getLoadedBlock() {
        Block loadedValuesBlock = this.values.getLoadedBlock();
        if (loadedValuesBlock == this.values) {
            return this;
        }
        return ArrayBlock.createArrayBlockInternal(this.arrayOffset, this.positionCount, this.valueIsNull, this.offsets, loadedValuesBlock);
    }
}

