/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.eventlistener;

import com.fasterxml.jackson.annotation.JsonCreator;
import io.trino.spi.eventlistener.ColumnDetail;
import java.util.Objects;
import java.util.Set;

public class OutputColumnMetadata {
    private final String columnName;
    private final Set<ColumnDetail> sourceColumns;

    @JsonCreator
    public OutputColumnMetadata(String columnName, Set<ColumnDetail> sourceColumns) {
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
        this.sourceColumns = Objects.requireNonNull(sourceColumns, "sourceColumns is null");
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Set<ColumnDetail> getSourceColumns() {
        return this.sourceColumns;
    }

    public int hashCode() {
        return Objects.hash(this.columnName, this.sourceColumns);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OutputColumnMetadata other = (OutputColumnMetadata)obj;
        return Objects.equals(this.columnName, other.columnName) && Objects.equals(this.sourceColumns, other.sourceColumns);
    }
}

