/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.airlift.slice.Slice;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.UnscaledDecimal128Arithmetic;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

public final class DecimalConversions {
    private static final double[] DOUBLE_10_POW = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22};
    private static final float[] FLOAT_10_POW = new float[]{1.0f, 10.0f, 100.0f, 1000.0f, 10000.0f, 100000.0f, 1000000.0f, 1.0E7f, 1.0E8f, 1.0E9f, 1.0E10f};
    private static final Slice MAX_EXACT_DOUBLE = UnscaledDecimal128Arithmetic.unscaledDecimal(0xFFFFFFFFFFFFFL);
    private static final Slice MAX_EXACT_FLOAT = UnscaledDecimal128Arithmetic.unscaledDecimal(0x3FFFFFL);

    private DecimalConversions() {
    }

    public static double shortDecimalToDouble(long decimal, long tenToScale) {
        return (double)decimal / (double)tenToScale;
    }

    public static double longDecimalToDouble(Slice decimal, long scale) {
        if (scale < (long)DOUBLE_10_POW.length && UnscaledDecimal128Arithmetic.compareAbsolute(decimal, MAX_EXACT_DOUBLE) <= 0) {
            return (double)UnscaledDecimal128Arithmetic.unscaledDecimalToUnscaledLongUnsafe(decimal) / DOUBLE_10_POW[DecimalConversions.intScale(scale)];
        }
        return Double.parseDouble(Decimals.toString(decimal, DecimalConversions.intScale(scale)));
    }

    public static long shortDecimalToReal(long decimal, long tenToScale) {
        return Float.floatToRawIntBits((float)decimal / (float)tenToScale);
    }

    public static long longDecimalToReal(Slice decimal, long scale) {
        if (scale < (long)FLOAT_10_POW.length && UnscaledDecimal128Arithmetic.compareAbsolute(decimal, MAX_EXACT_FLOAT) <= 0) {
            return Float.floatToRawIntBits((float)UnscaledDecimal128Arithmetic.unscaledDecimalToUnscaledLongUnsafe(decimal) / FLOAT_10_POW[DecimalConversions.intScale(scale)]);
        }
        return Float.floatToRawIntBits(Float.parseFloat(Decimals.toString(decimal, DecimalConversions.intScale(scale))));
    }

    public static long doubleToShortDecimal(double value, long precision, long scale) {
        Slice decimal = DecimalConversions.internalDoubleToLongDecimal(value, precision, scale);
        long low = UnscaledDecimal128Arithmetic.getLong(decimal, 0);
        long high = UnscaledDecimal128Arithmetic.getLong(decimal, 1);
        DecimalConversions.checkState(high == 0L && low >= 0L, "Unexpected long decimal");
        if (UnscaledDecimal128Arithmetic.isNegative(decimal)) {
            return -low;
        }
        return low;
    }

    public static Slice doubleToLongDecimal(double value, long precision, long scale) {
        return DecimalConversions.internalDoubleToLongDecimal(value, precision, scale);
    }

    private static Slice internalDoubleToLongDecimal(double value, long precision, long scale) {
        if (Double.isInfinite(value) || Double.isNaN(value)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast DOUBLE '%s' to DECIMAL(%s, %s)", value, precision, scale));
        }
        try {
            BigDecimal bigDecimal = BigDecimal.valueOf(value).setScale(DecimalConversions.intScale(scale), RoundingMode.HALF_UP);
            Slice decimal = Decimals.encodeScaledValue(bigDecimal);
            if (UnscaledDecimal128Arithmetic.overflows(decimal, DecimalConversions.intScale(precision))) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast DOUBLE '%s' to DECIMAL(%s, %s)", value, precision, scale));
            }
            return decimal;
        }
        catch (ArithmeticException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast DOUBLE '%s' to DECIMAL(%s, %s)", value, precision, scale));
        }
    }

    public static long realToShortDecimal(long value, long precision, long scale) {
        Slice decimal = DecimalConversions.realToLongDecimal(value, precision, scale);
        long low = UnscaledDecimal128Arithmetic.getLong(decimal, 0);
        long high = UnscaledDecimal128Arithmetic.getLong(decimal, 1);
        DecimalConversions.checkState(high == 0L && low >= 0L, "Unexpected long decimal");
        if (UnscaledDecimal128Arithmetic.isNegative(decimal)) {
            return -low;
        }
        return low;
    }

    public static Slice realToLongDecimal(long value, long precision, long scale) {
        float floatValue = Float.intBitsToFloat(DecimalConversions.intScale(value));
        if (Float.isInfinite(floatValue) || Float.isNaN(floatValue)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast REAL '%s' to DECIMAL(%s, %s)", Float.valueOf(floatValue), precision, scale));
        }
        try {
            BigDecimal bigDecimal = new BigDecimal(String.valueOf(floatValue)).setScale(DecimalConversions.intScale(scale), RoundingMode.HALF_UP);
            Slice decimal = Decimals.encodeScaledValue(bigDecimal);
            if (UnscaledDecimal128Arithmetic.overflows(decimal, DecimalConversions.intScale(precision))) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast REAL '%s' to DECIMAL(%s, %s)", Float.valueOf(floatValue), precision, scale));
            }
            return decimal;
        }
        catch (ArithmeticException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast REAL '%s' to DECIMAL(%s, %s)", Float.valueOf(floatValue), precision, scale));
        }
    }

    public static long shortToShortCast(long value, long sourcePrecision, long sourceScale, long resultPrecision, long resultScale, long scalingFactor, long halfOfScalingFactor) {
        long returnValue;
        if (resultScale >= sourceScale) {
            returnValue = value * scalingFactor;
        } else {
            returnValue = value / scalingFactor;
            if (value >= 0L) {
                if (value % scalingFactor >= halfOfScalingFactor) {
                    ++returnValue;
                }
            } else if (value % scalingFactor <= -halfOfScalingFactor) {
                --returnValue;
            }
        }
        if (Decimals.overflows(returnValue, (int)resultPrecision)) {
            throw DecimalConversions.throwCastException(value, sourcePrecision, sourceScale, resultPrecision, resultScale);
        }
        return returnValue;
    }

    public static Slice shortToLongCast(long value, long sourcePrecision, long sourceScale, long resultPrecision, long resultScale) {
        return DecimalConversions.longToLongCast(UnscaledDecimal128Arithmetic.unscaledDecimal(value), sourcePrecision, sourceScale, resultPrecision, resultScale);
    }

    public static long longToShortCast(Slice value, long sourcePrecision, long sourceScale, long resultPrecision, long resultScale) {
        return UnscaledDecimal128Arithmetic.unscaledDecimalToUnscaledLongUnsafe(DecimalConversions.longToLongCast(value, sourcePrecision, sourceScale, resultPrecision, resultScale));
    }

    public static Slice longToLongCast(Slice value, long sourcePrecision, long sourceScale, long resultPrecision, long resultScale) {
        if (sourcePrecision == resultPrecision && sourceScale == resultScale) {
            return value;
        }
        try {
            Slice result = UnscaledDecimal128Arithmetic.rescale(value, (int)(resultScale - sourceScale));
            if (UnscaledDecimal128Arithmetic.overflows(result, (int)resultPrecision)) {
                throw DecimalConversions.throwCastException(UnscaledDecimal128Arithmetic.unscaledDecimalToBigInteger(value), sourcePrecision, sourceScale, resultPrecision, resultScale);
            }
            return result;
        }
        catch (ArithmeticException e) {
            throw DecimalConversions.throwCastException(UnscaledDecimal128Arithmetic.unscaledDecimalToBigInteger(value), sourcePrecision, sourceScale, resultPrecision, resultScale);
        }
    }

    private static TrinoException throwCastException(long value, long sourcePrecision, long sourceScale, long resultPrecision, long resultScale) {
        return new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast DECIMAL(%d, %d) '%s' to DECIMAL(%d, %d)", sourcePrecision, sourceScale, Decimals.toString(value, (int)sourceScale), resultPrecision, resultScale));
    }

    private static TrinoException throwCastException(BigInteger value, long sourcePrecision, long sourceScale, long resultPrecision, long resultScale) {
        return new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast DECIMAL(%d, %d) '%s' to DECIMAL(%d, %d)", sourcePrecision, sourceScale, Decimals.toString(value, (int)sourceScale), resultPrecision, resultScale));
    }

    public static int intScale(long scale) {
        return (int)scale;
    }

    private static void checkState(boolean condition, String message) {
        if (!condition) {
            throw new IllegalStateException(message);
        }
    }
}

