/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SizeOf;
import io.trino.spi.block.AbstractRowBlock;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.block.BlockUtil;
import io.trino.spi.block.RowBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.SingleRowBlockWriter;
import io.trino.spi.type.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.ObjLongConsumer;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class RowBlockBuilder
extends AbstractRowBlock
implements BlockBuilder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(RowBlockBuilder.class).instanceSize();
    @Nullable
    private final BlockBuilderStatus blockBuilderStatus;
    private int positionCount;
    private int[] fieldBlockOffsets;
    private boolean[] rowIsNull;
    private final BlockBuilder[] fieldBlockBuilders;
    private final SingleRowBlockWriter singleRowBlockWriter;
    private boolean currentEntryOpened;
    private boolean hasNullRow;
    private boolean hasNonNullRow;

    public RowBlockBuilder(List<Type> fieldTypes, BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        this(blockBuilderStatus, RowBlockBuilder.createFieldBlockBuilders(fieldTypes, blockBuilderStatus, expectedEntries), new int[expectedEntries + 1], new boolean[expectedEntries]);
    }

    private RowBlockBuilder(@Nullable BlockBuilderStatus blockBuilderStatus, BlockBuilder[] fieldBlockBuilders, int[] fieldBlockOffsets, boolean[] rowIsNull) {
        super(fieldBlockBuilders.length);
        this.blockBuilderStatus = blockBuilderStatus;
        this.positionCount = 0;
        this.fieldBlockOffsets = Objects.requireNonNull(fieldBlockOffsets, "fieldBlockOffsets is null");
        this.rowIsNull = Objects.requireNonNull(rowIsNull, "rowIsNull is null");
        this.fieldBlockBuilders = Objects.requireNonNull(fieldBlockBuilders, "fieldBlockBuilders is null");
        this.singleRowBlockWriter = new SingleRowBlockWriter(fieldBlockBuilders);
    }

    private static BlockBuilder[] createFieldBlockBuilders(List<Type> fieldTypes, BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        BlockBuilder[] fieldBlockBuilders = new BlockBuilder[fieldTypes.size()];
        for (int i = 0; i < fieldTypes.size(); ++i) {
            fieldBlockBuilders[i] = fieldTypes.get(i).createBlockBuilder(blockBuilderStatus, expectedEntries);
        }
        return fieldBlockBuilders;
    }

    @Override
    protected Block[] getRawFieldBlocks() {
        return this.fieldBlockBuilders;
    }

    @Override
    @Nullable
    protected int[] getFieldBlockOffsets() {
        return this.hasNullRow ? this.fieldBlockOffsets : null;
    }

    @Override
    protected int getOffsetBase() {
        return 0;
    }

    @Override
    @Nullable
    protected boolean[] getRowIsNull() {
        return this.hasNullRow ? this.rowIsNull : null;
    }

    @Override
    public boolean mayHaveNull() {
        return this.hasNullRow;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getSizeInBytes() {
        long sizeInBytes = 5L * (long)this.positionCount;
        for (int i = 0; i < this.numFields; ++i) {
            sizeInBytes += this.fieldBlockBuilders[i].getSizeInBytes();
        }
        return sizeInBytes;
    }

    @Override
    public long getRetainedSizeInBytes() {
        long size = (long)INSTANCE_SIZE + SizeOf.sizeOf((int[])this.fieldBlockOffsets) + SizeOf.sizeOf((boolean[])this.rowIsNull);
        for (int i = 0; i < this.numFields; ++i) {
            size += this.fieldBlockBuilders[i].getRetainedSizeInBytes();
        }
        if (this.blockBuilderStatus != null) {
            size += (long)BlockBuilderStatus.INSTANCE_SIZE;
        }
        return size += (long)SingleRowBlockWriter.INSTANCE_SIZE;
    }

    @Override
    public void retainedBytesForEachPart(ObjLongConsumer<Object> consumer) {
        for (int i = 0; i < this.numFields; ++i) {
            consumer.accept(this.fieldBlockBuilders[i], this.fieldBlockBuilders[i].getRetainedSizeInBytes());
        }
        consumer.accept(this.fieldBlockOffsets, SizeOf.sizeOf((int[])this.fieldBlockOffsets));
        consumer.accept(this.rowIsNull, SizeOf.sizeOf((boolean[])this.rowIsNull));
        consumer.accept(this, INSTANCE_SIZE);
    }

    @Override
    public SingleRowBlockWriter beginBlockEntry() {
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Expected current entry to be closed but was opened");
        }
        this.currentEntryOpened = true;
        this.singleRowBlockWriter.setRowIndex(this.fieldBlockBuilders[0].getPositionCount());
        return this.singleRowBlockWriter;
    }

    @Override
    public BlockBuilder closeEntry() {
        if (!this.currentEntryOpened) {
            throw new IllegalStateException("Expected entry to be opened but was closed");
        }
        this.entryAdded(false);
        this.currentEntryOpened = false;
        this.singleRowBlockWriter.reset();
        return this;
    }

    @Override
    public BlockBuilder appendNull() {
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Current entry must be closed before a null can be written");
        }
        this.entryAdded(true);
        return this;
    }

    private void entryAdded(boolean isNull) {
        if (this.rowIsNull.length <= this.positionCount) {
            int newSize = BlockUtil.calculateNewArraySize(this.rowIsNull.length);
            this.rowIsNull = Arrays.copyOf(this.rowIsNull, newSize);
            this.fieldBlockOffsets = Arrays.copyOf(this.fieldBlockOffsets, newSize + 1);
        }
        this.fieldBlockOffsets[this.positionCount + 1] = isNull ? this.fieldBlockOffsets[this.positionCount] : this.fieldBlockOffsets[this.positionCount] + 1;
        this.rowIsNull[this.positionCount] = isNull;
        this.hasNullRow |= isNull;
        this.hasNonNullRow |= !isNull;
        ++this.positionCount;
        for (int i = 0; i < this.numFields; ++i) {
            if (this.fieldBlockBuilders[i].getPositionCount() == this.fieldBlockOffsets[this.positionCount]) continue;
            throw new IllegalStateException(String.format("field %s has unexpected position count. Expected: %s, actual: %s", i, this.fieldBlockOffsets[this.positionCount], this.fieldBlockBuilders[i].getPositionCount()));
        }
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(5);
        }
    }

    @Override
    public Block build() {
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Current entry must be closed before the block can be built");
        }
        if (!this.hasNonNullRow) {
            return this.nullRle(this.positionCount);
        }
        Block[] fieldBlocks = new Block[this.numFields];
        for (int i = 0; i < this.numFields; ++i) {
            fieldBlocks[i] = this.fieldBlockBuilders[i].build();
        }
        return RowBlock.createRowBlockInternal(0, this.positionCount, this.hasNullRow ? this.rowIsNull : null, this.hasNullRow ? this.fieldBlockOffsets : null, fieldBlocks);
    }

    public String toString() {
        return String.format("RowBlockBuilder{numFields=%d, positionCount=%d", this.numFields, this.getPositionCount());
    }

    @Override
    public BlockBuilder newBlockBuilderLike(BlockBuilderStatus blockBuilderStatus) {
        int newSize = BlockUtil.calculateBlockResetSize(this.getPositionCount());
        BlockBuilder[] newBlockBuilders = new BlockBuilder[this.numFields];
        for (int i = 0; i < this.numFields; ++i) {
            newBlockBuilders[i] = this.fieldBlockBuilders[i].newBlockBuilderLike(blockBuilderStatus);
        }
        return new RowBlockBuilder(blockBuilderStatus, newBlockBuilders, new int[newSize + 1], new boolean[newSize]);
    }

    @Override
    public Block copyPositions(int[] positions, int offset, int length) {
        BlockUtil.checkArrayRange(positions, offset, length);
        if (!this.hasNonNullRow) {
            return this.nullRle(length);
        }
        return super.copyPositions(positions, offset, length);
    }

    @Override
    public Block getRegion(int position, int length) {
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidRegion(positionCount, position, length);
        if (!this.hasNonNullRow) {
            return this.nullRle(length);
        }
        return super.getRegion(position, length);
    }

    @Override
    public Block copyRegion(int position, int length) {
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidRegion(positionCount, position, length);
        if (!this.hasNonNullRow) {
            return this.nullRle(length);
        }
        return super.copyRegion(position, length);
    }

    private RunLengthEncodedBlock nullRle(int length) {
        Block[] fieldBlocks = new Block[this.numFields];
        for (int i = 0; i < this.numFields; ++i) {
            fieldBlocks[i] = this.fieldBlockBuilders[i].newBlockBuilderLike(null).build();
        }
        RowBlock nullRowBlock = RowBlock.createRowBlockInternal(0, 1, new boolean[]{true}, new int[]{0, 0}, fieldBlocks);
        return new RunLengthEncodedBlock(nullRowBlock, length);
    }
}

