/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.ptf;

import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.ptf.Argument;
import io.trino.spi.ptf.ArgumentSpecification;
import io.trino.spi.ptf.ReturnTypeSpecification;
import io.trino.spi.ptf.TableArgumentSpecification;
import io.trino.spi.ptf.TableFunctionAnalysis;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class ConnectorTableFunction {
    private final String schema;
    private final String name;
    private final List<ArgumentSpecification> arguments;
    private final ReturnTypeSpecification returnTypeSpecification;

    public ConnectorTableFunction(String schema, String name, List<ArgumentSpecification> arguments, ReturnTypeSpecification returnTypeSpecification) {
        this.schema = ConnectorTableFunction.checkNotNullOrEmpty(schema, "schema");
        this.name = ConnectorTableFunction.checkNotNullOrEmpty(name, "name");
        Objects.requireNonNull(arguments, "arguments is null");
        HashSet<String> argumentNames = new HashSet<String>();
        for (ArgumentSpecification specification2 : arguments) {
            if (argumentNames.add(specification2.getName())) continue;
            throw new IllegalArgumentException("duplicate argument name: " + specification2.getName());
        }
        long tableArgumentsWithRowSemantics = arguments.stream().filter(specification -> specification instanceof TableArgumentSpecification).map(TableArgumentSpecification.class::cast).filter(TableArgumentSpecification::isRowSemantics).count();
        ConnectorTableFunction.checkArgument(tableArgumentsWithRowSemantics <= 1L, "more than one table argument with row semantics");
        this.arguments = List.copyOf(arguments);
        this.returnTypeSpecification = Objects.requireNonNull(returnTypeSpecification, "returnTypeSpecification is null");
    }

    public String getSchema() {
        return this.schema;
    }

    public String getName() {
        return this.name;
    }

    public List<ArgumentSpecification> getArguments() {
        return this.arguments;
    }

    public ReturnTypeSpecification getReturnTypeSpecification() {
        return this.returnTypeSpecification;
    }

    public abstract TableFunctionAnalysis analyze(ConnectorSession var1, ConnectorTransactionHandle var2, Map<String, Argument> var3);

    static String checkNotNullOrEmpty(String value, String name) {
        Objects.requireNonNull(value, name + " is null");
        ConnectorTableFunction.checkArgument(!value.isEmpty(), name + " is empty");
        return value;
    }

    static void checkArgument(boolean assertion, String message) {
        if (!assertion) {
            throw new IllegalArgumentException(message);
        }
    }
}

