/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.ptf;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.spi.ptf.ConnectorTableFunction;
import io.trino.spi.type.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class Descriptor {
    private final List<Field> fields;

    @JsonCreator
    public Descriptor(@JsonProperty(value="fields") List<Field> fields) {
        Objects.requireNonNull(fields, "fields is null");
        ConnectorTableFunction.checkArgument(!fields.isEmpty(), "descriptor has no fields");
        this.fields = List.copyOf(fields);
    }

    public static Descriptor descriptor(String ... names) {
        List<Field> fields = Arrays.stream(names).map(name -> new Field((String)name, Optional.empty())).collect(Collectors.toList());
        return new Descriptor(fields);
    }

    public static Descriptor descriptor(List<String> names, List<Type> types) {
        Objects.requireNonNull(names, "names is null");
        Objects.requireNonNull(types, "types is null");
        ConnectorTableFunction.checkArgument(names.size() == types.size(), "names and types lists do not match");
        ArrayList<Field> fields = new ArrayList<Field>();
        for (int i = 0; i < names.size(); ++i) {
            fields.add(new Field(names.get(i), Optional.of(types.get(i))));
        }
        return new Descriptor(fields);
    }

    @JsonProperty
    public List<Field> getFields() {
        return this.fields;
    }

    public boolean isTyped() {
        return this.fields.stream().allMatch(field -> field.type.isPresent());
    }

    public static class Field {
        private final String name;
        private final Optional<Type> type;

        @JsonCreator
        public Field(@JsonProperty(value="name") String name, @JsonProperty(value="type") Optional<Type> type) {
            this.name = ConnectorTableFunction.checkNotNullOrEmpty(name, "name");
            this.type = Objects.requireNonNull(type, "type is null");
        }

        @JsonProperty
        public String getName() {
            return this.name;
        }

        @JsonProperty
        public Optional<Type> getType() {
            return this.type;
        }
    }
}

