/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.ptf;

import io.trino.spi.ptf.ConnectorTableFunction;
import java.util.Objects;

public class NameAndPosition {
    private final String name;
    private final int position;

    public NameAndPosition(String name, int position) {
        this.name = ConnectorTableFunction.checkNotNullOrEmpty(name, "name");
        ConnectorTableFunction.checkArgument(position >= 0, "position in descriptor must not be negative");
        this.position = position;
    }

    public String getName() {
        return this.name;
    }

    public int getPosition() {
        return this.position;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NameAndPosition that = (NameAndPosition)o;
        return this.position == that.position && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.position);
    }
}

