/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.ptf;

import io.trino.spi.ptf.ConnectorTableFunction;
import io.trino.spi.ptf.ConnectorTableFunctionHandle;
import io.trino.spi.ptf.Descriptor;
import io.trino.spi.ptf.DescriptorMapping;
import java.util.Objects;
import java.util.Optional;

public final class TableFunctionAnalysis {
    private final Optional<Descriptor> returnedType;
    private final DescriptorMapping descriptorMapping;
    private final ConnectorTableFunctionHandle handle;

    private TableFunctionAnalysis(Optional<Descriptor> returnedType, DescriptorMapping descriptorMapping, ConnectorTableFunctionHandle handle) {
        this.returnedType = Objects.requireNonNull(returnedType, "returnedType is null");
        returnedType.ifPresent(descriptor -> ConnectorTableFunction.checkArgument(descriptor.isTyped(), "field types not specified"));
        this.descriptorMapping = Objects.requireNonNull(descriptorMapping, "descriptorMapping is null");
        this.handle = Objects.requireNonNull(handle, "handle is null");
    }

    public Optional<Descriptor> getReturnedType() {
        return this.returnedType;
    }

    public DescriptorMapping getDescriptorMapping() {
        return this.descriptorMapping;
    }

    public ConnectorTableFunctionHandle getHandle() {
        return this.handle;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Descriptor returnedType;
        private DescriptorMapping descriptorMapping = DescriptorMapping.EMPTY_MAPPING;
        private ConnectorTableFunctionHandle handle = new ConnectorTableFunctionHandle(){};

        private Builder() {
        }

        public Builder returnedType(Descriptor returnedType) {
            this.returnedType = returnedType;
            return this;
        }

        public Builder descriptorMapping(DescriptorMapping descriptorMapping) {
            this.descriptorMapping = descriptorMapping;
            return this;
        }

        public Builder handle(ConnectorTableFunctionHandle handle) {
            this.handle = handle;
            return this;
        }

        public TableFunctionAnalysis build() {
            return new TableFunctionAnalysis(Optional.ofNullable(this.returnedType), this.descriptorMapping, this.handle);
        }
    }
}

