/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.trino.spi.block.Block;
import io.trino.spi.block.BlockUtil;
import io.trino.spi.block.RowBlock;
import io.trino.spi.block.SingleRowBlock;
import java.util.List;
import java.util.OptionalInt;
import javax.annotation.Nullable;

public abstract class AbstractRowBlock
implements Block {
    protected final int numFields;

    @Override
    public final List<Block> getChildren() {
        return List.of(this.getRawFieldBlocks());
    }

    protected abstract Block[] getRawFieldBlocks();

    @Nullable
    protected abstract int[] getFieldBlockOffsets();

    protected abstract int getOffsetBase();

    @Nullable
    protected abstract boolean[] getRowIsNull();

    protected final int getFieldBlockOffset(int position) {
        int[] offsets = this.getFieldBlockOffsets();
        return offsets != null ? offsets[position + this.getOffsetBase()] : position + this.getOffsetBase();
    }

    protected AbstractRowBlock(int numFields) {
        if (numFields <= 0) {
            throw new IllegalArgumentException("Number of fields in RowBlock must be positive");
        }
        this.numFields = numFields;
    }

    @Override
    public String getEncodingName() {
        return "ROW";
    }

    @Override
    public Block copyPositions(int[] positions, int offset, int length) {
        int fieldBlockPositionCount;
        int position;
        int i;
        boolean[] newRowIsNull;
        BlockUtil.checkArrayRange(positions, offset, length);
        int[] newOffsets = null;
        int[] fieldBlockPositions = new int[length];
        if (this.getRowIsNull() == null) {
            newRowIsNull = null;
            for (i = 0; i < fieldBlockPositions.length; ++i) {
                position = positions[offset + i];
                this.checkReadablePosition(position);
                fieldBlockPositions[i] = this.getFieldBlockOffset(position);
            }
            fieldBlockPositionCount = fieldBlockPositions.length;
        } else {
            newRowIsNull = new boolean[length];
            newOffsets = new int[length + 1];
            fieldBlockPositionCount = 0;
            for (i = 0; i < length; ++i) {
                newOffsets[i] = fieldBlockPositionCount;
                position = positions[offset + i];
                if (this.isNull(position)) {
                    newRowIsNull[i] = true;
                    continue;
                }
                fieldBlockPositions[fieldBlockPositionCount++] = this.getFieldBlockOffset(position);
            }
            newOffsets[length] = fieldBlockPositionCount;
            if (fieldBlockPositionCount == length) {
                newRowIsNull = null;
                newOffsets = null;
            }
        }
        Block[] newBlocks = new Block[this.numFields];
        Block[] rawBlocks = this.getRawFieldBlocks();
        for (int i2 = 0; i2 < newBlocks.length; ++i2) {
            newBlocks[i2] = rawBlocks[i2].copyPositions(fieldBlockPositions, 0, fieldBlockPositionCount);
        }
        return RowBlock.createRowBlockInternal(0, length, newRowIsNull, newOffsets, newBlocks);
    }

    @Override
    public Block getRegion(int position, int length) {
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidRegion(positionCount, position, length);
        return RowBlock.createRowBlockInternal(position + this.getOffsetBase(), length, this.getRowIsNull(), this.getFieldBlockOffsets(), this.getRawFieldBlocks());
    }

    @Override
    public final OptionalInt fixedSizeInBytesPerPosition() {
        OptionalInt fieldSize;
        if (!this.mayHaveNull() && (fieldSize = this.fixedSizeInBytesPerFieldPosition()).isPresent()) {
            return OptionalInt.of(fieldSize.getAsInt() + 5);
        }
        return OptionalInt.empty();
    }

    private OptionalInt fixedSizeInBytesPerFieldPosition() {
        Block[] rawFieldBlocks = this.getRawFieldBlocks();
        int fixedSizePerRow = 0;
        for (int i = 0; i < this.numFields; ++i) {
            OptionalInt fieldFixedSize = rawFieldBlocks[i].fixedSizeInBytesPerPosition();
            if (fieldFixedSize.isEmpty()) {
                return OptionalInt.empty();
            }
            fixedSizePerRow += fieldFixedSize.getAsInt();
        }
        return OptionalInt.of(fixedSizePerRow);
    }

    @Override
    public long getRegionSizeInBytes(int position, int length) {
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidRegion(positionCount, position, length);
        int startFieldBlockOffset = this.getFieldBlockOffset(position);
        int endFieldBlockOffset = this.getFieldBlockOffset(position + length);
        int fieldBlockLength = endFieldBlockOffset - startFieldBlockOffset;
        long regionSizeInBytes = 5L * (long)length;
        for (int i = 0; i < this.numFields; ++i) {
            regionSizeInBytes += this.getRawFieldBlocks()[i].getRegionSizeInBytes(startFieldBlockOffset, fieldBlockLength);
        }
        return regionSizeInBytes;
    }

    @Override
    public final long getPositionsSizeInBytes(boolean[] positions, int selectedRowPositions) {
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidPositions(positions, positionCount);
        if (selectedRowPositions == 0) {
            return 0L;
        }
        if (selectedRowPositions == positionCount) {
            return this.getSizeInBytes();
        }
        OptionalInt fixedSizePerFieldPosition = this.fixedSizeInBytesPerFieldPosition();
        if (fixedSizePerFieldPosition.isPresent()) {
            int selectedFieldPositionCount = selectedRowPositions;
            boolean[] rowIsNull = this.getRowIsNull();
            if (rowIsNull != null) {
                int offsetBase = this.getOffsetBase();
                for (int i = 0; i < positions.length; ++i) {
                    if (!positions[i] || !rowIsNull[i + offsetBase]) continue;
                    --selectedFieldPositionCount;
                }
                if (selectedFieldPositionCount < 0) {
                    throw new IllegalStateException("Invalid field position selection after nulls removed: " + selectedFieldPositionCount);
                }
            }
            return 5L * (long)selectedRowPositions + (long)fixedSizePerFieldPosition.getAsInt() * (long)selectedFieldPositionCount;
        }
        return this.getSpecificPositionsSizeInBytes(positions, selectedRowPositions);
    }

    private long getSpecificPositionsSizeInBytes(boolean[] positions, int selectedRowPositions) {
        boolean[] fieldPositions;
        int selectedFieldPositionCount;
        int positionCount = this.getPositionCount();
        int offsetBase = this.getOffsetBase();
        boolean[] rowIsNull = this.getRowIsNull();
        int totalFieldPositions = this.getRawFieldBlocks()[0].getPositionCount();
        if (rowIsNull == null) {
            selectedFieldPositionCount = selectedRowPositions;
            if (offsetBase == 0 && positionCount == totalFieldPositions) {
                fieldPositions = positions;
            } else {
                fieldPositions = new boolean[totalFieldPositions];
                System.arraycopy(positions, 0, fieldPositions, offsetBase, positions.length);
            }
        } else {
            fieldPositions = new boolean[totalFieldPositions];
            selectedFieldPositionCount = 0;
            for (int i = 0; i < positions.length; ++i) {
                if (!positions[i] || rowIsNull[offsetBase + i]) continue;
                ++selectedFieldPositionCount;
                fieldPositions[this.getFieldBlockOffset((int)i)] = true;
            }
        }
        Block[] rawFieldBlocks = this.getRawFieldBlocks();
        long sizeInBytes = 5L * (long)selectedRowPositions;
        for (int j = 0; j < this.numFields; ++j) {
            sizeInBytes += rawFieldBlocks[j].getPositionsSizeInBytes(fieldPositions, selectedFieldPositionCount);
        }
        return sizeInBytes;
    }

    @Override
    public Block copyRegion(int position, int length) {
        boolean[] newRowIsNull;
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidRegion(positionCount, position, length);
        int startFieldBlockOffset = this.getFieldBlockOffset(position);
        int endFieldBlockOffset = this.getFieldBlockOffset(position + length);
        int fieldBlockLength = endFieldBlockOffset - startFieldBlockOffset;
        Object[] newBlocks = new Block[this.numFields];
        for (int i = 0; i < this.numFields; ++i) {
            newBlocks[i] = this.getRawFieldBlocks()[i].copyRegion(startFieldBlockOffset, fieldBlockLength);
        }
        int[] fieldBlockOffsets = this.getFieldBlockOffsets();
        int[] newOffsets = fieldBlockOffsets == null ? null : BlockUtil.compactOffsets(fieldBlockOffsets, position + this.getOffsetBase(), length);
        boolean[] rowIsNull = this.getRowIsNull();
        boolean[] blArray = newRowIsNull = rowIsNull == null ? null : BlockUtil.compactArray(rowIsNull, position + this.getOffsetBase(), length);
        if (BlockUtil.arraySame(newBlocks, this.getRawFieldBlocks()) && newOffsets == fieldBlockOffsets && newRowIsNull == rowIsNull) {
            return this;
        }
        return RowBlock.createRowBlockInternal(0, length, newRowIsNull, newOffsets, (Block[])newBlocks);
    }

    @Override
    public <T> T getObject(int position, Class<T> clazz) {
        if (clazz != Block.class) {
            throw new IllegalArgumentException("clazz must be Block.class");
        }
        this.checkReadablePosition(position);
        return clazz.cast(new SingleRowBlock(this.getFieldBlockOffset(position), this.getRawFieldBlocks()));
    }

    @Override
    public Block getSingleValueBlock(int position) {
        int[] nArray;
        boolean[] newRowIsNull;
        boolean[] blArray;
        this.checkReadablePosition(position);
        int startFieldBlockOffset = this.getFieldBlockOffset(position);
        int endFieldBlockOffset = this.getFieldBlockOffset(position + 1);
        int fieldBlockLength = endFieldBlockOffset - startFieldBlockOffset;
        Block[] newBlocks = new Block[this.numFields];
        for (int i = 0; i < this.numFields; ++i) {
            newBlocks[i] = this.getRawFieldBlocks()[i].copyRegion(startFieldBlockOffset, fieldBlockLength);
        }
        if (this.isNull(position)) {
            boolean[] blArray2 = new boolean[1];
            blArray = blArray2;
            blArray2[0] = true;
        } else {
            blArray = newRowIsNull = null;
        }
        if (this.isNull(position)) {
            int[] nArray2 = new int[2];
            nArray2[0] = 0;
            nArray = nArray2;
            nArray2[1] = fieldBlockLength;
        } else {
            nArray = null;
        }
        int[] newOffsets = nArray;
        return RowBlock.createRowBlockInternal(0, 1, newRowIsNull, newOffsets, newBlocks);
    }

    @Override
    public long getEstimatedDataSizeForStats(int position) {
        this.checkReadablePosition(position);
        if (this.isNull(position)) {
            return 0L;
        }
        Block[] rawFieldBlocks = this.getRawFieldBlocks();
        long size = 0L;
        for (int i = 0; i < this.numFields; ++i) {
            size += rawFieldBlocks[i].getEstimatedDataSizeForStats(this.getFieldBlockOffset(position));
        }
        return size;
    }

    @Override
    public boolean isNull(int position) {
        this.checkReadablePosition(position);
        boolean[] rowIsNull = this.getRowIsNull();
        return rowIsNull != null && rowIsNull[position + this.getOffsetBase()];
    }

    private void checkReadablePosition(int position) {
        if (position < 0 || position >= this.getPositionCount()) {
            throw new IllegalArgumentException("position is not valid");
        }
    }
}

