/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.trino.spi.type.ParametricType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeParameter;
import java.util.List;

public class TimeParametricType
implements ParametricType {
    public static final TimeParametricType TIME = new TimeParametricType();

    @Override
    public String getName() {
        return "time";
    }

    @Override
    public Type createType(TypeManager typeManager, List<TypeParameter> parameters) {
        if (parameters.isEmpty()) {
            return TimeType.TIME;
        }
        if (parameters.size() != 1) {
            throw new IllegalArgumentException("Expected exactly one parameter for TIME");
        }
        TypeParameter parameter = parameters.get(0);
        if (!parameter.isLongLiteral()) {
            throw new IllegalArgumentException("TIME precision must be a number");
        }
        long precision = parameter.getLongLiteral();
        if (precision < 0L || precision > 12L) {
            throw new IllegalArgumentException("Invalid TIME precision " + precision);
        }
        return TimeType.createTimeType((int)precision);
    }
}

