/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.ptf;

import io.trino.spi.ptf.ArgumentSpecification;

public class TableArgumentSpecification
extends ArgumentSpecification {
    private final boolean rowSemantics;
    private final boolean pruneWhenEmpty;
    private final boolean passThroughColumns;

    private TableArgumentSpecification(String name, boolean rowSemantics, boolean pruneWhenEmpty, boolean passThroughColumns) {
        super(name, true, null);
        this.rowSemantics = rowSemantics;
        this.pruneWhenEmpty = pruneWhenEmpty;
        this.passThroughColumns = passThroughColumns;
    }

    public boolean isRowSemantics() {
        return this.rowSemantics;
    }

    public boolean isPruneWhenEmpty() {
        return this.pruneWhenEmpty;
    }

    public boolean isPassThroughColumns() {
        return this.passThroughColumns;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private boolean rowSemantics;
        private boolean pruneWhenEmpty;
        private boolean passThroughColumns;

        private Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder rowSemantics() {
            this.rowSemantics = true;
            return this;
        }

        public Builder pruneWhenEmpty() {
            this.pruneWhenEmpty = true;
            return this;
        }

        public Builder passThroughColumns() {
            this.passThroughColumns = true;
            return this;
        }

        public TableArgumentSpecification build() {
            return new TableArgumentSpecification(this.name, this.rowSemantics, this.pruneWhenEmpty, this.passThroughColumns);
        }
    }
}

