/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.ptf;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.spi.ptf.Argument;
import io.trino.spi.ptf.Preconditions;
import io.trino.spi.type.RowType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class TableArgument
extends Argument {
    private final Optional<QualifiedName> name;
    private final RowType rowType;
    private final List<String> partitionBy;
    private final List<SortItem> orderBy;
    private final boolean rowSemantics;
    private final boolean pruneWhenEmpty;
    private final boolean passThroughColumns;

    @JsonCreator
    public TableArgument(@JsonProperty(value="name") Optional<QualifiedName> name, @JsonProperty(value="rowType") RowType rowType, @JsonProperty(value="partitionBy") List<String> partitionBy, @JsonProperty(value="orderBy") List<SortItem> orderBy, @JsonProperty(value="rowSemantics") boolean rowSemantics, @JsonProperty(value="pruneWhenEmpty") boolean pruneWhenEmpty, @JsonProperty(value="passThroughColumns") boolean passThroughColumns) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.rowType = Objects.requireNonNull(rowType, "rowType is null");
        this.partitionBy = Objects.requireNonNull(partitionBy, "partitionBy is null");
        this.orderBy = Objects.requireNonNull(orderBy, "orderBy is null");
        this.rowSemantics = rowSemantics;
        this.pruneWhenEmpty = pruneWhenEmpty;
        this.passThroughColumns = passThroughColumns;
    }

    @JsonProperty
    public Optional<QualifiedName> getName() {
        return this.name;
    }

    @JsonProperty
    public RowType getRowType() {
        return this.rowType;
    }

    @JsonProperty
    public List<String> getPartitionBy() {
        return this.partitionBy;
    }

    @JsonProperty
    public List<SortItem> getOrderBy() {
        return this.orderBy;
    }

    @JsonProperty
    public boolean isRowSemantics() {
        return this.rowSemantics;
    }

    @JsonProperty
    public boolean isPruneWhenEmpty() {
        return this.pruneWhenEmpty;
    }

    @JsonProperty
    public boolean isPassThroughColumns() {
        return this.passThroughColumns;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Optional<QualifiedName> name;
        private RowType rowType;
        private List<String> partitionBy = List.of();
        private List<SortItem> orderBy = List.of();
        private boolean rowSemantics;
        private boolean pruneWhenEmpty;
        private boolean passThroughColumns;

        private Builder() {
        }

        public Builder name(Optional<QualifiedName> name) {
            this.name = name;
            return this;
        }

        public Builder rowType(RowType rowType) {
            this.rowType = rowType;
            return this;
        }

        public Builder partitionBy(List<String> partitionBy) {
            this.partitionBy = partitionBy;
            return this;
        }

        public Builder orderBy(List<SortItem> orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        public Builder rowSemantics(boolean rowSemantics) {
            this.rowSemantics = rowSemantics;
            return this;
        }

        public Builder pruneWhenEmpty(boolean pruneWhenEmpty) {
            this.pruneWhenEmpty = pruneWhenEmpty;
            return this;
        }

        public Builder passThroughColumns(boolean passThroughColumns) {
            this.passThroughColumns = passThroughColumns;
            return this;
        }

        public TableArgument build() {
            return new TableArgument(this.name, this.rowType, this.partitionBy, this.orderBy, this.rowSemantics, this.pruneWhenEmpty, this.passThroughColumns);
        }
    }

    public static class SortItem {
        private final String column;
        private final boolean ascending;
        private final boolean nullsLast;

        @JsonCreator
        public SortItem(@JsonProperty(value="column") String column, @JsonProperty(value="ascending") boolean ascending, @JsonProperty(value="nullsFirst") boolean nullsFirst) {
            this.column = Preconditions.checkNotNullOrEmpty(column, "ordering column");
            this.ascending = ascending;
            this.nullsLast = nullsFirst;
        }

        @JsonProperty
        public String getColumn() {
            return this.column;
        }

        @JsonProperty
        public boolean isAscending() {
            return this.ascending;
        }

        @JsonProperty
        public boolean isNullsLast() {
            return this.nullsLast;
        }
    }

    public static class QualifiedName {
        private final String catalogName;
        private final String schemaName;
        private final String tableName;

        @JsonCreator
        public QualifiedName(@JsonProperty(value="catalogName") String catalogName, @JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName) {
            this.catalogName = Preconditions.checkNotNullOrEmpty(catalogName, "catalogName");
            this.schemaName = Preconditions.checkNotNullOrEmpty(schemaName, "schemaName");
            this.tableName = Preconditions.checkNotNullOrEmpty(tableName, "tableName");
        }

        @JsonProperty
        public String getCatalogName() {
            return this.catalogName;
        }

        @JsonProperty
        public String getSchemaName() {
            return this.schemaName;
        }

        @JsonProperty
        public String getTableName() {
            return this.tableName;
        }
    }
}

