/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.ptf;

import io.trino.spi.Experimental;
import io.trino.spi.ptf.NameAndPosition;
import io.trino.spi.ptf.Preconditions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@Experimental(eta="2022-10-31")
public class DescriptorMapping {
    public static final DescriptorMapping EMPTY_MAPPING = new DescriptorMappingBuilder().build();
    private final Map<NameAndPosition, String> mappingByField;
    private final Map<String, String> mappingByDescriptor;

    private DescriptorMapping(Map<NameAndPosition, String> mappingByField, Map<String, String> mappingByDescriptor) {
        this.mappingByField = Map.copyOf(Objects.requireNonNull(mappingByField, "mappingByField is null"));
        this.mappingByDescriptor = Map.copyOf(Objects.requireNonNull(mappingByDescriptor, "mappingByDescriptor is null"));
    }

    public Map<NameAndPosition, String> getMappingByField() {
        return this.mappingByField;
    }

    public Map<String, String> getMappingByDescriptor() {
        return this.mappingByDescriptor;
    }

    public boolean isEmpty() {
        return this.mappingByField.isEmpty() && this.mappingByDescriptor.isEmpty();
    }

    public static class DescriptorMappingBuilder {
        private final Map<NameAndPosition, String> mappingByField = new HashMap<NameAndPosition, String>();
        private final Map<String, String> mappingByDescriptor = new HashMap<String, String>();
        private final Set<String> descriptorsMappedByField = new HashSet<String>();

        public DescriptorMappingBuilder mapField(String descriptor, int field, String table) {
            Preconditions.checkNotNullOrEmpty(table, "table");
            Preconditions.checkArgument(!this.mappingByDescriptor.containsKey(descriptor), String.format("duplicate mapping for descriptor: %s, field: %s", descriptor, field));
            Preconditions.checkArgument(this.mappingByField.put(new NameAndPosition(descriptor, field), table) == null, String.format("duplicate mapping for descriptor: %s, field: %s", descriptor, field));
            this.descriptorsMappedByField.add(descriptor);
            return this;
        }

        public DescriptorMappingBuilder mapAllFields(String descriptor, String table) {
            Preconditions.checkNotNullOrEmpty(descriptor, "descriptor");
            Preconditions.checkNotNullOrEmpty(table, "table");
            Preconditions.checkArgument(!this.descriptorsMappedByField.contains(descriptor), "duplicate mapping for field of descriptor: " + descriptor);
            Preconditions.checkArgument(this.mappingByDescriptor.put(descriptor, table) == null, "duplicate mapping for descriptor: " + descriptor);
            return this;
        }

        public DescriptorMapping build() {
            return new DescriptorMapping(this.mappingByField, this.mappingByDescriptor);
        }
    }
}

