/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.ptf;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

final class Primitives {
    private static final Map<Class<?>, Class<?>> WRAPPERS = new HashMap();

    private Primitives() {
    }

    public static <T> Class<T> wrap(Class<T> type) {
        Objects.requireNonNull(type);
        Class<?> wrapped = WRAPPERS.get(type);
        return wrapped == null ? type : wrapped;
    }

    static {
        WRAPPERS.put(Boolean.TYPE, Boolean.class);
        WRAPPERS.put(Byte.TYPE, Byte.class);
        WRAPPERS.put(Character.TYPE, Character.class);
        WRAPPERS.put(Double.TYPE, Double.class);
        WRAPPERS.put(Float.TYPE, Float.class);
        WRAPPERS.put(Integer.TYPE, Integer.class);
        WRAPPERS.put(Long.TYPE, Long.class);
        WRAPPERS.put(Short.TYPE, Short.class);
    }
}

