/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.function;

import io.trino.spi.Experimental;
import io.trino.spi.function.FunctionId;
import io.trino.spi.function.FunctionKind;
import io.trino.spi.function.FunctionNullability;
import io.trino.spi.function.Signature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Experimental(eta="2022-10-31")
public class FunctionMetadata {
    private final FunctionId functionId;
    private final Signature signature;
    private final String canonicalName;
    private final FunctionNullability functionNullability;
    private final boolean hidden;
    private final boolean deterministic;
    private final String description;
    private final FunctionKind kind;
    private final boolean deprecated;

    private FunctionMetadata(FunctionId functionId, Signature signature, String canonicalName, FunctionNullability functionNullability, boolean hidden, boolean deterministic, String description, FunctionKind kind, boolean deprecated) {
        this.functionId = Objects.requireNonNull(functionId, "functionId is null");
        this.signature = Objects.requireNonNull(signature, "signature is null");
        this.canonicalName = Objects.requireNonNull(canonicalName, "canonicalName is null");
        this.functionNullability = Objects.requireNonNull(functionNullability, "functionNullability is null");
        if (functionNullability.getArgumentNullable().size() != signature.getArgumentTypes().size()) {
            throw new IllegalArgumentException("signature and functionNullability must have same argument count");
        }
        this.hidden = hidden;
        this.deterministic = deterministic;
        this.description = Objects.requireNonNull(description, "description is null");
        this.kind = Objects.requireNonNull(kind, "kind is null");
        this.deprecated = deprecated;
    }

    public FunctionId getFunctionId() {
        return this.functionId;
    }

    public Signature getSignature() {
        return this.signature;
    }

    public String getCanonicalName() {
        return this.canonicalName;
    }

    public FunctionNullability getFunctionNullability() {
        return this.functionNullability;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isDeterministic() {
        return this.deterministic;
    }

    public String getDescription() {
        return this.description;
    }

    public FunctionKind getKind() {
        return this.kind;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public String toString() {
        return this.signature.toString();
    }

    public static Builder scalarBuilder() {
        return FunctionMetadata.builder(FunctionKind.SCALAR);
    }

    public static Builder aggregateBuilder() {
        return FunctionMetadata.builder(FunctionKind.AGGREGATE);
    }

    public static Builder windowBuilder() {
        return FunctionMetadata.builder(FunctionKind.WINDOW);
    }

    public static Builder builder(FunctionKind functionKind) {
        return new Builder(functionKind);
    }

    public static final class Builder {
        private final FunctionKind kind;
        private Signature signature;
        private String canonicalName;
        private boolean nullable;
        private List<Boolean> argumentNullability;
        private boolean hidden;
        private boolean deterministic = true;
        private String description;
        private FunctionId functionId;
        private boolean deprecated;

        private Builder(FunctionKind kind) {
            this.kind = kind;
            if (kind == FunctionKind.AGGREGATE || kind == FunctionKind.WINDOW) {
                this.nullable = true;
            }
        }

        public Builder signature(Signature signature) {
            this.signature = signature;
            if (signature.isOperator()) {
                this.hidden = true;
                this.description = "";
            }
            return this;
        }

        public Builder canonicalName(String canonicalName) {
            this.canonicalName = canonicalName;
            return this;
        }

        public Builder nullable() {
            this.nullable = true;
            return this;
        }

        public Builder argumentNullability(boolean ... argumentNullability) {
            Objects.requireNonNull(argumentNullability, "argumentNullability is null");
            ArrayList<Boolean> list = new ArrayList<Boolean>(argumentNullability.length);
            for (boolean nullability : argumentNullability) {
                list.add(nullability);
            }
            return this.argumentNullability(list);
        }

        public Builder argumentNullability(List<Boolean> argumentNullability) {
            this.argumentNullability = List.copyOf((Collection)Objects.requireNonNull(argumentNullability, "argumentNullability is null"));
            return this;
        }

        public Builder hidden() {
            this.hidden = true;
            if (this.description == null) {
                this.description = "";
            }
            return this;
        }

        public Builder nondeterministic() {
            this.deterministic = false;
            return this;
        }

        public Builder noDescription() {
            this.description = "";
            return this;
        }

        public Builder description(String description) {
            Objects.requireNonNull(description, "description is null");
            if (description.isBlank()) {
                throw new IllegalArgumentException("description is blank");
            }
            this.description = description;
            return this;
        }

        public Builder functionId(FunctionId functionId) {
            this.functionId = functionId;
            return this;
        }

        public Builder deprecated() {
            this.deprecated = true;
            return this;
        }

        public FunctionMetadata build() {
            FunctionId functionId = this.functionId;
            if (functionId == null) {
                functionId = FunctionId.toFunctionId(this.signature);
            }
            if (this.canonicalName == null) {
                this.canonicalName = Objects.requireNonNull(this.signature, "signature is null").getName();
            }
            if (this.argumentNullability == null) {
                this.argumentNullability = Collections.nCopies(this.signature.getArgumentTypes().size(), this.kind == FunctionKind.WINDOW);
            }
            return new FunctionMetadata(functionId, this.signature, this.canonicalName, new FunctionNullability(this.nullable, this.argumentNullability), this.hidden, this.deterministic, this.description, this.kind, this.deprecated);
        }
    }
}

