/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.DecimalParseResult;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.Int128Math;
import io.trino.spi.type.LongDecimalType;
import io.trino.spi.type.ShortDecimalType;
import io.trino.spi.type.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Decimals {
    public static final Int128 MAX_UNSCALED_DECIMAL;
    public static final Int128 MIN_UNSCALED_DECIMAL;
    public static final int MAX_PRECISION = 38;
    public static final int MAX_SHORT_PRECISION = 18;
    private static final Pattern DECIMAL_PATTERN;
    private static final int LONG_POWERS_OF_TEN_TABLE_LENGTH = 19;
    private static final int BIG_INTEGER_POWERS_OF_TEN_TABLE_LENGTH = 100;
    private static final long[] LONG_POWERS_OF_TEN;
    private static final BigInteger[] BIG_INTEGER_POWERS_OF_TEN;

    private Decimals() {
    }

    public static long longTenToNth(int n) {
        return LONG_POWERS_OF_TEN[n];
    }

    public static BigInteger bigIntegerTenToNth(int n) {
        return BIG_INTEGER_POWERS_OF_TEN[n];
    }

    public static DecimalParseResult parse(String stringValue) {
        Matcher matcher = DECIMAL_PATTERN.matcher(stringValue);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid decimal value '" + stringValue + "'");
        }
        String sign = Decimals.getMatcherGroup(matcher, 1);
        if (sign.isEmpty()) {
            sign = "+";
        }
        String leadingZeros = Decimals.getMatcherGroup(matcher, 3);
        String integralPart = Decimals.getMatcherGroup(matcher, 4);
        String fractionalPart = Decimals.getMatcherGroup(matcher, 6);
        if (leadingZeros.isEmpty() && integralPart.isEmpty() && fractionalPart.isEmpty()) {
            throw new IllegalArgumentException("Invalid decimal value '" + stringValue + "'");
        }
        int scale = fractionalPart.length();
        int precision = integralPart.length() + scale;
        if (precision == 0) {
            precision = 1;
        }
        String unscaledValue = sign + leadingZeros + integralPart + fractionalPart;
        Comparable<Long> value = precision <= 18 ? Long.valueOf(Long.parseLong(unscaledValue)) : Int128.valueOf(new BigInteger(unscaledValue));
        if (precision > 38) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Value exceeds maximum precision");
        }
        return new DecimalParseResult(value, DecimalType.createDecimalType(precision, scale));
    }

    private static String getMatcherGroup(MatchResult matcher, int group) {
        String groupValue = matcher.group(group);
        if (groupValue == null) {
            groupValue = "";
        }
        return groupValue;
    }

    public static long encodeShortScaledValue(BigDecimal value, int scale) {
        return Decimals.encodeShortScaledValue(value, scale, RoundingMode.UNNECESSARY);
    }

    public static long encodeShortScaledValue(BigDecimal value, int scale, RoundingMode roundingMode) {
        if (scale < 0) {
            throw new IllegalArgumentException("scale is negative: " + scale);
        }
        return value.setScale(scale, roundingMode).unscaledValue().longValueExact();
    }

    public static Int128 encodeScaledValue(BigDecimal value, int scale) {
        return Decimals.encodeScaledValue(value, scale, RoundingMode.UNNECESSARY);
    }

    public static Int128 encodeScaledValue(BigDecimal value, int scale, RoundingMode roundingMode) {
        if (scale < 0) {
            throw new IllegalArgumentException("scale is negative: " + scale);
        }
        return Decimals.valueOf(value.setScale(scale, roundingMode));
    }

    public static String toString(long unscaledValue, int scale) {
        return Decimals.toString(Long.toString(unscaledValue), scale);
    }

    public static String toString(Int128 unscaledValue, int scale) {
        return Decimals.toString(unscaledValue.toString(), scale);
    }

    public static String toString(BigInteger unscaledValue, int scale) {
        return Decimals.toString(unscaledValue.toString(), scale);
    }

    private static String toString(String unscaledValueString, int scale) {
        StringBuilder resultBuilder = new StringBuilder();
        if (unscaledValueString.startsWith("-")) {
            resultBuilder.append("-");
            unscaledValueString = unscaledValueString.substring(1);
        }
        if (unscaledValueString.length() <= scale) {
            resultBuilder.append("0");
        } else {
            resultBuilder.append(unscaledValueString, 0, unscaledValueString.length() - scale);
        }
        if (scale > 0) {
            resultBuilder.append(".");
            if (unscaledValueString.length() < scale) {
                resultBuilder.append("0".repeat(scale - unscaledValueString.length()));
                resultBuilder.append(unscaledValueString);
            } else {
                resultBuilder.append(unscaledValueString.substring(unscaledValueString.length() - scale));
            }
        }
        return resultBuilder.toString();
    }

    public static boolean overflows(long value, int precision) {
        if (precision > 18) {
            throw new IllegalArgumentException("expected precision to be less than 18");
        }
        return Math.abs(value) >= Decimals.longTenToNth(precision);
    }

    public static boolean overflows(BigInteger value, int precision) {
        return value.abs().compareTo(Decimals.bigIntegerTenToNth(precision)) >= 0;
    }

    public static boolean overflows(BigDecimal value, long precision) {
        return (long)value.precision() > precision;
    }

    public static BigDecimal readBigDecimal(DecimalType type, Block block, int position) {
        BigInteger unscaledValue = type.isShort() ? BigInteger.valueOf(type.getLong(block, position)) : ((Int128)type.getObject(block, position)).toBigInteger();
        return new BigDecimal(unscaledValue, type.getScale(), new MathContext(type.getPrecision()));
    }

    public static void writeBigDecimal(DecimalType decimalType, BlockBuilder blockBuilder, BigDecimal value) {
        decimalType.writeObject(blockBuilder, Decimals.valueOf(value));
    }

    public static BigDecimal rescale(BigDecimal value, DecimalType type) {
        if ((value = value.setScale(type.getScale(), RoundingMode.UNNECESSARY)).precision() > type.getPrecision()) {
            throw new IllegalArgumentException("decimal precision larger than column precision");
        }
        return value;
    }

    public static void writeShortDecimal(BlockBuilder blockBuilder, long value) {
        blockBuilder.writeLong(value).closeEntry();
    }

    public static long rescale(long value, int fromScale, int toScale) {
        if (toScale < fromScale) {
            throw new IllegalArgumentException("target scale must be larger than source scale");
        }
        return value * Decimals.longTenToNth(toScale - fromScale);
    }

    public static BigInteger rescale(BigInteger value, int fromScale, int toScale) {
        if (toScale < fromScale) {
            throw new IllegalArgumentException("target scale must be larger than source scale");
        }
        return value.multiply(Decimals.bigIntegerTenToNth(toScale - fromScale));
    }

    public static boolean isShortDecimal(Type type) {
        return type instanceof ShortDecimalType;
    }

    public static boolean isLongDecimal(Type type) {
        return type instanceof LongDecimalType;
    }

    public static Int128 valueOf(BigDecimal value) {
        return Decimals.valueOf(value.unscaledValue());
    }

    public static Int128 valueOf(BigInteger value) {
        Int128 result;
        try {
            result = Int128.valueOf(value);
        }
        catch (Exception e) {
            throw new ArithmeticException("Decimal overflow");
        }
        Decimals.throwIfOverflows(result.getHigh(), result.getLow());
        return result;
    }

    public static void throwIfOverflows(long high, long low) {
        if (Decimals.overflows(high, low)) {
            throw new ArithmeticException("Decimal overflow");
        }
    }

    public static boolean overflows(Int128 value) {
        return Decimals.overflows(value.getHigh(), value.getLow());
    }

    public static boolean overflows(long high, long low) {
        return Int128.compare(high, low, MAX_UNSCALED_DECIMAL.getHigh(), MAX_UNSCALED_DECIMAL.getLow()) > 0 || Int128.compare(high, low, MIN_UNSCALED_DECIMAL.getHigh(), MIN_UNSCALED_DECIMAL.getLow()) < 0;
    }

    public static boolean overflows(Int128 value, int precision) {
        if (precision > 38) {
            throw new IllegalArgumentException("precision must be in [1, 38] range");
        }
        if (precision == 38) {
            return Decimals.overflows(value.getHigh(), value.getLow());
        }
        return Int128Math.absExact(value).compareTo(Int128Math.powerOfTen(precision)) >= 0;
    }

    static {
        int i;
        MAX_UNSCALED_DECIMAL = Int128.valueOf("99999999999999999999999999999999999999");
        MIN_UNSCALED_DECIMAL = Int128.valueOf("-99999999999999999999999999999999999999");
        DECIMAL_PATTERN = Pattern.compile("(\\+?|-?)((0*)(\\d*))(\\.(\\d*))?");
        LONG_POWERS_OF_TEN = new long[19];
        BIG_INTEGER_POWERS_OF_TEN = new BigInteger[100];
        for (i = 0; i < LONG_POWERS_OF_TEN.length; ++i) {
            Decimals.LONG_POWERS_OF_TEN[i] = Math.round(Math.pow(10.0, i));
        }
        for (i = 0; i < BIG_INTEGER_POWERS_OF_TEN.length; ++i) {
            Decimals.BIG_INTEGER_POWERS_OF_TEN[i] = BigInteger.TEN.pow(i);
        }
    }
}

