/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.ptf;

import io.trino.spi.Experimental;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.ptf.Argument;
import io.trino.spi.ptf.ArgumentSpecification;
import io.trino.spi.ptf.ConnectorTableFunction;
import io.trino.spi.ptf.ReturnTypeSpecification;
import io.trino.spi.ptf.TableFunctionAnalysis;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Experimental(eta="2022-10-31")
public abstract class AbstractConnectorTableFunction
implements ConnectorTableFunction {
    private final String schema;
    private final String name;
    private final List<ArgumentSpecification> arguments;
    private final ReturnTypeSpecification returnTypeSpecification;

    public AbstractConnectorTableFunction(String schema, String name, List<ArgumentSpecification> arguments, ReturnTypeSpecification returnTypeSpecification) {
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.name = Objects.requireNonNull(name, "name is null");
        this.arguments = List.copyOf((Collection)Objects.requireNonNull(arguments, "arguments is null"));
        this.returnTypeSpecification = Objects.requireNonNull(returnTypeSpecification, "returnTypeSpecification is null");
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<ArgumentSpecification> getArguments() {
        return this.arguments;
    }

    @Override
    public ReturnTypeSpecification getReturnTypeSpecification() {
        return this.returnTypeSpecification;
    }

    @Override
    public abstract TableFunctionAnalysis analyze(ConnectorSession var1, ConnectorTransactionHandle var2, Map<String, Argument> var3);
}

