/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorMethodHandle;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarFunctionAdapter;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperatorDeclaration;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class TypeOperators {
    private final ScalarFunctionAdapter functionAdapter = new ScalarFunctionAdapter(ScalarFunctionAdapter.NullAdaptationPolicy.RETURN_NULL_ON_NULL);
    private final BiFunction<Object, Supplier<Object>, Object> cache;
    private static final MethodHandle BLOCK_POSITION_DISTINCT_FROM;
    private static final MethodHandle LOGICAL_OR;
    private static final MethodHandle LOGICAL_XOR;
    private static final MethodHandle NOT_EQUAL;
    private static final MethodHandle IS_COMPARISON_LESS_THAN;
    private static final MethodHandle IS_COMPARISON_LESS_THAN_OR_EQUAL;
    private static final MethodHandle ORDER_NULLS;
    private static final MethodHandle ORDER_COMPARISON_RESULT;
    private static final MethodHandle BLOCK_IS_NULL;

    public TypeOperators() {
        ConcurrentHashMap cache = new ConcurrentHashMap();
        this.cache = (operatorConvention, supplier) -> {
            Object operator = cache.get(operatorConvention);
            if (operator != null) {
                return operator;
            }
            return cache.computeIfAbsent(operatorConvention, arg_0 -> TypeOperators.lambda$new$0((Supplier)supplier, arg_0));
        };
    }

    public TypeOperators(BiFunction<Object, Supplier<Object>, Object> cache) {
        this.cache = cache;
    }

    public MethodHandle getEqualOperator(Type type, InvocationConvention callingConvention) {
        if (!type.isComparable()) {
            throw new UnsupportedOperationException(type + " is not comparable");
        }
        return this.getOperatorAdaptor(type, callingConvention, OperatorType.EQUAL).get();
    }

    public MethodHandle getHashCodeOperator(Type type, InvocationConvention callingConvention) {
        if (!type.isComparable()) {
            throw new UnsupportedOperationException(type + " is not comparable");
        }
        return this.getOperatorAdaptor(type, callingConvention, OperatorType.HASH_CODE).get();
    }

    public MethodHandle getXxHash64Operator(Type type, InvocationConvention callingConvention) {
        if (!type.isComparable()) {
            throw new UnsupportedOperationException(type + " is not comparable");
        }
        return this.getOperatorAdaptor(type, callingConvention, OperatorType.XX_HASH_64).get();
    }

    public MethodHandle getDistinctFromOperator(Type type, InvocationConvention callingConvention) {
        if (!type.isComparable()) {
            throw new UnsupportedOperationException(type + " is not comparable");
        }
        return this.getOperatorAdaptor(type, callingConvention, OperatorType.IS_DISTINCT_FROM).get();
    }

    public MethodHandle getIndeterminateOperator(Type type, InvocationConvention callingConvention) {
        if (!type.isComparable()) {
            throw new UnsupportedOperationException(type + " is not comparable");
        }
        return this.getOperatorAdaptor(type, callingConvention, OperatorType.INDETERMINATE).get();
    }

    public MethodHandle getComparisonUnorderedLastOperator(Type type, InvocationConvention callingConvention) {
        if (!type.isOrderable()) {
            throw new UnsupportedOperationException(type + " is not orderable");
        }
        return this.getOperatorAdaptor(type, callingConvention, OperatorType.COMPARISON_UNORDERED_LAST).get();
    }

    public MethodHandle getComparisonUnorderedFirstOperator(Type type, InvocationConvention callingConvention) {
        if (!type.isOrderable()) {
            throw new UnsupportedOperationException(type + " is not orderable");
        }
        return this.getOperatorAdaptor(type, callingConvention, OperatorType.COMPARISON_UNORDERED_FIRST).get();
    }

    public MethodHandle getOrderingOperator(Type type, SortOrder sortOrder, InvocationConvention callingConvention) {
        if (!type.isOrderable()) {
            throw new UnsupportedOperationException(type + " is not orderable");
        }
        OperatorType comparisonType = sortOrder.isNullsFirst() ? OperatorType.COMPARISON_UNORDERED_FIRST : OperatorType.COMPARISON_UNORDERED_LAST;
        return this.getOperatorAdaptor(type, Optional.of(sortOrder), callingConvention, comparisonType).get();
    }

    public MethodHandle getLessThanOperator(Type type, InvocationConvention callingConvention) {
        if (!type.isOrderable()) {
            throw new UnsupportedOperationException(type + " is not orderable");
        }
        return this.getOperatorAdaptor(type, callingConvention, OperatorType.LESS_THAN).get();
    }

    public MethodHandle getLessThanOrEqualOperator(Type type, InvocationConvention callingConvention) {
        if (!type.isOrderable()) {
            throw new UnsupportedOperationException(type + " is not orderable");
        }
        return this.getOperatorAdaptor(type, callingConvention, OperatorType.LESS_THAN_OR_EQUAL).get();
    }

    private OperatorAdaptor getOperatorAdaptor(Type type, InvocationConvention callingConvention, OperatorType operatorType) {
        return this.getOperatorAdaptor(type, Optional.empty(), callingConvention, operatorType);
    }

    private OperatorAdaptor getOperatorAdaptor(Type type, Optional<SortOrder> sortOrder, InvocationConvention callingConvention, OperatorType operatorType) {
        OperatorConvention operatorConvention = new OperatorConvention(type, operatorType, sortOrder, callingConvention);
        return (OperatorAdaptor)this.cache.apply(operatorConvention, () -> new OperatorAdaptor(this.functionAdapter, operatorConvention));
    }

    private static int getScore(OperatorMethodHandle operatorMethodHandle) {
        int score = 0;
        for (InvocationConvention.InvocationArgumentConvention argument : operatorMethodHandle.getCallingConvention().getArgumentConventions()) {
            if (argument == InvocationConvention.InvocationArgumentConvention.NULL_FLAG) {
                score += 1000;
                continue;
            }
            if (argument != InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION) continue;
            ++score;
        }
        return score;
    }

    private static OperatorMethodHandle adaptBlockPositionEqualToDistinctFrom(MethodHandle blockPositionEqual) {
        return new OperatorMethodHandle(InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION), BLOCK_POSITION_DISTINCT_FROM.bindTo(blockPositionEqual));
    }

    private static boolean genericBlockPositionDistinctFrom(MethodHandle equalOperator, Block left, int leftPosition, Block right, int rightPosition) throws Throwable {
        boolean leftIsNull = left.isNull(leftPosition);
        boolean rightIsNull = right.isNull(rightPosition);
        if (leftIsNull || rightIsNull) {
            return leftIsNull != rightIsNull;
        }
        return TypeOperators.notEqual(equalOperator.invokeExact(left, leftPosition, right, rightPosition));
    }

    private static OperatorMethodHandle adaptNeverNullEqualToDistinctFrom(MethodHandle neverNullEqual) {
        MethodHandle eitherArgIsNull = LOGICAL_OR;
        eitherArgIsNull = MethodHandles.dropArguments(eitherArgIsNull, 0, new Class[]{neverNullEqual.type().parameterType(0)});
        eitherArgIsNull = MethodHandles.dropArguments(eitherArgIsNull, 2, new Class[]{neverNullEqual.type().parameterType(1)});
        MethodHandle distinctNullValues = LOGICAL_XOR;
        distinctNullValues = MethodHandles.dropArguments(distinctNullValues, 0, new Class[]{neverNullEqual.type().parameterType(0)});
        distinctNullValues = MethodHandles.dropArguments(distinctNullValues, 2, new Class[]{neverNullEqual.type().parameterType(1)});
        MethodHandle notEqual = MethodHandles.filterReturnValue(neverNullEqual, NOT_EQUAL);
        notEqual = MethodHandles.dropArguments(notEqual, 1, new Class[]{Boolean.TYPE});
        notEqual = MethodHandles.dropArguments(notEqual, 3, new Class[]{Boolean.TYPE});
        return new OperatorMethodHandle(InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.NULL_FLAG, InvocationConvention.InvocationArgumentConvention.NULL_FLAG), MethodHandles.guardWithTest(eitherArgIsNull, distinctNullValues, notEqual));
    }

    private static OperatorMethodHandle defaultIndeterminateOperator(Class<?> javaType) {
        MethodHandle methodHandle = MethodHandles.identity(Boolean.TYPE);
        methodHandle = MethodHandles.dropArguments(methodHandle, 0, new Class[]{javaType});
        return new OperatorMethodHandle(InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.NULL_FLAG), methodHandle);
    }

    private static boolean notEqual(Boolean equal) {
        return Objects.requireNonNull(equal, "equal returned null") == false;
    }

    private static OperatorMethodHandle adaptNeverNullComparisonToOrdering(SortOrder sortOrder, MethodHandle neverNullComparison) {
        MethodType finalSignature = MethodType.methodType(Integer.TYPE, Boolean.TYPE, new Class[]{neverNullComparison.type().parameterType(0), Boolean.TYPE, neverNullComparison.type().parameterType(1)});
        MethodHandle order = TypeOperators.adaptComparisonToOrdering(sortOrder, neverNullComparison);
        order = MethodHandles.permuteArguments(order, finalSignature, 0, 2, 1, 3);
        return new OperatorMethodHandle(InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.NULL_FLAG, InvocationConvention.InvocationArgumentConvention.NULL_FLAG), order);
    }

    private static OperatorMethodHandle adaptBlockPositionComparisonToOrdering(SortOrder sortOrder, MethodHandle blockPositionComparison) {
        MethodType finalSignature = MethodType.methodType(Integer.TYPE, Block.class, Integer.TYPE, Block.class, Integer.TYPE);
        MethodHandle order = TypeOperators.adaptComparisonToOrdering(sortOrder, blockPositionComparison);
        order = MethodHandles.collectArguments(order, 1, BLOCK_IS_NULL);
        order = MethodHandles.collectArguments(order, 0, BLOCK_IS_NULL);
        order = MethodHandles.permuteArguments(order, finalSignature, 0, 1, 2, 3, 0, 1, 2, 3);
        return new OperatorMethodHandle(InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION), order);
    }

    private static MethodHandle adaptComparisonToOrdering(SortOrder sortOrder, MethodHandle comparison) {
        MethodHandle eitherIsNull = LOGICAL_OR;
        eitherIsNull = MethodHandles.dropArguments(eitherIsNull, 2, comparison.type().parameterList());
        MethodHandle orderNulls = ORDER_NULLS.bindTo((Object)sortOrder);
        orderNulls = MethodHandles.dropArguments(orderNulls, 2, comparison.type().parameterList());
        MethodHandle orderComparision = MethodHandles.filterReturnValue(comparison, ORDER_COMPARISON_RESULT.bindTo((Object)sortOrder));
        orderComparision = MethodHandles.dropArguments(orderComparision, 0, new Class[]{Boolean.TYPE, Boolean.TYPE});
        return MethodHandles.guardWithTest(eitherIsNull, orderNulls, orderComparision);
    }

    private static int orderNulls(SortOrder sortOrder, boolean leftIsNull, boolean rightIsNull) {
        if (leftIsNull && rightIsNull) {
            return 0;
        }
        if (leftIsNull) {
            return sortOrder.isNullsFirst() ? -1 : 1;
        }
        if (rightIsNull) {
            return sortOrder.isNullsFirst() ? 1 : -1;
        }
        throw new IllegalArgumentException("Neither left or right is null");
    }

    private static int orderComparisonResult(SortOrder sortOrder, long result) {
        return (int)(sortOrder.isAscending() ? result : -result);
    }

    private static OperatorMethodHandle adaptComparisonToLessThan(OperatorMethodHandle invoker) {
        InvocationConvention.InvocationReturnConvention returnConvention = invoker.getCallingConvention().getReturnConvention();
        if (returnConvention != InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL) {
            throw new IllegalArgumentException("Return convention must be " + InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL + ", but is " + returnConvention);
        }
        return new OperatorMethodHandle(invoker.getCallingConvention(), MethodHandles.filterReturnValue(invoker.getMethodHandle(), IS_COMPARISON_LESS_THAN));
    }

    private static boolean isComparisonLessThan(long comparisonResult) {
        return comparisonResult < 0L;
    }

    private static OperatorMethodHandle adaptComparisonToLessThanOrEqual(OperatorMethodHandle invoker) {
        InvocationConvention.InvocationReturnConvention returnConvention = invoker.getCallingConvention().getReturnConvention();
        if (returnConvention != InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL) {
            throw new IllegalArgumentException("Return convention must be " + InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL + ", but is " + returnConvention);
        }
        return new OperatorMethodHandle(invoker.getCallingConvention(), MethodHandles.filterReturnValue(invoker.getMethodHandle(), IS_COMPARISON_LESS_THAN_OR_EQUAL));
    }

    private static boolean isComparisonLessThanOrEqual(long comparisonResult) {
        return comparisonResult <= 0L;
    }

    private static /* synthetic */ Object lambda$new$0(Supplier supplier, Object key) {
        return supplier.get();
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            BLOCK_POSITION_DISTINCT_FROM = lookup.findStatic(TypeOperators.class, "genericBlockPositionDistinctFrom", MethodType.methodType(Boolean.TYPE, MethodHandle.class, Block.class, Integer.TYPE, Block.class, Integer.TYPE));
            LOGICAL_OR = lookup.findStatic(Boolean.class, "logicalOr", MethodType.methodType(Boolean.TYPE, Boolean.TYPE, Boolean.TYPE));
            LOGICAL_XOR = lookup.findStatic(Boolean.class, "logicalXor", MethodType.methodType(Boolean.TYPE, Boolean.TYPE, Boolean.TYPE));
            NOT_EQUAL = lookup.findStatic(TypeOperators.class, "notEqual", MethodType.methodType(Boolean.TYPE, Boolean.class));
            IS_COMPARISON_LESS_THAN = lookup.findStatic(TypeOperators.class, "isComparisonLessThan", MethodType.methodType(Boolean.TYPE, Long.TYPE));
            IS_COMPARISON_LESS_THAN_OR_EQUAL = lookup.findStatic(TypeOperators.class, "isComparisonLessThanOrEqual", MethodType.methodType(Boolean.TYPE, Long.TYPE));
            ORDER_NULLS = lookup.findStatic(TypeOperators.class, "orderNulls", MethodType.methodType(Integer.TYPE, SortOrder.class, Boolean.TYPE, Boolean.TYPE));
            ORDER_COMPARISON_RESULT = lookup.findStatic(TypeOperators.class, "orderComparisonResult", MethodType.methodType(Integer.TYPE, SortOrder.class, Long.TYPE));
            BLOCK_IS_NULL = lookup.findVirtual(Block.class, "isNull", MethodType.methodType(Boolean.TYPE, Integer.TYPE));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private class OperatorAdaptor {
        private final ScalarFunctionAdapter functionAdapter;
        private final OperatorConvention operatorConvention;
        private MethodHandle adapted;

        public OperatorAdaptor(ScalarFunctionAdapter functionAdapter, OperatorConvention operatorConvention) {
            this.functionAdapter = functionAdapter;
            this.operatorConvention = operatorConvention;
        }

        public synchronized MethodHandle get() {
            if (this.adapted == null) {
                this.adapted = this.adaptOperator(this.operatorConvention);
            }
            return this.adapted;
        }

        private MethodHandle adaptOperator(OperatorConvention operatorConvention) {
            OperatorMethodHandle operatorMethodHandle = this.selectOperatorMethodHandleToAdapt(operatorConvention);
            MethodHandle methodHandle = this.adaptOperator(operatorConvention, operatorMethodHandle);
            return methodHandle;
        }

        private MethodHandle adaptOperator(OperatorConvention operatorConvention, OperatorMethodHandle operatorMethodHandle) {
            return this.functionAdapter.adapt(operatorMethodHandle.getMethodHandle(), this.getOperatorArgumentTypes(operatorConvention), operatorMethodHandle.getCallingConvention(), operatorConvention.getCallingConvention());
        }

        private OperatorMethodHandle selectOperatorMethodHandleToAdapt(OperatorConvention operatorConvention) {
            List operatorMethodHandles = this.getOperatorMethodHandles(operatorConvention).stream().sorted(Comparator.comparing(TypeOperators::getScore).reversed()).collect(Collectors.toUnmodifiableList());
            for (OperatorMethodHandle operatorMethodHandle : operatorMethodHandles) {
                if (!this.functionAdapter.canAdapt(operatorMethodHandle.getCallingConvention(), operatorConvention.getCallingConvention())) continue;
                return operatorMethodHandle;
            }
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, String.format("%s %s operator can not be adapted to convention (%s). Available implementations: %s", new Object[]{operatorConvention.getType(), operatorConvention.getOperatorType(), operatorConvention.getCallingConvention(), operatorMethodHandles.stream().map(OperatorMethodHandle::getCallingConvention).map(Object::toString).collect(Collectors.joining(", ", "[", "]"))}));
        }

        private Collection<OperatorMethodHandle> getOperatorMethodHandles(OperatorConvention operatorConvention) {
            TypeOperatorDeclaration typeOperatorDeclaration = operatorConvention.getType().getTypeOperatorDeclaration(TypeOperators.this);
            Objects.requireNonNull(typeOperatorDeclaration, "typeOperators is null for " + operatorConvention.getType());
            switch (operatorConvention.getOperatorType()) {
                case EQUAL: {
                    return typeOperatorDeclaration.getEqualOperators();
                }
                case HASH_CODE: {
                    Collection<OperatorMethodHandle> hashCodeOperators = typeOperatorDeclaration.getHashCodeOperators();
                    if (hashCodeOperators.isEmpty()) {
                        return typeOperatorDeclaration.getXxHash64Operators();
                    }
                    return hashCodeOperators;
                }
                case XX_HASH_64: {
                    return typeOperatorDeclaration.getXxHash64Operators();
                }
                case IS_DISTINCT_FROM: {
                    Collection<OperatorMethodHandle> distinctFromOperators = typeOperatorDeclaration.getDistinctFromOperators();
                    if (distinctFromOperators.isEmpty()) {
                        return List.of(this.generateDistinctFromOperator(operatorConvention));
                    }
                    return distinctFromOperators;
                }
                case INDETERMINATE: {
                    Collection<OperatorMethodHandle> indeterminateOperators = typeOperatorDeclaration.getIndeterminateOperators();
                    if (indeterminateOperators.isEmpty()) {
                        return List.of(TypeOperators.defaultIndeterminateOperator(operatorConvention.getType().getJavaType()));
                    }
                    return indeterminateOperators;
                }
                case COMPARISON_UNORDERED_LAST: {
                    if (operatorConvention.getSortOrder().isPresent()) {
                        return List.of(this.generateOrderingOperator(operatorConvention));
                    }
                    Collection<OperatorMethodHandle> comparisonUnorderedLastOperators = typeOperatorDeclaration.getComparisonUnorderedLastOperators();
                    if (comparisonUnorderedLastOperators.isEmpty()) {
                        return typeOperatorDeclaration.getComparisonUnorderedFirstOperators();
                    }
                    return comparisonUnorderedLastOperators;
                }
                case COMPARISON_UNORDERED_FIRST: {
                    if (operatorConvention.getSortOrder().isPresent()) {
                        return List.of(this.generateOrderingOperator(operatorConvention));
                    }
                    Collection<OperatorMethodHandle> comparisonUnorderedFirstOperators = typeOperatorDeclaration.getComparisonUnorderedFirstOperators();
                    if (comparisonUnorderedFirstOperators.isEmpty()) {
                        return typeOperatorDeclaration.getComparisonUnorderedLastOperators();
                    }
                    return comparisonUnorderedFirstOperators;
                }
                case LESS_THAN: {
                    Collection<OperatorMethodHandle> lessThanOperators = typeOperatorDeclaration.getLessThanOperators();
                    if (lessThanOperators.isEmpty()) {
                        return List.of(this.generateLessThanOperator(operatorConvention, false));
                    }
                    return lessThanOperators;
                }
                case LESS_THAN_OR_EQUAL: {
                    Collection<OperatorMethodHandle> lessThanOrEqualOperators = typeOperatorDeclaration.getLessThanOrEqualOperators();
                    if (lessThanOrEqualOperators.isEmpty()) {
                        return List.of(this.generateLessThanOperator(operatorConvention, true));
                    }
                    return lessThanOrEqualOperators;
                }
            }
            throw new IllegalArgumentException("Unsupported operator type: " + operatorConvention.getOperatorType());
        }

        private OperatorMethodHandle generateDistinctFromOperator(OperatorConvention operatorConvention) {
            if (operatorConvention.getCallingConvention().getArgumentConventions().equals(List.of(InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION))) {
                OperatorConvention equalOperator = new OperatorConvention(operatorConvention.getType(), OperatorType.EQUAL, Optional.empty(), InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION));
                MethodHandle equalMethodHandle = this.adaptOperator(equalOperator);
                return TypeOperators.adaptBlockPositionEqualToDistinctFrom(equalMethodHandle);
            }
            OperatorConvention equalOperator = new OperatorConvention(operatorConvention.getType(), OperatorType.EQUAL, Optional.empty(), InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL));
            MethodHandle equalMethodHandle = this.adaptOperator(equalOperator);
            return TypeOperators.adaptNeverNullEqualToDistinctFrom(equalMethodHandle);
        }

        private OperatorMethodHandle generateLessThanOperator(OperatorConvention operatorConvention, boolean orEqual) {
            InvocationConvention comparisonCallingConvention = operatorConvention.getCallingConvention().getArgumentConventions().equals(List.of(InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION)) ? InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION) : InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL);
            OperatorConvention comparisonOperator = new OperatorConvention(operatorConvention.getType(), OperatorType.COMPARISON_UNORDERED_LAST, Optional.empty(), comparisonCallingConvention);
            MethodHandle comparisonMethod = this.adaptOperator(comparisonOperator);
            if (orEqual) {
                return TypeOperators.adaptComparisonToLessThanOrEqual(new OperatorMethodHandle(comparisonCallingConvention, comparisonMethod));
            }
            return TypeOperators.adaptComparisonToLessThan(new OperatorMethodHandle(comparisonCallingConvention, comparisonMethod));
        }

        private OperatorMethodHandle generateOrderingOperator(OperatorConvention operatorConvention) {
            SortOrder sortOrder = operatorConvention.getSortOrder().orElseThrow(() -> new IllegalArgumentException("Operator convention does not contain a sort order"));
            OperatorType comparisonType = operatorConvention.getOperatorType();
            if (operatorConvention.getCallingConvention().getArgumentConventions().equals(List.of(InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION))) {
                OperatorConvention comparisonOperator = new OperatorConvention(operatorConvention.getType(), comparisonType, Optional.empty(), InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION));
                MethodHandle comparisonInvoker = this.adaptOperator(comparisonOperator);
                return TypeOperators.adaptBlockPositionComparisonToOrdering(sortOrder, comparisonInvoker);
            }
            OperatorConvention comparisonOperator = new OperatorConvention(operatorConvention.getType(), comparisonType, Optional.empty(), InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.NULL_FLAG, InvocationConvention.InvocationArgumentConvention.NULL_FLAG));
            MethodHandle comparisonInvoker = this.adaptOperator(comparisonOperator);
            return TypeOperators.adaptNeverNullComparisonToOrdering(sortOrder, comparisonInvoker);
        }

        private List<Type> getOperatorArgumentTypes(OperatorConvention operatorConvention) {
            switch (operatorConvention.getOperatorType()) {
                case EQUAL: 
                case IS_DISTINCT_FROM: 
                case COMPARISON_UNORDERED_LAST: 
                case COMPARISON_UNORDERED_FIRST: 
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL: {
                    return List.of(operatorConvention.getType(), operatorConvention.getType());
                }
                case HASH_CODE: 
                case XX_HASH_64: 
                case INDETERMINATE: {
                    return List.of(operatorConvention.getType());
                }
            }
            throw new IllegalArgumentException("Unsupported operator type: " + operatorConvention.getOperatorType());
        }
    }

    private static final class OperatorConvention {
        private final Type type;
        private final OperatorType operatorType;
        private final Optional<SortOrder> sortOrder;
        private final InvocationConvention callingConvention;

        public OperatorConvention(Type type, OperatorType operatorType, Optional<SortOrder> sortOrder, InvocationConvention callingConvention) {
            this.type = Objects.requireNonNull(type, "type is null");
            this.operatorType = Objects.requireNonNull(operatorType, "operatorType is null");
            this.sortOrder = Objects.requireNonNull(sortOrder, "sortOrder is null");
            this.callingConvention = Objects.requireNonNull(callingConvention, "callingConvention is null");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OperatorConvention operatorConvention = (OperatorConvention)o;
            return this.type.equals(operatorConvention.type) && this.operatorType == operatorConvention.operatorType && this.sortOrder.equals(operatorConvention.sortOrder) && this.callingConvention.equals(operatorConvention.callingConvention);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.operatorType, this.sortOrder, this.callingConvention});
        }

        public String toString() {
            return new StringJoiner(", ", OperatorConvention.class.getSimpleName() + "[", "]").add("type=" + this.type).add("operatorType=" + this.sortOrder.map(order -> "ORDER_" + order).orElseGet(this.operatorType::toString)).add("callingConvention=" + this.callingConvention).toString();
        }

        public Type getType() {
            return this.type;
        }

        public OperatorType getOperatorType() {
            return this.operatorType;
        }

        public Optional<SortOrder> getSortOrder() {
            return this.sortOrder;
        }

        public InvocationConvention getCallingConvention() {
            return this.callingConvention;
        }
    }
}

