/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.block.BlockUtil;
import io.trino.spi.block.Int96ArrayBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import java.util.Arrays;
import java.util.OptionalInt;
import java.util.function.ObjLongConsumer;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class Int96ArrayBlockBuilder
implements BlockBuilder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(Int96ArrayBlockBuilder.class).instanceSize();
    private static final Block NULL_VALUE_BLOCK = new Int96ArrayBlock(0, 1, new boolean[]{true}, new long[1], new int[1]);
    @Nullable
    private final BlockBuilderStatus blockBuilderStatus;
    private boolean initialized;
    private final int initialEntryCount;
    private int positionCount;
    private boolean hasNullValue;
    private boolean hasNonNullValue;
    private boolean[] valueIsNull = new boolean[0];
    private long[] high = new long[0];
    private int[] low = new int[0];
    private long retainedSizeInBytes;
    private int entryPositionCount;

    public Int96ArrayBlockBuilder(@Nullable BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        this.blockBuilderStatus = blockBuilderStatus;
        this.initialEntryCount = Math.max(expectedEntries, 1);
        this.updateDataSize();
    }

    @Override
    public BlockBuilder writeLong(long high) {
        if (this.entryPositionCount != 0) {
            throw new IllegalArgumentException("long can only be written at the beginning of the entry");
        }
        if (this.valueIsNull.length <= this.positionCount) {
            this.growCapacity();
        }
        this.high[this.positionCount] = high;
        this.hasNonNullValue = true;
        ++this.entryPositionCount;
        return this;
    }

    @Override
    public BlockBuilder writeInt(int low) {
        if (this.entryPositionCount != 1) {
            throw new IllegalArgumentException("int can only be written at the end of the entry");
        }
        if (this.valueIsNull.length <= this.positionCount) {
            this.growCapacity();
        }
        this.low[this.positionCount] = low;
        this.hasNonNullValue = true;
        ++this.entryPositionCount;
        return this;
    }

    @Override
    public BlockBuilder closeEntry() {
        if (this.entryPositionCount != 2) {
            throw new IllegalStateException("Expected entry size to be exactly 12 bytes but was " + this.entryPositionCount * 8);
        }
        ++this.positionCount;
        this.entryPositionCount = 0;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(13);
        }
        return this;
    }

    @Override
    public BlockBuilder appendNull() {
        if (this.entryPositionCount != 0) {
            throw new IllegalStateException("Current entry must be closed before a null can be written");
        }
        if (this.valueIsNull.length <= this.positionCount) {
            this.growCapacity();
        }
        this.valueIsNull[this.positionCount] = true;
        this.hasNullValue = true;
        ++this.positionCount;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(13);
        }
        return this;
    }

    @Override
    public Block build() {
        if (!this.hasNonNullValue) {
            return RunLengthEncodedBlock.create(NULL_VALUE_BLOCK, this.positionCount);
        }
        return new Int96ArrayBlock(0, this.positionCount, this.hasNullValue ? this.valueIsNull : null, this.high, this.low);
    }

    @Override
    public BlockBuilder newBlockBuilderLike(int expectedEntries, BlockBuilderStatus blockBuilderStatus) {
        return new Int96ArrayBlockBuilder(blockBuilderStatus, expectedEntries);
    }

    private void growCapacity() {
        int newSize;
        if (this.initialized) {
            newSize = BlockUtil.calculateNewArraySize(this.valueIsNull.length);
        } else {
            newSize = this.initialEntryCount;
            this.initialized = true;
        }
        this.valueIsNull = Arrays.copyOf(this.valueIsNull, newSize);
        this.high = Arrays.copyOf(this.high, newSize);
        this.low = Arrays.copyOf(this.low, newSize);
        this.updateDataSize();
    }

    private void updateDataSize() {
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + SizeOf.sizeOf((boolean[])this.valueIsNull) + SizeOf.sizeOf((long[])this.high) + SizeOf.sizeOf((int[])this.low);
        if (this.blockBuilderStatus != null) {
            this.retainedSizeInBytes += (long)BlockBuilderStatus.INSTANCE_SIZE;
        }
    }

    @Override
    public OptionalInt fixedSizeInBytesPerPosition() {
        return OptionalInt.of(13);
    }

    @Override
    public long getSizeInBytes() {
        return 13L * (long)this.positionCount;
    }

    @Override
    public long getRegionSizeInBytes(int position, int length) {
        return 13L * (long)length;
    }

    @Override
    public long getPositionsSizeInBytes(boolean[] positions, int selectedPositionsCount) {
        return 13L * (long)selectedPositionsCount;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public long getEstimatedDataSizeForStats(int position) {
        return this.isNull(position) ? 0L : 12L;
    }

    @Override
    public void retainedBytesForEachPart(ObjLongConsumer<Object> consumer) {
        consumer.accept(this.high, SizeOf.sizeOf((long[])this.high));
        consumer.accept(this.low, SizeOf.sizeOf((int[])this.low));
        consumer.accept(this.valueIsNull, SizeOf.sizeOf((boolean[])this.valueIsNull));
        consumer.accept(this, INSTANCE_SIZE);
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getLong(int position, int offset) {
        BlockUtil.checkReadablePosition(this, position);
        if (offset != 0) {
            throw new IllegalArgumentException("offset must be 0");
        }
        return this.high[position];
    }

    @Override
    public int getInt(int position, int offset) {
        BlockUtil.checkReadablePosition(this, position);
        if (offset != 8) {
            throw new IllegalArgumentException("offset must be 8");
        }
        return this.low[position];
    }

    @Override
    public boolean mayHaveNull() {
        return this.hasNullValue;
    }

    @Override
    public boolean isNull(int position) {
        BlockUtil.checkReadablePosition(this, position);
        return this.valueIsNull[position];
    }

    @Override
    public Block getSingleValueBlock(int position) {
        boolean[] blArray;
        BlockUtil.checkReadablePosition(this, position);
        if (this.valueIsNull[position]) {
            boolean[] blArray2 = new boolean[1];
            blArray = blArray2;
            blArray2[0] = true;
        } else {
            blArray = null;
        }
        return new Int96ArrayBlock(0, 1, blArray, new long[]{this.high[position]}, new int[]{this.low[position]});
    }

    @Override
    public Block copyPositions(int[] positions, int offset, int length) {
        BlockUtil.checkArrayRange(positions, offset, length);
        if (!this.hasNonNullValue) {
            return RunLengthEncodedBlock.create(NULL_VALUE_BLOCK, length);
        }
        boolean[] newValueIsNull = null;
        if (this.hasNullValue) {
            newValueIsNull = new boolean[length];
        }
        long[] newHigh = new long[length];
        int[] newLow = new int[length];
        for (int i = 0; i < length; ++i) {
            int position = positions[offset + i];
            BlockUtil.checkReadablePosition(this, position);
            if (this.hasNullValue) {
                newValueIsNull[i] = this.valueIsNull[position];
            }
            newHigh[i] = this.high[position];
            newLow[i] = this.low[position];
        }
        return new Int96ArrayBlock(0, length, newValueIsNull, newHigh, newLow);
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        if (!this.hasNonNullValue) {
            return RunLengthEncodedBlock.create(NULL_VALUE_BLOCK, length);
        }
        return new Int96ArrayBlock(positionOffset, length, this.hasNullValue ? this.valueIsNull : null, this.high, this.low);
    }

    @Override
    public Block copyRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        if (!this.hasNonNullValue) {
            return RunLengthEncodedBlock.create(NULL_VALUE_BLOCK, length);
        }
        boolean[] newValueIsNull = null;
        if (this.hasNullValue) {
            newValueIsNull = BlockUtil.compactArray(this.valueIsNull, positionOffset, length);
        }
        long[] newHigh = BlockUtil.compactArray(this.high, positionOffset, length);
        int[] newLow = BlockUtil.compactArray(this.low, positionOffset, length);
        return new Int96ArrayBlock(0, length, newValueIsNull, newHigh, newLow);
    }

    @Override
    public String getEncodingName() {
        return "INT96_ARRAY";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Int96ArrayBlockBuilder{");
        sb.append("positionCount=").append(this.getPositionCount());
        sb.append('}');
        return sb.toString();
    }

    Slice getHighSlice() {
        return Slices.wrappedLongArray((long[])this.high, (int)0, (int)this.positionCount);
    }

    Slice getLowSlice() {
        return Slices.wrappedIntArray((int[])this.low, (int)0, (int)this.positionCount);
    }
}

