/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.connector;

import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Constant;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.predicate.TupleDomain;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Predicate;

public class Constraint {
    private final TupleDomain<ColumnHandle> summary;
    private final ConnectorExpression expression;
    private final Map<String, ColumnHandle> assignments;
    private final Optional<Predicate<Map<ColumnHandle, NullableValue>>> predicate;
    private final Optional<Set<ColumnHandle>> predicateColumns;

    public static Constraint alwaysTrue() {
        return new Constraint(TupleDomain.all());
    }

    public static Constraint alwaysFalse() {
        return new Constraint(TupleDomain.none(), bindings -> false, Set.of());
    }

    public Constraint(TupleDomain<ColumnHandle> summary) {
        this(summary, (ConnectorExpression)Constant.TRUE, Map.of(), Optional.empty(), Optional.empty());
    }

    public Constraint(TupleDomain<ColumnHandle> summary, Predicate<Map<ColumnHandle, NullableValue>> predicate, Set<ColumnHandle> predicateColumns) {
        this(summary, (ConnectorExpression)Constant.TRUE, Map.of(), Optional.of(predicate), Optional.of(predicateColumns));
    }

    public Constraint(TupleDomain<ColumnHandle> summary, ConnectorExpression expression, Map<String, ColumnHandle> assignments) {
        this(summary, expression, assignments, Optional.empty(), Optional.empty());
    }

    public Constraint(TupleDomain<ColumnHandle> summary, ConnectorExpression expression, Map<String, ColumnHandle> assignments, Predicate<Map<ColumnHandle, NullableValue>> predicate, Set<ColumnHandle> predicateColumns) {
        this(summary, expression, assignments, Optional.of(predicate), Optional.of(predicateColumns));
    }

    private Constraint(TupleDomain<ColumnHandle> summary, ConnectorExpression expression, Map<String, ColumnHandle> assignments, Optional<Predicate<Map<ColumnHandle, NullableValue>>> predicate, Optional<Set<ColumnHandle>> predicateColumns) {
        this.summary = Objects.requireNonNull(summary, "summary is null");
        this.expression = Objects.requireNonNull(expression, "expression is null");
        this.assignments = Map.copyOf(Objects.requireNonNull(assignments, "assignments is null"));
        this.predicate = Objects.requireNonNull(predicate, "predicate is null");
        this.predicateColumns = predicateColumns.map(Set::copyOf);
        if (predicateColumns.isPresent() && predicate.isEmpty()) {
            throw new IllegalArgumentException("predicateColumns cannot be present when predicate is not present");
        }
        if (predicateColumns.isEmpty() && predicate.isPresent()) {
            throw new IllegalArgumentException("predicate cannot be present without predicateColumns");
        }
    }

    public TupleDomain<ColumnHandle> getSummary() {
        return this.summary;
    }

    public ConnectorExpression getExpression() {
        return this.expression;
    }

    public Map<String, ColumnHandle> getAssignments() {
        return this.assignments;
    }

    public Optional<Predicate<Map<ColumnHandle, NullableValue>>> predicate() {
        return this.predicate;
    }

    public Optional<Set<ColumnHandle>> getPredicateColumns() {
        return this.predicateColumns;
    }

    public String toString() {
        StringJoiner stringJoiner = new StringJoiner(", ", Constraint.class.getSimpleName() + "[", "]");
        stringJoiner.add("summary=" + String.valueOf(this.summary));
        stringJoiner.add("expression=" + String.valueOf(this.expression));
        this.predicate.ifPresent(predicate -> stringJoiner.add("predicate=" + String.valueOf(predicate)));
        this.predicateColumns.ifPresent(predicateColumns -> stringJoiner.add("predicateColumns=" + String.valueOf(predicateColumns)));
        return stringJoiner.toString();
    }
}

