/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.expression;

import io.trino.spi.connector.CatalogSchemaName;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;

public class FunctionName {
    private final Optional<CatalogSchemaName> catalogSchema;
    private final String name;

    public FunctionName(String name) {
        this(Optional.empty(), name);
    }

    public FunctionName(Optional<CatalogSchemaName> catalogSchema, String name) {
        this.catalogSchema = Objects.requireNonNull(catalogSchema, "catalogSchema is null");
        this.name = Objects.requireNonNull(name, "name is null");
    }

    public Optional<CatalogSchemaName> getCatalogSchema() {
        return this.catalogSchema;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionName that = (FunctionName)o;
        return Objects.equals(this.catalogSchema, that.catalogSchema) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.catalogSchema, this.name);
    }

    public String toString() {
        StringJoiner stringJoiner = new StringJoiner(", ");
        this.catalogSchema.ifPresent(value -> stringJoiner.add("catalogSchema=" + String.valueOf(value)));
        return stringJoiner.add("name='" + this.name + "'").toString();
    }
}

