/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.Slice;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockUtil;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.Type;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.ObjLongConsumer;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class RunLengthEncodedBlock
implements Block {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(RunLengthEncodedBlock.class).instanceSize();
    private final Block value;
    private final int positionCount;

    public static Block create(Type type, Object value, int positionCount) {
        Block block = Utils.nativeValueToBlock(type, value);
        if (block instanceof RunLengthEncodedBlock) {
            block = ((RunLengthEncodedBlock)block).getValue();
        }
        return RunLengthEncodedBlock.create(block, positionCount);
    }

    public static Block create(Block value, int positionCount) {
        Objects.requireNonNull(value, "value is null");
        if (value.getPositionCount() != 1) {
            throw new IllegalArgumentException(String.format("Expected value to contain a single position but has %s positions", value.getPositionCount()));
        }
        if (positionCount == 0) {
            return value.copyRegion(0, 0);
        }
        if (positionCount == 1) {
            return value;
        }
        return new RunLengthEncodedBlock(value, positionCount);
    }

    private RunLengthEncodedBlock(Block value, int positionCount) {
        Objects.requireNonNull(value, "value is null");
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        if (positionCount < 2) {
            throw new IllegalArgumentException("positionCount must be at least 2");
        }
        if (value instanceof RunLengthEncodedBlock) {
            RunLengthEncodedBlock block = (RunLengthEncodedBlock)value;
            this.value = block.getValue();
        } else if (value instanceof DictionaryBlock) {
            DictionaryBlock block = (DictionaryBlock)value;
            Block dictionary = block.getDictionary();
            int id = block.getId(0);
            this.value = dictionary.getPositionCount() == 1 && id == 0 ? dictionary : dictionary.getRegion(id, 1);
        } else {
            this.value = value;
        }
        this.positionCount = positionCount;
    }

    @Override
    public final List<Block> getChildren() {
        return Collections.singletonList(this.value);
    }

    public Block getValue() {
        return this.value;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public OptionalInt fixedSizeInBytesPerPosition() {
        return OptionalInt.empty();
    }

    @Override
    public long getSizeInBytes() {
        return this.value.getSizeInBytes();
    }

    @Override
    public long getLogicalSizeInBytes() {
        return (long)this.positionCount * this.value.getLogicalSizeInBytes();
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.value.getRetainedSizeInBytes();
    }

    @Override
    public long getEstimatedDataSizeForStats(int position) {
        return this.value.getEstimatedDataSizeForStats(0);
    }

    @Override
    public void retainedBytesForEachPart(ObjLongConsumer<Object> consumer) {
        consumer.accept(this.value, this.value.getRetainedSizeInBytes());
        consumer.accept(this, INSTANCE_SIZE);
    }

    @Override
    public String getEncodingName() {
        return "RLE";
    }

    @Override
    public Block getPositions(int[] positions, int offset, int length) {
        BlockUtil.checkArrayRange(positions, offset, length);
        for (int i = offset; i < offset + length; ++i) {
            BlockUtil.checkValidPosition(positions[i], this.positionCount);
        }
        return RunLengthEncodedBlock.create(this.value, length);
    }

    @Override
    public Block copyPositions(int[] positions, int offset, int length) {
        BlockUtil.checkArrayRange(positions, offset, length);
        for (int i = offset; i < offset + length; ++i) {
            BlockUtil.checkValidPosition(positions[i], this.positionCount);
        }
        return RunLengthEncodedBlock.create(this.value.copyRegion(0, 1), length);
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.positionCount, positionOffset, length);
        return RunLengthEncodedBlock.create(this.value, length);
    }

    @Override
    public long getRegionSizeInBytes(int position, int length) {
        return this.value.getSizeInBytes();
    }

    @Override
    public long getPositionsSizeInBytes(@Nullable boolean[] positions, int selectedPositionCount) {
        return this.value.getSizeInBytes();
    }

    @Override
    public Block copyRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.positionCount, positionOffset, length);
        return RunLengthEncodedBlock.create(this.value.copyRegion(0, 1), length);
    }

    @Override
    public int getSliceLength(int position) {
        BlockUtil.checkReadablePosition(this, position);
        return this.value.getSliceLength(0);
    }

    @Override
    public byte getByte(int position, int offset) {
        BlockUtil.checkReadablePosition(this, position);
        return this.value.getByte(0, offset);
    }

    @Override
    public short getShort(int position, int offset) {
        BlockUtil.checkReadablePosition(this, position);
        return this.value.getShort(0, offset);
    }

    @Override
    public int getInt(int position, int offset) {
        BlockUtil.checkReadablePosition(this, position);
        return this.value.getInt(0, offset);
    }

    @Override
    public long getLong(int position, int offset) {
        BlockUtil.checkReadablePosition(this, position);
        return this.value.getLong(0, offset);
    }

    @Override
    public Slice getSlice(int position, int offset, int length) {
        BlockUtil.checkReadablePosition(this, position);
        return this.value.getSlice(0, offset, length);
    }

    @Override
    public <T> T getObject(int position, Class<T> clazz) {
        BlockUtil.checkReadablePosition(this, position);
        return this.value.getObject(0, clazz);
    }

    @Override
    public boolean bytesEqual(int position, int offset, Slice otherSlice, int otherOffset, int length) {
        BlockUtil.checkReadablePosition(this, position);
        return this.value.bytesEqual(0, offset, otherSlice, otherOffset, length);
    }

    @Override
    public int bytesCompare(int position, int offset, int length, Slice otherSlice, int otherOffset, int otherLength) {
        BlockUtil.checkReadablePosition(this, position);
        return this.value.bytesCompare(0, offset, length, otherSlice, otherOffset, otherLength);
    }

    @Override
    public void writeBytesTo(int position, int offset, int length, BlockBuilder blockBuilder) {
        BlockUtil.checkReadablePosition(this, position);
        this.value.writeBytesTo(0, offset, length, blockBuilder);
    }

    @Override
    public boolean equals(int position, int offset, Block otherBlock, int otherPosition, int otherOffset, int length) {
        BlockUtil.checkReadablePosition(this, position);
        return this.value.equals(0, offset, otherBlock, otherPosition, otherOffset, length);
    }

    @Override
    public long hash(int position, int offset, int length) {
        BlockUtil.checkReadablePosition(this, position);
        return this.value.hash(0, offset, length);
    }

    @Override
    public int compareTo(int leftPosition, int leftOffset, int leftLength, Block rightBlock, int rightPosition, int rightOffset, int rightLength) {
        BlockUtil.checkReadablePosition(this, leftPosition);
        return this.value.compareTo(0, leftOffset, leftLength, rightBlock, rightPosition, rightOffset, rightLength);
    }

    @Override
    public Block getSingleValueBlock(int position) {
        BlockUtil.checkReadablePosition(this, position);
        return this.value;
    }

    @Override
    public boolean mayHaveNull() {
        return this.positionCount > 0 && this.value.isNull(0);
    }

    @Override
    public boolean isNull(int position) {
        BlockUtil.checkReadablePosition(this, position);
        return this.value.isNull(0);
    }

    @Override
    public Block copyWithAppendedNull() {
        if (this.value.isNull(0)) {
            return RunLengthEncodedBlock.create(this.value, this.positionCount + 1);
        }
        Block dictionary = this.value.copyWithAppendedNull();
        int[] ids = new int[this.positionCount + 1];
        ids[this.positionCount] = 1;
        return DictionaryBlock.create(ids.length, dictionary, ids);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("{positionCount=").append(this.positionCount);
        sb.append(", value=").append(this.value);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean isLoaded() {
        return this.value.isLoaded();
    }

    @Override
    public Block getLoadedBlock() {
        Block loadedValueBlock = this.value.getLoadedBlock();
        if (loadedValueBlock == this.value) {
            return this;
        }
        return RunLengthEncodedBlock.create(loadedValueBlock, this.positionCount);
    }
}

