/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.ptf;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.spi.Experimental;
import io.trino.spi.ptf.Argument;
import io.trino.spi.ptf.Descriptor;
import java.util.Objects;
import java.util.Optional;

@Experimental(eta="2022-10-31")
public class DescriptorArgument
extends Argument {
    public static final DescriptorArgument NULL_DESCRIPTOR = DescriptorArgument.builder().build();
    private final Optional<Descriptor> descriptor;

    @JsonCreator
    public DescriptorArgument(@JsonProperty(value="descriptor") Optional<Descriptor> descriptor) {
        this.descriptor = Objects.requireNonNull(descriptor, "descriptor is null");
    }

    @JsonProperty
    public Optional<Descriptor> getDescriptor() {
        return this.descriptor;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Descriptor descriptor;

        private Builder() {
        }

        public Builder descriptor(Descriptor descriptor) {
            this.descriptor = descriptor;
            return this;
        }

        public DescriptorArgument build() {
            return new DescriptorArgument(Optional.ofNullable(this.descriptor));
        }
    }
}

