/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.predicate;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.predicate.AllOrNone;
import io.trino.spi.predicate.DiscreteValues;
import io.trino.spi.predicate.Primitives;
import io.trino.spi.predicate.Ranges;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.predicate.ValuesProcessor;
import io.trino.spi.type.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.openjdk.jol.info.ClassLayout;

public class AllOrNoneValueSet
implements ValueSet {
    private static final int INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(AllOrNoneValueSet.class).instanceSize());
    private final Type type;
    private final boolean all;

    @JsonCreator
    public AllOrNoneValueSet(@JsonProperty(value="type") Type type, @JsonProperty(value="all") boolean all) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.all = all;
    }

    static AllOrNoneValueSet all(Type type) {
        return new AllOrNoneValueSet(type, true);
    }

    static AllOrNoneValueSet none(Type type) {
        return new AllOrNoneValueSet(type, false);
    }

    @Override
    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @Override
    public boolean isNone() {
        return !this.all;
    }

    @Override
    @JsonProperty
    public boolean isAll() {
        return this.all;
    }

    @Override
    public boolean isSingleValue() {
        return false;
    }

    @Override
    public Object getSingleValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDiscreteSet() {
        return false;
    }

    @Override
    public List<Object> getDiscreteSet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        Objects.requireNonNull(value, "value is null");
        Class<?> expectedClass = Primitives.wrap(this.type.getJavaType());
        if (!expectedClass.isInstance(value)) {
            throw new IllegalArgumentException(String.format("Value class %s does not match required class %s", value.getClass().getName(), expectedClass.getName()));
        }
        return this.all;
    }

    public AllOrNone getAllOrNone() {
        return () -> this.all;
    }

    @Override
    public ValuesProcessor getValuesProcessor() {
        return new ValuesProcessor(){

            @Override
            public <T> T transform(Function<Ranges, T> rangesFunction, Function<DiscreteValues, T> valuesFunction, Function<AllOrNone, T> allOrNoneFunction) {
                return allOrNoneFunction.apply(AllOrNoneValueSet.this.getAllOrNone());
            }

            @Override
            public void consume(Consumer<Ranges> rangesConsumer, Consumer<DiscreteValues> valuesConsumer, Consumer<AllOrNone> allOrNoneConsumer) {
                allOrNoneConsumer.accept(AllOrNoneValueSet.this.getAllOrNone());
            }
        };
    }

    @Override
    public ValueSet intersect(ValueSet other) {
        AllOrNoneValueSet otherValueSet = this.checkCompatibility(other);
        return new AllOrNoneValueSet(this.type, this.all && otherValueSet.all);
    }

    @Override
    public ValueSet union(ValueSet other) {
        AllOrNoneValueSet otherValueSet = this.checkCompatibility(other);
        return new AllOrNoneValueSet(this.type, this.all || otherValueSet.all);
    }

    @Override
    public ValueSet complement() {
        return new AllOrNoneValueSet(this.type, !this.all);
    }

    @Override
    public String toString() {
        return "[" + (this.all ? "ALL" : "NONE") + "]";
    }

    @Override
    public String toString(ConnectorSession session) {
        return this.toString();
    }

    @Override
    public String toString(ConnectorSession session, int limit) {
        return this.toString();
    }

    @Override
    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE;
    }

    @Override
    public Optional<Collection<Object>> tryExpandRanges(int valuesLimit) {
        if (this.isNone()) {
            return Optional.of(List.of());
        }
        return Optional.empty();
    }

    public int hashCode() {
        return Objects.hash(this.type, this.all);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AllOrNoneValueSet other = (AllOrNoneValueSet)obj;
        return Objects.equals(this.type, other.type) && this.all == other.all;
    }

    private AllOrNoneValueSet checkCompatibility(ValueSet other) {
        if (!this.getType().equals(other.getType())) {
            throw new IllegalArgumentException(String.format("Mismatched types: %s vs %s", this.getType(), other.getType()));
        }
        if (!(other instanceof AllOrNoneValueSet)) {
            throw new IllegalArgumentException(String.format("ValueSet is not a AllOrNoneValueSet: %s", other.getClass()));
        }
        return (AllOrNoneValueSet)other;
    }
}

