/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.ptf;

import io.trino.spi.Experimental;
import io.trino.spi.ptf.ConnectorTableFunctionHandle;
import io.trino.spi.ptf.Descriptor;
import io.trino.spi.ptf.Preconditions;
import java.util.Objects;
import java.util.Optional;

@Experimental(eta="2022-10-31")
public final class TableFunctionAnalysis {
    private final Optional<Descriptor> returnedType;
    private final ConnectorTableFunctionHandle handle;

    private TableFunctionAnalysis(Optional<Descriptor> returnedType, ConnectorTableFunctionHandle handle) {
        this.returnedType = Objects.requireNonNull(returnedType, "returnedType is null");
        returnedType.ifPresent(descriptor -> Preconditions.checkArgument(descriptor.isTyped(), "field types not specified"));
        this.handle = Objects.requireNonNull(handle, "handle is null");
    }

    public Optional<Descriptor> getReturnedType() {
        return this.returnedType;
    }

    public ConnectorTableFunctionHandle getHandle() {
        return this.handle;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Descriptor returnedType;
        private ConnectorTableFunctionHandle handle = new ConnectorTableFunctionHandle(){};

        private Builder() {
        }

        public Builder returnedType(Descriptor returnedType) {
            this.returnedType = returnedType;
            return this;
        }

        public Builder handle(ConnectorTableFunctionHandle handle) {
            this.handle = handle;
            return this;
        }

        public TableFunctionAnalysis build() {
            return new TableFunctionAnalysis(Optional.ofNullable(this.returnedType), this.handle);
        }
    }
}

