/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.trino.spi.block.AbstractRowBlock;
import io.trino.spi.block.Block;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.LazyBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ColumnarRow {
    private final int positionCount;
    @Nullable
    private final Block nullCheckBlock;
    private final Block[] fields;

    public static ColumnarRow toColumnarRow(Block block) {
        Objects.requireNonNull(block, "block is null");
        if (block instanceof LazyBlock) {
            block = ((LazyBlock)block).getBlock();
        }
        if (block instanceof DictionaryBlock) {
            return ColumnarRow.toColumnarRow((DictionaryBlock)block);
        }
        if (block instanceof RunLengthEncodedBlock) {
            return ColumnarRow.toColumnarRow((RunLengthEncodedBlock)block);
        }
        if (!(block instanceof AbstractRowBlock)) {
            throw new IllegalArgumentException("Invalid row block: " + block.getClass().getName());
        }
        AbstractRowBlock rowBlock = (AbstractRowBlock)block;
        int firstRowPosition = rowBlock.getFieldBlockOffset(0);
        int totalRowCount = rowBlock.getFieldBlockOffset(block.getPositionCount()) - firstRowPosition;
        Block[] fieldBlocks = new Block[rowBlock.numFields];
        for (int i = 0; i < fieldBlocks.length; ++i) {
            fieldBlocks[i] = rowBlock.getRawFieldBlocks()[i].getRegion(firstRowPosition, totalRowCount);
        }
        return new ColumnarRow(block.getPositionCount(), block, fieldBlocks);
    }

    private static ColumnarRow toColumnarRow(DictionaryBlock dictionaryBlock) {
        if (!dictionaryBlock.mayHaveNull()) {
            return ColumnarRow.toColumnarRowFromDictionaryWithoutNulls(dictionaryBlock);
        }
        Block dictionary = dictionaryBlock.getDictionary();
        int[] newDictionaryIndex = new int[dictionary.getPositionCount()];
        int nextNewDictionaryIndex = 0;
        for (int position = 0; position < dictionary.getPositionCount(); ++position) {
            if (dictionary.isNull(position)) continue;
            newDictionaryIndex[position] = nextNewDictionaryIndex++;
        }
        int[] dictionaryIds = new int[dictionaryBlock.getPositionCount()];
        int nonNullPositionCount = 0;
        for (int position = 0; position < dictionaryBlock.getPositionCount(); ++position) {
            if (dictionaryBlock.isNull(position)) continue;
            int oldDictionaryId = dictionaryBlock.getId(position);
            dictionaryIds[nonNullPositionCount] = newDictionaryIndex[oldDictionaryId];
            ++nonNullPositionCount;
        }
        ColumnarRow columnarRow = ColumnarRow.toColumnarRow(dictionaryBlock.getDictionary());
        Block[] fields = new Block[columnarRow.getFieldCount()];
        for (int i = 0; i < columnarRow.getFieldCount(); ++i) {
            fields[i] = DictionaryBlock.create(nonNullPositionCount, columnarRow.getField(i), dictionaryIds);
        }
        int positionCount = dictionaryBlock.getPositionCount();
        if (nonNullPositionCount == positionCount) {
            dictionaryBlock = null;
        }
        return new ColumnarRow(positionCount, dictionaryBlock, fields);
    }

    private static ColumnarRow toColumnarRowFromDictionaryWithoutNulls(DictionaryBlock dictionaryBlock) {
        ColumnarRow columnarRow = ColumnarRow.toColumnarRow(dictionaryBlock.getDictionary());
        Block[] fields = new Block[columnarRow.getFieldCount()];
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = new DictionaryBlock(dictionaryBlock.getRawIdsOffset(), dictionaryBlock.getPositionCount(), columnarRow.getField(i), dictionaryBlock.getRawIds());
        }
        return new ColumnarRow(dictionaryBlock.getPositionCount(), null, fields);
    }

    private static ColumnarRow toColumnarRow(RunLengthEncodedBlock rleBlock) {
        Block rleValue = rleBlock.getValue();
        ColumnarRow columnarRow = ColumnarRow.toColumnarRow(rleValue);
        Block[] fields = new Block[columnarRow.getFieldCount()];
        for (int i = 0; i < columnarRow.getFieldCount(); ++i) {
            Block nullSuppressedField = columnarRow.getField(i);
            if (rleValue.isNull(0)) {
                if (nullSuppressedField.getPositionCount() != 0) {
                    throw new IllegalArgumentException("Invalid row block");
                }
                fields[i] = nullSuppressedField;
                continue;
            }
            fields[i] = RunLengthEncodedBlock.create(nullSuppressedField, rleBlock.getPositionCount());
        }
        return new ColumnarRow(rleBlock.getPositionCount(), rleBlock, fields);
    }

    private ColumnarRow(int positionCount, @Nullable Block nullCheckBlock, Block[] fields) {
        this.positionCount = positionCount;
        this.nullCheckBlock = nullCheckBlock != null && nullCheckBlock.mayHaveNull() ? nullCheckBlock : null;
        this.fields = fields;
    }

    public int getPositionCount() {
        return this.positionCount;
    }

    public boolean mayHaveNull() {
        return this.nullCheckBlock != null;
    }

    public boolean isNull(int position) {
        return this.nullCheckBlock != null && this.nullCheckBlock.isNull(position);
    }

    public int getFieldCount() {
        return this.fields.length;
    }

    public Block getField(int index) {
        return this.fields[index];
    }

    public Block getNullCheckBlock() {
        return this.nullCheckBlock;
    }
}

