/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.trino.spi.type.Timestamps;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public final class LongTimestamp
implements Comparable<LongTimestamp> {
    public static final int INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(LongTimestamp.class).instanceSize());
    private static final int PICOSECONDS_PER_MICROSECOND = 1000000;
    private final long epochMicros;
    private final int picosOfMicro;

    public LongTimestamp(long epochMicros, int picosOfMicro) {
        if (picosOfMicro < 0) {
            throw new IllegalArgumentException("picosOfMicro must be >= 0: " + picosOfMicro);
        }
        if (picosOfMicro >= 1000000) {
            throw new IllegalArgumentException("picosOfMicro must be < 1_000_000: " + picosOfMicro);
        }
        this.epochMicros = epochMicros;
        this.picosOfMicro = picosOfMicro;
    }

    public long getEpochMicros() {
        return this.epochMicros;
    }

    public int getPicosOfMicro() {
        return this.picosOfMicro;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LongTimestamp that = (LongTimestamp)o;
        return this.epochMicros == that.epochMicros && this.picosOfMicro == that.picosOfMicro;
    }

    public int hashCode() {
        return Objects.hash(this.epochMicros, this.picosOfMicro);
    }

    @Override
    public int compareTo(LongTimestamp other) {
        int value = Long.compare(this.epochMicros, other.epochMicros);
        if (value != 0) {
            return value;
        }
        return Integer.compare(this.picosOfMicro, other.picosOfMicro);
    }

    public String toString() {
        return Timestamps.formatTimestamp(12, this.epochMicros, this.picosOfMicro);
    }
}

